/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001:\u0001FB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000fJ\b\u00102\u001a\u000203H\u0004J\u0018\u00104\u001a\u00020/2\u0006\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020/H\u0004J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0004J\u0010\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\u001fH\u0004J(\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020/2\u0006\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020/H\u0002J@\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020/2\u0006\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020/H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u0014\u0010%\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010!R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/diff/tools/fragmented/UnifiedFragmentBuilder;", "", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "masterSide", "Lcom/intellij/diff/util/Side;", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/util/Side;)V", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lcom/intellij/diff/util/Side;)V", "getText1", "()Ljava/lang/CharSequence;", "getText2", "getLineOffsets1", "()Lcom/intellij/diff/tools/util/text/LineOffsets;", "getLineOffsets2", "getMasterSide", "()Lcom/intellij/diff/util/Side;", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTextBuilder", "()Ljava/lang/StringBuilder;", "changes", "", "Lcom/intellij/diff/tools/fragmented/UnifiedDiffChange;", "getChanges", "()Ljava/util/List;", "ranges", "Lcom/intellij/diff/tools/fragmented/HighlightRange;", "getRanges", "convertorBuilder1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor$Builder;", "getConvertorBuilder1", "()Lcom/intellij/diff/tools/fragmented/LineNumberConvertor$Builder;", "convertorBuilder2", "getConvertorBuilder2", "changedLines", "Lcom/intellij/diff/util/LineRange;", "getChangedLines", "lastProcessedLine1", "", "lastProcessedLine2", "totalLines", "finishDocuments", "", "processEquals", "endLine1", "endLine2", "processChanged", "Lcom/intellij/diff/tools/fragmented/UnifiedFragmentBuilder$BlockLineRange;", "fragment", "Lcom/intellij/diff/util/Range;", "reportChange", "change", "appendTextMaster", "startLine1", "startLine2", "appendText", "side", "offset1", "offset2", "lines1", "lines2", "BlockLineRange", "intellij.platform.diff.impl"})
public abstract class UnifiedFragmentBuilder {
    @NotNull
    private final CharSequence text1;
    @NotNull
    private final CharSequence text2;
    @NotNull
    private final LineOffsets lineOffsets1;
    @NotNull
    private final LineOffsets lineOffsets2;
    @NotNull
    private final Side masterSide;
    @NotNull
    private final StringBuilder textBuilder;
    @NotNull
    private final List<UnifiedDiffChange> changes;
    @NotNull
    private final List<HighlightRange> ranges;
    @NotNull
    private final LineNumberConvertor.Builder convertorBuilder1;
    @NotNull
    private final LineNumberConvertor.Builder convertorBuilder2;
    @NotNull
    private final List<LineRange> changedLines;
    private int lastProcessedLine1;
    private int lastProcessedLine2;
    private int totalLines;

    public UnifiedFragmentBuilder(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull Side masterSide) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
        Intrinsics.checkNotNullParameter((Object)masterSide, (String)"masterSide");
        this.text1 = text1;
        this.text2 = text2;
        this.lineOffsets1 = lineOffsets1;
        this.lineOffsets2 = lineOffsets2;
        this.masterSide = masterSide;
        this.textBuilder = new StringBuilder();
        this.changes = new ArrayList();
        this.ranges = new ArrayList();
        this.convertorBuilder1 = new LineNumberConvertor.Builder();
        this.convertorBuilder2 = new LineNumberConvertor.Builder();
        this.changedLines = new ArrayList();
        this.lastProcessedLine1 = -1;
        this.lastProcessedLine2 = -1;
    }

    @NotNull
    protected final CharSequence getText1() {
        return this.text1;
    }

    @NotNull
    protected final CharSequence getText2() {
        return this.text2;
    }

    @NotNull
    protected final LineOffsets getLineOffsets1() {
        return this.lineOffsets1;
    }

    @NotNull
    protected final LineOffsets getLineOffsets2() {
        return this.lineOffsets2;
    }

    @NotNull
    protected final Side getMasterSide() {
        return this.masterSide;
    }

    public UnifiedFragmentBuilder(@NotNull Document document1, @NotNull Document document2, @NotNull Side masterSide) {
        Intrinsics.checkNotNullParameter((Object)document1, (String)"document1");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document2");
        Intrinsics.checkNotNullParameter((Object)masterSide, (String)"masterSide");
        CharSequence charSequence = document1.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence charSequence2 = document2.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
        LineOffsets lineOffsets = LineOffsetsUtil.create(document1);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets lineOffsets2 = LineOffsetsUtil.create(document2);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(...)");
        this(charSequence, charSequence2, lineOffsets, lineOffsets2, masterSide);
    }

    @NotNull
    protected final StringBuilder getTextBuilder() {
        return this.textBuilder;
    }

    @NotNull
    protected final List<UnifiedDiffChange> getChanges() {
        return this.changes;
    }

    @NotNull
    protected final List<HighlightRange> getRanges() {
        return this.ranges;
    }

    @NotNull
    protected final LineNumberConvertor.Builder getConvertorBuilder1() {
        return this.convertorBuilder1;
    }

    @NotNull
    protected final LineNumberConvertor.Builder getConvertorBuilder2() {
        return this.convertorBuilder2;
    }

    @NotNull
    protected final List<LineRange> getChangedLines() {
        return this.changedLines;
    }

    protected final void finishDocuments() {
        this.processEquals(this.lineOffsets1.getLineCount() - 1, this.lineOffsets2.getLineCount() - 1);
    }

    protected final int processEquals(int endLine1, int endLine2) {
        int startLine1 = this.lastProcessedLine1 + 1;
        int startLine2 = this.lastProcessedLine2 + 1;
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
        this.appendTextMaster(startLine1, startLine2, endLine1, endLine2);
        return this.totalLines;
    }

    @NotNull
    protected final BlockLineRange processChanged(@NotNull Range fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.processEquals(fragment.start1 - 1, fragment.start2 - 1);
        int startLine1 = fragment.start1;
        int endLine1 = fragment.end1 - 1;
        int lines1 = endLine1 - startLine1;
        int startLine2 = fragment.start2;
        int endLine2 = fragment.end2 - 1;
        int lines2 = endLine2 - startLine2;
        int linesBefore = this.totalLines;
        if (lines1 >= 0) {
            int startOffset1 = this.lineOffsets1.getLineStart(startLine1);
            int endOffset1 = this.lineOffsets1.getLineEnd(endLine1);
            this.appendText(Side.LEFT, startOffset1, endOffset1, lines1, lines2, startLine1, -1);
        }
        int linesBetween = this.totalLines;
        if (lines2 >= 0) {
            int startOffset2 = this.lineOffsets2.getLineStart(startLine2);
            int endOffset2 = this.lineOffsets2.getLineEnd(endLine2);
            this.appendText(Side.RIGHT, startOffset2, endOffset2, lines2, lines2, -1, startLine2);
        }
        int linesAfter = this.totalLines;
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
        return new BlockLineRange(linesBefore, linesBetween, linesAfter);
    }

    protected final void reportChange(@NotNull UnifiedDiffChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        this.changes.add(change);
        if (!change.isSkipped()) {
            this.changedLines.add(new LineRange(change.getLine1(), change.getLine2()));
        }
    }

    private final void appendTextMaster(int startLine1, int startLine2, int endLine1, int endLine2) {
        int lines1 = endLine1 - startLine1;
        int lines2 = endLine2 - startLine2;
        if (this.masterSide.select(lines1, lines2) >= 0) {
            int startOffset = this.masterSide.isLeft() ? this.lineOffsets1.getLineStart(startLine1) : this.lineOffsets2.getLineStart(startLine2);
            int endOffset = this.masterSide.isLeft() ? this.lineOffsets1.getLineEnd(endLine1) : this.lineOffsets2.getLineEnd(endLine2);
            this.appendText(this.masterSide, startOffset, endOffset, lines1, lines2, startLine1, startLine2);
        }
    }

    private final void appendText(Side side, int offset1, int offset2, int lines1, int lines2, int startLine1, int startLine2) {
        int appendix;
        int lines = side.select(lines1, lines2);
        boolean notEmpty = lines >= 0;
        int n = appendix = notEmpty ? 1 : 0;
        if (startLine1 != -1) {
            this.convertorBuilder1.put(this.totalLines, startLine1, lines + appendix, lines1 + appendix);
        }
        if (startLine2 != -1) {
            this.convertorBuilder2.put(this.totalLines, startLine2, lines + appendix, lines2 + appendix);
        }
        if (notEmpty) {
            LineOffsets lineOffsets = (LineOffsets)side.selectNotNull((Object)this.lineOffsets1, (Object)this.lineOffsets2);
            CharSequence text = (CharSequence)side.selectNotNull((Object)this.text1, (Object)this.text2);
            int newline = lineOffsets.getTextLength() > offset2 + 1 ? 1 : 0;
            TextRange base = new TextRange(this.textBuilder.length(), this.textBuilder.length() + offset2 - offset1 + newline);
            TextRange changed = new TextRange(offset1, offset2 + newline);
            this.ranges.add(new HighlightRange(side, base, changed));
            this.textBuilder.append(text.subSequence(offset1, offset2));
            this.textBuilder.append('\n');
            this.totalLines += lines + 1;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/fragmented/UnifiedFragmentBuilder$BlockLineRange;", "", "blockStart", "", "insertedStart", "blockEnd", "<init>", "(III)V", "getBlockStart", "()I", "getInsertedStart", "getBlockEnd", "intellij.platform.diff.impl"})
    protected static final class BlockLineRange {
        private final int blockStart;
        private final int insertedStart;
        private final int blockEnd;

        public BlockLineRange(int blockStart, int insertedStart, int blockEnd) {
            this.blockStart = blockStart;
            this.insertedStart = insertedStart;
            this.blockEnd = blockEnd;
        }

        public final int getBlockStart() {
            return this.blockStart;
        }

        public final int getInsertedStart() {
            return this.insertedStart;
        }

        public final int getBlockEnd() {
            return this.blockEnd;
        }
    }
}

