/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffTitleHandler;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnesideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @ApiStatus.Internal
    @NotNull
    protected final OnesideContentPanel myContentPanel;
    @NotNull
    private final Side mySide;
    @NotNull
    private final T myHolder;

    public OnesideDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            OnesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            OnesideDiffViewer.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            OnesideDiffViewer.$$$reportNull$$$0(2);
        }
        super(context, request);
        this.mySide = Side.fromRight((boolean)(this.myRequest.getContents().get(0) instanceof EmptyContent));
        this.myHolder = this.createEditorHolder(factory);
        this.myContentPanel = OnesideContentPanel.createFromHolder(this.myHolder);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, context){

            @Override
            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.uiDataSnapshot(sink);
                DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)OnesideDiffViewer.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/diff/tools/util/side/OnesideDiffViewer$1", "uiDataSnapshot"));
            }
        };
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications(this, (UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
        DiffTitleHandler.createHandler(() -> this.createTitle(), this.myContentPanel, this.myRequest, (Disposable)this);
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
        this.destroyEditorHolder();
        super.onDispose();
    }

    @NotNull
    protected T createEditorHolder(@NotNull EditorHolderFactory<T> factory) {
        if (factory == null) {
            OnesideDiffViewer.$$$reportNull$$$0(3);
        }
        DiffContent content = (DiffContent)this.mySide.select(this.myRequest.getContents());
        T t = factory.create(content, this.myContext);
        if (t == null) {
            OnesideDiffViewer.$$$reportNull$$$0(4);
        }
        return t;
    }

    private void destroyEditorHolder() {
        Disposer.dispose(this.myHolder);
    }

    @Nullable
    protected JComponent createTitle() {
        List<JComponent> simpleTitles = DiffUtil.createSimpleTitles(this, this.myRequest);
        return (JComponent)this.getSide().select(simpleTitles);
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            OnesideDiffViewer.$$$reportNull$$$0(5);
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public Side getSide() {
        Side side = this.mySide;
        if (side == null) {
            OnesideDiffViewer.$$$reportNull$$$0(6);
        }
        return side;
    }

    @NotNull
    protected DiffContent getContent() {
        DiffContent diffContent = (DiffContent)this.mySide.select(this.myRequest.getContents());
        if (diffContent == null) {
            OnesideDiffViewer.$$$reportNull$$$0(7);
        }
        return diffContent;
    }

    @NotNull
    protected T getEditorHolder() {
        T t = this.myHolder;
        if (t == null) {
            OnesideDiffViewer.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            OnesideDiffViewer.$$$reportNull$$$0(9);
        }
        super.uiDataSnapshot(sink);
        sink.set(DiffDataKeys.CURRENT_CONTENT, (Object)this.getContent());
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return this.getContent().getNavigatable();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            OnesideDiffViewer.$$$reportNull$$$0(10);
        }
        if (request == null) {
            OnesideDiffViewer.$$$reportNull$$$0(11);
        }
        if (factory == null) {
            OnesideDiffViewer.$$$reportNull$$$0(12);
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        DiffContent content1 = (DiffContent)contents.get(0);
        DiffContent content2 = (DiffContent)contents.get(1);
        if (content1 instanceof EmptyContent) {
            return factory.canShowContent(content2, context) && factory.wantShowContent(content2, context);
        }
        if (content2 instanceof EmptyContent) {
            return factory.canShowContent(content1, context) && factory.wantShowContent(content1, context);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/OnesideDiffViewer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/OnesideDiffViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSide";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

