/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    @Deprecated
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFilesAction.DiffRequest");
    @NonNls
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    @NonNls
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        String text = ActionsBundle.message((String)"action.compare.files.text", (Object[])new Object[0]);
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null) {
            if (files.length == 1) {
                text = ActionsBundle.message((String)"action.compare.with.text", (Object[])new Object[0]);
            } else if (files.length == 2 || files.length == 3) {
                Set types = ContainerUtil.map2Set((Object[])files, CompareFilesAction::getType);
                if (types.size() != 1) {
                    text = ActionsBundle.message((String)"action.compare.text", (Object[])new Object[0]);
                } else {
                    text = ActionsBundle.message((String)(switch (((Type)((Object)types.iterator().next())).ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> "action.compare.files.text";
                        case 1 -> "action.CompareDirs.text";
                        case 2 -> "action.compare.archives.text";
                    }), (Object[])new Object[0]);
                }
            }
        }
        e.getPresentation().setText(text);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CompareFilesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Set types;
        DiffRequest request;
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(2);
        }
        if ((request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST_TO_COMPARE)) != null) {
            return true;
        }
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return false;
        }
        if (files.length == 0 || files.length > 3) {
            return false;
        }
        boolean hasContent = ContainerUtil.all(Arrays.asList(files), BaseShowDiffAction::hasContent);
        if (!hasContent) {
            return false;
        }
        return files.length != 3 || !(types = ContainerUtil.map2Set((Object[])files, CompareFilesAction::getType)).contains((Object)Type.DIRECTORY) && !types.contains((Object)Type.ARCHIVE);
    }

    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(3);
        }
        return (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST_TO_COMPARE);
    }

    @Override
    @Nullable
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        VirtualFile file2;
        VirtualFile file1;
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        DiffRequest diffRequest = this.getDiffRequest(e);
        if (diffRequest != null) {
            return new SimpleDiffRequestChain(diffRequest);
        }
        VirtualFile baseFile = null;
        Object[] files = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files.length == 1) {
            file1 = files[0];
            file2 = CompareFilesAction.getOtherFile(project, file1);
            if (file2 == null || !CompareFilesAction.hasContent(file2)) {
                return null;
            }
        } else if (files.length == 2) {
            file1 = files[0];
            file2 = files[1];
        } else {
            file1 = files[0];
            baseFile = files[1];
            file2 = files[2];
        }
        if (!file1.isValid() || !file2.isValid() || baseFile != null && !baseFile.isValid()) {
            return null;
        }
        Set types = ContainerUtil.map2Set((Object[])files, CompareFilesAction::getType);
        if (types.contains((Object)Type.DIRECTORY)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("dir.diff");
        }
        if (types.contains((Object)Type.ARCHIVE)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("jar.diff");
        }
        if ("ipynb".equals(file1.getExtension()) && "ipynb".equals(file2.getExtension())) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("jupyter.compare.notebooks");
        }
        return CompareFilesAction.createMutableChainFromFiles(project, file1, file2, baseFile);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project, @NotNull VirtualFile file) {
        String key;
        FileChooserDescriptor descriptor;
        Type type;
        if (file == null) {
            CompareFilesAction.$$$reportNull$$$0(5);
        }
        if ((type = CompareFilesAction.getType(file)) == Type.DIRECTORY || type == Type.ARCHIVE) {
            descriptor = new FileChooserDescriptor(false, true, true, true, true, false);
            key = LAST_USED_FOLDER_KEY;
        } else {
            descriptor = new FileChooserDescriptor(true, false, false, true, true, false);
            key = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project, key, file);
        VirtualFile otherFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor.withTitle(DiffBundle.message((String)"select.file.to.compare", (Object[])new Object[0])), (Project)project, (VirtualFile)selectedFile);
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project, key, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file) {
        if (key == null) {
            CompareFilesAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CompareFilesAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                CompareFilesAction.$$$reportNull$$$0(8);
            }
            return virtualFile;
        }
        String path = PropertiesComponent.getInstance((Project)project).getValue(key);
        if (path == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                CompareFilesAction.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile virtualFile = lastSelection != null ? lastSelection : file;
        if (virtualFile == null) {
            CompareFilesAction.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    private static void updateDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file) {
        if (key == null) {
            CompareFilesAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            CompareFilesAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project).setValue(key, file.getPath());
    }

    @NotNull
    private static Type getType(@Nullable VirtualFile file) {
        if (file == null) {
            Type type = Type.FILE;
            if (type == null) {
                CompareFilesAction.$$$reportNull$$$0(13);
            }
            return type;
        }
        if (file.getFileType() instanceof ArchiveFileType) {
            Type type = Type.ARCHIVE;
            if (type == null) {
                CompareFilesAction.$$$reportNull$$$0(14);
            }
            return type;
        }
        if (file.isDirectory()) {
            Type type = Type.DIRECTORY;
            if (type == null) {
                CompareFilesAction.$$$reportNull$$$0(15);
            }
            return type;
        }
        Type type = Type.FILE;
        if (type == null) {
            CompareFilesAction.$$$reportNull$$$0(16);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9, 10, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareFilesAction";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareFilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSelection";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestChain";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOtherFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSelection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9, 10, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static enum Type {
        FILE,
        DIRECTORY,
        ARCHIVE;

    }
}

