/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class DocumentsSynchronizer {
    @NotNull
    protected final Document myDocument1;
    @NotNull
    protected final Document myDocument2;
    @Nullable
    protected final Project myProject;
    protected boolean myDuringModification;
    private final DocumentListener myListener1;
    private final DocumentListener myListener2;
    private final PropertyChangeListener myROListener;

    protected DocumentsSynchronizer(@Nullable Project project, @NotNull Document document1, @NotNull Document document2) {
        if (document1 == null) {
            DocumentsSynchronizer.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            DocumentsSynchronizer.$$$reportNull$$$0(1);
        }
        this.myDuringModification = false;
        this.myListener1 = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DocumentsSynchronizer.this.myDuringModification) {
                    return;
                }
                DocumentsSynchronizer.this.onDocumentChanged1(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/DocumentsSynchronizer$1", "documentChanged"));
            }
        };
        this.myListener2 = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DocumentsSynchronizer.this.myDuringModification) {
                    return;
                }
                DocumentsSynchronizer.this.onDocumentChanged2(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/DocumentsSynchronizer$2", "documentChanged"));
            }
        };
        this.myROListener = event -> {
            if ("writable".equals(event.getPropertyName())) {
                this.getDocument2().setReadOnly(!this.getDocument1().isWritable());
            }
        };
        this.myProject = project;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
    }

    @NotNull
    public Document getDocument1() {
        Document document = this.myDocument1;
        if (document == null) {
            DocumentsSynchronizer.$$$reportNull$$$0(2);
        }
        return document;
    }

    @NotNull
    public Document getDocument2() {
        Document document = this.myDocument2;
        if (document == null) {
            DocumentsSynchronizer.$$$reportNull$$$0(3);
        }
        return document;
    }

    protected abstract void onDocumentChanged1(@NotNull DocumentEvent var1);

    protected abstract void onDocumentChanged2(@NotNull DocumentEvent var1);

    public void startListen() {
        this.myDocument1.addDocumentListener(this.myListener1);
        this.myDocument2.addDocumentListener(this.myListener2);
        this.myDocument1.addPropertyChangeListener(this.myROListener);
    }

    public void stopListen() {
        this.myDocument1.removeDocumentListener(this.myListener1);
        this.myDocument2.removeDocumentListener(this.myListener2);
        this.myDocument1.removePropertyChangeListener(this.myROListener);
    }

    @NotNull
    public static Document createFakeDocument(@NotNull Document original) {
        if (original == null) {
            DocumentsSynchronizer.$$$reportNull$$$0(4);
        }
        EditorFactoryImpl editorFactory = (EditorFactoryImpl)EditorFactory.getInstance();
        boolean acceptsSlashR = original instanceof DocumentImpl && ((DocumentImpl)original).acceptsSlashR();
        boolean writeThreadOnly = original instanceof DocumentImpl && ((DocumentImpl)original).isWriteThreadOnly();
        Document document = editorFactory.createDocument((CharSequence)"", acceptsSlashR, !writeThreadOnly);
        document.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)original);
        Document document2 = document;
        if (document2 == null) {
            DocumentsSynchronizer.$$$reportNull$$$0(5);
        }
        return document2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/DocumentsSynchronizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/DocumentsSynchronizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument1";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakeDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFakeDocument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

