/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/applications/MyDiffRequestProducer;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getName", "", "getContentType", "Lcom/intellij/openapi/fileTypes/FileType;", "process", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDiffApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffApplication.kt\ncom/intellij/diff/applications/MyDiffRequestProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n295#2,2:111\n*S KotlinDebug\n*F\n+ 1 DiffApplication.kt\ncom/intellij/diff/applications/MyDiffRequestProducer\n*L\n97#1:111,2\n*E\n"})
final class MyDiffRequestProducer
implements DiffRequestProducer {
    @Nullable
    private final Project project;
    @NotNull
    private final List<VirtualFile> files;

    public MyDiffRequestProducer(@Nullable Project project, @NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.project = project;
        this.files = files;
    }

    @NotNull
    public String getName() {
        String string;
        if (this.files.size() == 3) {
            VirtualFile virtualFile = this.files.get(2);
            if (virtualFile == null) {
                String string2 = DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return string2;
            }
            VirtualFile base = virtualFile;
            String string3 = DiffRequestFactory.getInstance().getTitle(base);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            String string4 = DiffRequestFactory.getInstance().getTitleForComparison(this.files.get(0), this.files.get(1));
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    @Nullable
    public FileType getContentType() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.files;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        VirtualFile virtualFile = v0;
        return virtualFile != null ? virtualFile.getFileType() : null;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.files.size() == 3) {
            List<VirtualFile> list = DiffApplicationBase.replaceNullsWithEmptyFile(this.files);
            Intrinsics.checkNotNullExpressionValue(list, (String)"replaceNullsWithEmptyFile(...)");
            List<VirtualFile> nonNullFiles = list;
            ContentDiffRequest contentDiffRequest = DiffRequestFactory.getInstance().createFromFiles(this.project, nonNullFiles.get(0), nonNullFiles.get(2), nonNullFiles.get(1));
            Intrinsics.checkNotNull((Object)contentDiffRequest);
            diffRequest = (DiffRequest)contentDiffRequest;
        } else {
            ContentDiffRequest contentDiffRequest = DiffRequestFactory.getInstance().createFromFiles(this.project, this.files.get(0), this.files.get(1));
            Intrinsics.checkNotNull((Object)contentDiffRequest);
            diffRequest = (DiffRequest)contentDiffRequest;
        }
        return diffRequest;
    }
}

