/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TextMergeChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final TextMergeViewer myMergeViewer;
    @NotNull
    protected final MergeThreesideViewer myViewer;
    private final int myIndex;
    @NotNull
    private final MergeLineFragment myFragment;
    private final boolean myIsImportChange;
    protected final boolean[] myResolved;
    private boolean myOnesideAppliedConflict;
    private boolean myIsResolvedWithAI;
    @Nullable
    private MergeInnerDifferences myInnerFragments;
    private static final JBColor AI_COLOR = new JBColor(8605168, 10842598);

    @RequiresEdt
    public TextMergeChange(int index, boolean isImportChange, @NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @NotNull TextMergeViewer viewer) {
        if (fragment == null) {
            TextMergeChange.$$$reportNull$$$0(0);
        }
        if (conflictType == null) {
            TextMergeChange.$$$reportNull$$$0(1);
        }
        if (viewer == null) {
            TextMergeChange.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        super(conflictType);
        this.myResolved = new boolean[2];
        this.myMergeViewer = viewer;
        this.myViewer = viewer.getViewer();
        this.myIndex = index;
        this.myFragment = fragment;
        this.myIsImportChange = isImportChange;
        this.reinstallHighlighters();
    }

    @RequiresEdt
    public void reinstallHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.myViewer.repaintDividers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @RequiresEdt
    public void setResolved(@NotNull Side side, boolean value) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myResolved[side.getIndex()] = value;
        if (this.isResolved()) {
            this.destroyInnerHighlighters();
        } else {
            DocumentEx document = this.myViewer.getEditor((ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
            for (RangeHighlighter highlighter : this.myInnerHighlighters) {
                if (!document.equals((Object)highlighter.getDocument())) continue;
                highlighter.dispose();
            }
        }
    }

    public boolean isResolved() {
        return this.myResolved[0] && this.myResolved[1];
    }

    public boolean isResolved(@NotNull Side side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(4);
        }
        return side.select(this.myResolved);
    }

    public boolean isOnesideAppliedConflict() {
        return this.myOnesideAppliedConflict;
    }

    public void markOnesideAppliedConflict() {
        this.myOnesideAppliedConflict = true;
    }

    @ApiStatus.Internal
    void markChangeResolvedWithAI() {
        this.myIsResolvedWithAI = true;
    }

    @ApiStatus.Internal
    boolean isResolvedWithAI() {
        return this.myIsResolvedWithAI;
    }

    public boolean isImportChange() {
        return this.myIsImportChange;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(5);
        }
        return switch (side) {
            default -> throw new MatchException(null, null);
            case ThreeSide.LEFT -> this.isResolved(Side.LEFT);
            case ThreeSide.BASE -> this.isResolved();
            case ThreeSide.RIGHT -> this.isResolved(Side.RIGHT);
        };
    }

    public int getStartLine() {
        return this.myViewer.getModel().getLineStart(this.myIndex);
    }

    public int getEndLine() {
        return this.myViewer.getModel().getLineEnd(this.myIndex);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(6);
        }
        if (side == ThreeSide.BASE) {
            return this.getStartLine();
        }
        return this.myFragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(7);
        }
        if (side == ThreeSide.BASE) {
            return this.getEndLine();
        }
        return this.myFragment.getEndLine(side);
    }

    @Override
    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType baseType = super.getDiffType();
        if (!this.myIsResolvedWithAI) {
            TextDiffType textDiffType = baseType;
            if (textDiffType == null) {
                TextMergeChange.$$$reportNull$$$0(8);
            }
            return textDiffType;
        }
        return new MyAIResolvedDiffType(baseType);
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(9);
        }
        EditorEx editorEx = this.myViewer.getEditor(side);
        if (editorEx == null) {
            TextMergeChange.$$$reportNull$$$0(10);
        }
        return editorEx;
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    @NotNull
    public MergeLineFragment getFragment() {
        MergeLineFragment mergeLineFragment = this.myFragment;
        if (mergeLineFragment == null) {
            TextMergeChange.$$$reportNull$$$0(11);
        }
        return mergeLineFragment;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setInnerFragments(@Nullable MergeInnerDifferences mergeInnerDifferences) {
        void innerFragments;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myInnerFragments == null && innerFragments == null) {
            return;
        }
        this.myInnerFragments = innerFragments;
        this.reinstallHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    @Override
    @RequiresEdt
    protected void installOperations() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myViewer.isExternalOperationInProgress()) {
            return;
        }
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createResolveOperation());
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.LEFT, OperationType.APPLY));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.LEFT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.RIGHT, OperationType.APPLY));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.RIGHT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createResetOperation());
    }

    @Nullable
    private DiffGutterOperation createOperation(@NotNull ThreeSide side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            TextMergeChange.$$$reportNull$$$0(13);
        }
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(side);
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getStartLine(side));
        return new DiffGutterOperation.WithModifiers((Editor)editor, offset, this.myViewer.getModifierProvider(), builder);
    }

    @Nullable
    private DiffGutterOperation createResolveOperation() {
        return this.createOperation(ThreeSide.BASE, (ctrlPressed, shiftPressed, altPressed) -> this.createResolveRenderer());
    }

    @Nullable
    private DiffGutterOperation createAcceptOperation(@NotNull Side versionSide, @NotNull OperationType type) {
        if (versionSide == null) {
            TextMergeChange.$$$reportNull$$$0(14);
        }
        if (type == null) {
            TextMergeChange.$$$reportNull$$$0(15);
        }
        ThreeSide side = (ThreeSide)versionSide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        return this.createOperation(side, (ctrlPressed, shiftPressed, altPressed) -> {
            if (!this.isChange(versionSide)) {
                return null;
            }
            if (type == OperationType.APPLY) {
                return this.createApplyRenderer(versionSide, ctrlPressed);
            }
            return this.createIgnoreRenderer(versionSide, ctrlPressed);
        });
    }

    @Nullable
    private DiffGutterOperation createResetOperation() {
        if (!this.isResolved() || !this.myIsResolvedWithAI) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(ThreeSide.BASE);
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getStartLine(ThreeSide.BASE));
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]), AllIcons.Diff.Revert, false, () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.reset.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.resetResolvedChange(this))));
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(16);
        }
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon = this.isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), icon, this.isConflict(), () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.replaceSingleChange(this, side, modifier)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(17);
        }
        if (this.isResolved(side)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]), AllIcons.Diff.Remove, this.isConflict(), () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.ignoreChange(this, side, modifier)));
    }

    @Nullable
    private GutterIconRenderer createResolveRenderer() {
        if (!this.isConflict() || !this.myViewer.canResolveChangeAutomatically(this, ThreeSide.BASE)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.resolve.text", (Object[])new Object[0]), AllIcons.Diff.MagicResolve, false, () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.resolve.conflict.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.resolveSingleChangeAutomatically(this, ThreeSide.BASE)));
    }

    @NotNull
    private static GutterIconRenderer createIconRenderer(@NlsContexts.Tooltip @NotNull String text, @NotNull Icon icon, boolean ctrlClickVisible, final @NotNull Runnable perform) {
        if (text == null) {
            TextMergeChange.$$$reportNull$$$0(18);
        }
        if (icon == null) {
            TextMergeChange.$$$reportNull$$$0(19);
        }
        if (perform == null) {
            TextMergeChange.$$$reportNull$$$0(20);
        }
        String appendix = ctrlClickVisible ? DiffBundle.message((String)"tooltip.merge.ctrl.click.to.resolve.conflict", (Object[])new Object[0]) : null;
        String tooltipText = DiffUtil.createTooltipText(text, appendix);
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void handleMouseClick() {
                perform.run();
            }
        };
    }

    @NotNull
    public State storeState() {
        return new State(this.myIndex, this.getStartLine(), this.getEndLine(), this.myResolved[0], this.myResolved[1], this.myOnesideAppliedConflict, this.myIsResolvedWithAI);
    }

    public void restoreState(@NotNull State state) {
        if (state == null) {
            TextMergeChange.$$$reportNull$$$0(21);
        }
        this.myResolved[0] = state.myResolved1;
        this.myResolved[1] = state.myResolved2;
        this.myOnesideAppliedConflict = state.myOnesideAppliedConflict;
        this.myIsResolvedWithAI = state.myIsResolvedByAI;
    }

    @ApiStatus.Internal
    void resetState() {
        this.myResolved[0] = false;
        this.myResolved[1] = false;
        this.myOnesideAppliedConflict = false;
        this.myIsResolvedWithAI = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/TextMergeChange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionSide";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/TextMergeChange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setResolved";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createIgnoreRenderer";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static class MyAIResolvedDiffType
    implements TextDiffType {
        private final TextDiffType myBaseType;

        private MyAIResolvedDiffType(TextDiffType baseType) {
            this.myBaseType = baseType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myBaseType.getName();
            if (string == null) {
                MyAIResolvedDiffType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            JBColor jBColor = AI_COLOR;
            if (jBColor == null) {
                MyAIResolvedDiffType.$$$reportNull$$$0(1);
            }
            return jBColor;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            Color color = this.myBaseType.getIgnoredColor(editor);
            if (color == null) {
                MyAIResolvedDiffType.$$$reportNull$$$0(2);
            }
            return color;
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.myBaseType.getMarkerColor(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/diff/merge/TextMergeChange$MyAIResolvedDiffType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredColor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved1;
        private final boolean myResolved2;
        private final boolean myOnesideAppliedConflict;
        private final boolean myIsResolvedByAI;

        public State(int index, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict, boolean isResolvedByAI) {
            super(index, startLine, endLine);
            this.myResolved1 = resolved1;
            this.myResolved2 = resolved2;
            this.myOnesideAppliedConflict = onesideAppliedConflict;
            this.myIsResolvedByAI = isResolvedByAI;
        }
    }
}

