/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.tools.combined.CombinedDiffUIState;
import com.intellij.icons.AllIcons;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diff/tools/combined/DiffInfoComponent;", "", "<init>", "()V", "leftTitle", "Lcom/intellij/ui/components/JBLabel;", "kotlin.jvm.PlatformType", "rightLabel", "arrows", "gap", "", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "updateForState", "", "diffInfo", "Lcom/intellij/diff/tools/combined/CombinedDiffUIState$DiffInfoState;", "getCenterX", "intellij.platform.diff.impl"})
final class DiffInfoComponent {
    private final JBLabel leftTitle = new JBLabel().setCopyable(true);
    private final JBLabel rightLabel = new JBLabel().setCopyable(true);
    @NotNull
    private final JBLabel arrows = new JBLabel(AllIcons.Diff.ArrowLeftRight);
    private final int gap;
    @NotNull
    private final JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(this.gap, 0, 2, null));

    public DiffInfoComponent() {
        this.gap = 10;
        this.panel.add((Component)this.leftTitle);
        this.panel.add((Component)this.arrows);
        this.panel.add((Component)this.rightLabel);
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    public final void updateForState(@NotNull CombinedDiffUIState.DiffInfoState diffInfo) {
        Intrinsics.checkNotNullParameter((Object)diffInfo, (String)"diffInfo");
        CombinedDiffUIState.DiffInfoState diffInfoState = diffInfo;
        if (Intrinsics.areEqual((Object)diffInfoState, (Object)CombinedDiffUIState.DiffInfoState.Empty.INSTANCE)) {
            this.leftTitle.setVisible(false);
            this.arrows.setVisible(false);
            this.rightLabel.setVisible(false);
        } else if (diffInfoState instanceof CombinedDiffUIState.DiffInfoState.SingleTitle) {
            this.leftTitle.setVisible(true);
            this.arrows.setVisible(false);
            this.rightLabel.setVisible(false);
            this.leftTitle.setText(((CombinedDiffUIState.DiffInfoState.SingleTitle)diffInfo).getTitle());
        } else if (diffInfoState instanceof CombinedDiffUIState.DiffInfoState.TwoTitles) {
            this.leftTitle.setVisible(true);
            this.arrows.setVisible(true);
            this.rightLabel.setVisible(true);
            this.leftTitle.setText(((CombinedDiffUIState.DiffInfoState.TwoTitles)diffInfo).getLeftTitle());
            this.rightLabel.setText(((CombinedDiffUIState.DiffInfoState.TwoTitles)diffInfo).getRightTitle());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final int getCenterX() {
        if (this.arrows.isVisible()) {
            return this.leftTitle.getPreferredSize().width + JBUIScale.scale((int)this.gap) + this.arrows.getPreferredSize().width / 2;
        }
        return this.panel.getPreferredSize().width / 2;
    }
}

