/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PrevNextDifferenceIterableBase<T>
implements PrevNextDifferenceIterable {
    @NotNull
    protected abstract @Unmodifiable List<? extends T> getChanges();

    @NotNull
    protected abstract EditorEx getEditor();

    protected abstract int getStartLine(@NotNull T var1);

    protected abstract int getEndLine(@NotNull T var1);

    protected void scrollToChange(@NotNull T change) {
        if (change == null) {
            PrevNextDifferenceIterableBase.$$$reportNull$$$0(0);
        }
        DiffUtil.scrollEditor((Editor)this.getEditor(), this.getStartLine(change), true);
    }

    protected void scrollToChangeUnderCommand(@NotNull T change) {
        if (change == null) {
            PrevNextDifferenceIterableBase.$$$reportNull$$$0(1);
        }
        EditorEx editor = this.getEditor();
        DocumentEx document = editor.getDocument();
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> this.scrollToChange(change), "", (Object)DocCommandGroupId.noneGroupId((Document)document), UndoConfirmationPolicy.DEFAULT, (Document)document);
    }

    @Override
    public boolean canGoNext() {
        EditorEx editor;
        List<T> changes = this.getChanges();
        if (changes.isEmpty()) {
            return false;
        }
        int line = editor.getCaretModel().getLogicalPosition().line;
        editor = this.getEditor();
        if (line == DiffUtil.getLineCount((Document)editor.getDocument()) - 1) {
            return false;
        }
        T lastChange = changes.get(changes.size() - 1);
        return this.getStartLine(lastChange) > line;
    }

    @Override
    public void goNext() {
        List<T> changes = this.getChanges();
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        T next = null;
        for (T change : changes) {
            if (this.getStartLine(change) <= line) continue;
            next = change;
            break;
        }
        assert (next != null);
        this.scrollToChangeUnderCommand(next);
    }

    @Override
    public boolean canGoPrev() {
        List<T> changes = this.getChanges();
        if (changes.isEmpty()) {
            return false;
        }
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        if (line == 0) {
            return false;
        }
        T firstChange = changes.get(0);
        if (this.getEndLine(firstChange) > line) {
            return false;
        }
        return this.getStartLine(firstChange) < line;
    }

    @Override
    public void goPrev() {
        List<T> changes = this.getChanges();
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        T prev = null;
        for (int i = 0; i < changes.size(); ++i) {
            T next;
            T change = changes.get(i);
            T t = next = i < changes.size() - 1 ? (T)changes.get(i + 1) : null;
            if (next != null && this.getEndLine(next) <= line && this.getStartLine(next) < line) continue;
            prev = change;
            break;
        }
        assert (prev != null);
        this.scrollToChangeUnderCommand(prev);
    }

    @Nullable
    public LineRange getCurrentLineRangeByLine(int line) {
        for (T change : this.getChanges()) {
            int start = this.getStartLine(change);
            int end = this.getEndLine(change);
            if (start <= line && end > line) {
                return new LineRange(start, end);
            }
            if (start <= line) continue;
            return null;
        }
        return null;
    }

    @Nullable
    public LineRange getCurrentLineRange() {
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        return this.getCurrentLineRangeByLine(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "change";
        objectArray2[1] = "com/intellij/diff/tools/util/PrevNextDifferenceIterableBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollToChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollToChangeUnderCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

