/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusGutterMarkerRenderer;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 62\u00020\u0001:\u000256B9\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH$J\b\u0010 \u001a\u00020\u0018H\u0015J\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u001aH\u0002J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\"H\u0003J\b\u0010(\u001a\u00020\"H\u0002J\b\u0010)\u001a\u00020\"H\u0003J \u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010/\u001a\u000200H\u0014J\b\u00103\u001a\u00020\"H\u0002J\b\u00104\u001a\u00020\u000bH\u0014R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "disposable", "Lcom/intellij/openapi/Disposable;", "editorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "isMain", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "disposed", "gutterLayer", "", "gutterHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "errorStripeHighlighters", "", "getRanges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "getGutterLayer", "scheduleUpdate", "", "scheduleValidateHighlighter", "createGutterHighlighter", "createGutterMarkerRenderer", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "updateHighlighters", "repaintGutter", "updateErrorStripeHighlighters", "createErrorStripeHighlighter", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "diffType", "", "createErrorStripeTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "destroyHighlighters", "shouldPaintErrorStripeMarkers", "MarkerData", "Companion", "intellij.platform.diff.impl"})
public abstract class LineStatusMarkerRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final Disposable disposable;
    @Nullable
    private final MarkupEditorFilter editorFilter;
    private final boolean isMain;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    private boolean disposed;
    private final int gutterLayer;
    @NotNull
    private RangeHighlighter gutterHighlighter;
    @NotNull
    private final List<RangeHighlighter> errorStripeHighlighters;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<MarkerData> TOOLTIP_KEY;
    @NotNull
    private static final Key<Boolean> MAIN_KEY;

    public LineStatusMarkerRenderer(@Nullable Project project, @NotNull Document document, @NotNull Disposable disposable, @Nullable MarkupEditorFilter editorFilter, boolean isMain) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.document = document;
        this.disposable = disposable;
        this.editorFilter = editorFilter;
        this.isMain = isMain;
        this.updateQueue = new MergingUpdateQueue("LineStatusMarkerRenderer", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, false, 96, null);
        this.gutterLayer = this.getGutterLayer();
        this.gutterHighlighter = this.createGutterHighlighter();
        this.errorStripeHighlighters = new ArrayList();
        Disposer.register((Disposable)this.disposable, () -> LineStatusMarkerRenderer._init_$lambda$0(this));
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect(this.disposable);
        busConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginUnloaded(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.scheduleValidateHighlighter();
            }
        });
        Topic topic = PowerSaveMode.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                this.scheduleValidateHighlighter();
            }
        });
        this.scheduleUpdate();
    }

    public /* synthetic */ LineStatusMarkerRenderer(Project project, Document document, Disposable disposable, MarkupEditorFilter markupEditorFilter, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            markupEditorFilter = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(project, document, disposable, markupEditorFilter, bl);
    }

    @Nullable
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Document getDocument() {
        return this.document;
    }

    @NotNull
    protected final Disposable getDisposable() {
        return this.disposable;
    }

    @Nullable
    protected abstract List<Range> getRanges();

    @Deprecated(message="\n    A hack for rendering inline prompt gutter mark on top of the git's one.\n    The method should be removed and mark conflict should be resolved in another way.\n    See com.intellij.ml.llm.inlinePromptDetector.diff.CGResultGutterRenderer.\n  ")
    @ApiStatus.Internal
    protected int getGutterLayer() {
        return 5999;
    }

    public final void scheduleUpdate() {
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)((Disposable)this.updateQueue), (Object)"update", () -> LineStatusMarkerRenderer.scheduleUpdate$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.updateQueue.queue((Update)disposableUpdate);
    }

    private final void scheduleValidateHighlighter() {
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)((Disposable)this.updateQueue), (Object)"validate highlighter", () -> LineStatusMarkerRenderer.scheduleValidateHighlighter$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.updateQueue.queue((Update)disposableUpdate);
    }

    private final RangeHighlighter createGutterHighlighter() {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.document, (Project)this.project, (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        RangeHighlighterEx rangeHighlighterEx = markupModel2.addRangeHighlighterAndChangeAttributes(null, 0, this.document.getTextLength(), this.gutterLayer, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> LineStatusMarkerRenderer.createGutterHighlighter$lambda$1(arg_0 -> LineStatusMarkerRenderer.createGutterHighlighter$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        return (RangeHighlighter)rangeHighlighterEx;
    }

    @NotNull
    protected LineMarkerRenderer createGutterMarkerRenderer() {
        return (LineMarkerRenderer)new LineStatusGutterMarkerRenderer(this){
            final /* synthetic */ LineStatusMarkerRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            protected List<Range> getPaintedRanges() {
                List list = this.this$0.getRanges();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        };
    }

    @RequiresEdt
    private final void updateHighlighters() {
        if (this.disposed) {
            return;
        }
        if (!this.gutterHighlighter.isValid()) {
            this.scheduleValidateHighlighter();
        }
        try {
            this.repaintGutter();
            this.updateErrorStripeHighlighters();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error in " + this, e);
        }
    }

    private final void repaintGutter() {
        EditorFactory.getInstance().editors(this.document).forEach(arg_0 -> LineStatusMarkerRenderer.repaintGutter$lambda$1(LineStatusMarkerRenderer::repaintGutter$lambda$0, arg_0));
    }

    @RequiresEdt
    private final void updateErrorStripeHighlighters() {
        Object object;
        List<Range> ranges = this.getRanges();
        if (!this.shouldPaintErrorStripeMarkers() || (object = (Collection)ranges) == null || object.isEmpty()) {
            for (RangeHighlighter highlighter : this.errorStripeHighlighters) {
                LineStatusMarkerRenderer.Companion.disposeHighlighter(highlighter);
            }
            this.errorStripeHighlighters.clear();
            return;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.document, (Project)this.project, (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        PeekableIterator highlighterIt = (PeekableIterator)new PeekableIteratorWrapper(this.errorStripeHighlighters.iterator());
        List newHighlighters = new ArrayList();
        List oldHighlighters = new ArrayList();
        for (Range range : ranges) {
            Object object2;
            MarkerData oldMarkerData;
            RangeHighlighter oldHighlighter;
            TextRange textRange;
            Intrinsics.checkNotNullExpressionValue((Object)DiffUtil.getLinesRange(markupModel2.getDocument(), range.getLine1(), range.getLine2(), false), (String)"getLinesRange(...)");
            while (highlighterIt.hasNext() && ((RangeHighlighter)highlighterIt.peek()).getStartOffset() < textRange.getStartOffset()) {
                oldHighlighters.add(highlighterIt.next());
            }
            RangeHighlighter rangeHighlighter = oldHighlighter = highlighterIt.hasNext() ? (RangeHighlighter)highlighterIt.peek() : null;
            MarkerData markerData = oldMarkerData = rangeHighlighter != null ? (MarkerData)rangeHighlighter.getUserData(TOOLTIP_KEY) : null;
            if (oldHighlighter != null && oldHighlighter.isValid() && oldMarkerData != null && oldMarkerData.getType() == range.getType() && oldHighlighter.getStartOffset() == textRange.getStartOffset() && oldHighlighter.getEndOffset() == textRange.getEndOffset()) {
                newHighlighters.add(oldHighlighter);
                object2 = highlighterIt.next();
                continue;
            }
            object2 = newHighlighters.add(this.createErrorStripeHighlighter(markupModel2, textRange, range.getType()));
        }
        while (highlighterIt.hasNext()) {
            oldHighlighters.add(highlighterIt.next());
        }
        for (RangeHighlighter highlighter : oldHighlighters) {
            LineStatusMarkerRenderer.Companion.disposeHighlighter(highlighter);
        }
        this.errorStripeHighlighters.clear();
        this.errorStripeHighlighters.addAll(newHighlighters);
    }

    private final RangeHighlighter createErrorStripeHighlighter(MarkupModelEx markupModel, TextRange textRange, byte diffType) {
        RangeHighlighterEx rangeHighlighterEx = markupModel.addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), this.gutterLayer, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> LineStatusMarkerRenderer.createErrorStripeHighlighter$lambda$1(arg_0 -> LineStatusMarkerRenderer.createErrorStripeHighlighter$lambda$0(this, diffType, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        return (RangeHighlighter)rangeHighlighterEx;
    }

    @NotNull
    protected TextAttributes createErrorStripeTextAttributes(byte diffType) {
        return new LineStatusMarkerDrawUtil.DiffStripeTextAttributes(diffType);
    }

    private final void destroyHighlighters() {
        RangeHighlighter gutterHighlighter = this.gutterHighlighter;
        if (!gutterHighlighter.isValid() || gutterHighlighter.getStartOffset() != 0 || gutterHighlighter.getEndOffset() != this.document.getTextLength()) {
            String string = "Highlighter is damaged for %s, isValid: %s";
            Object[] objectArray = new Object[]{this, gutterHighlighter.isValid()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            LOG.warn(string2);
        }
        LineStatusMarkerRenderer.Companion.disposeHighlighter(gutterHighlighter);
        for (RangeHighlighter highlighter : this.errorStripeHighlighters) {
            LineStatusMarkerRenderer.Companion.disposeHighlighter(highlighter);
        }
        this.errorStripeHighlighters.clear();
    }

    protected boolean shouldPaintErrorStripeMarkers() {
        return true;
    }

    private static final void _init_$lambda$0(LineStatusMarkerRenderer this$0) {
        this$0.disposed = true;
        this$0.destroyHighlighters();
    }

    private static final void scheduleUpdate$lambda$0(LineStatusMarkerRenderer this$0) {
        WriteIntentReadAction.run(() -> LineStatusMarkerRenderer.scheduleUpdate$lambda$0$0(this$0));
    }

    private static final void scheduleUpdate$lambda$0$0(LineStatusMarkerRenderer this$0) {
        this$0.updateHighlighters();
    }

    private static final void scheduleValidateHighlighter$lambda$0(LineStatusMarkerRenderer this$0) {
        if (this$0.disposed || this$0.gutterHighlighter.isValid()) {
            return;
        }
        LOG.warn("Line marker highlighter was recovered. This incident will be reported.");
        LineStatusMarkerRenderer.Companion.disposeHighlighter(this$0.gutterHighlighter);
        this$0.gutterHighlighter = this$0.createGutterHighlighter();
        this$0.updateHighlighters();
    }

    private static final Unit createGutterHighlighter$lambda$0(LineStatusMarkerRenderer this$0, RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setGreedyToLeft(true);
        it.setGreedyToRight(true);
        it.setLineMarkerRenderer(this$0.createGutterMarkerRenderer());
        MarkupEditorFilter filter = this$0.editorFilter;
        if (filter != null) {
            it.setEditorFilter(filter);
        }
        it.putUserData(MAIN_KEY, (Object)this$0.isMain);
        return Unit.INSTANCE;
    }

    private static final void createGutterHighlighter$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit repaintGutter$lambda$0(Editor it) {
        if (it instanceof EditorEx) {
            ((EditorEx)it).getGutterComponentEx().repaint();
        }
        return Unit.INSTANCE;
    }

    private static final void repaintGutter$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createErrorStripeHighlighter$lambda$0(LineStatusMarkerRenderer this$0, byte $diffType, RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setThinErrorStripeMark(true);
        it.setGreedyToLeft(true);
        it.setGreedyToRight(true);
        it.setTextAttributes(this$0.createErrorStripeTextAttributes($diffType));
        MarkupEditorFilter filter = this$0.editorFilter;
        if (filter != null) {
            it.setEditorFilter(filter);
        }
        it.putUserData(TOOLTIP_KEY, (Object)new MarkerData($diffType));
        return Unit.INSTANCE;
    }

    private static final void createErrorStripeHighlighter$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(LineStatusMarkerRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"LineStatusMarkerRenderer.Tooltip.Id");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TOOLTIP_KEY = key;
        Key key2 = Key.create((String)"LineStatusMarkerRenderer.Main.Id");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        MAIN_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TOOLTIP_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$MarkerData;", "getTOOLTIP_KEY", "()Lcom/intellij/openapi/util/Key;", "MAIN_KEY", "", "getMAIN_KEY", "disposeHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<MarkerData> getTOOLTIP_KEY() {
            return TOOLTIP_KEY;
        }

        @NotNull
        public final Key<Boolean> getMAIN_KEY() {
            return MAIN_KEY;
        }

        private final void disposeHighlighter(RangeHighlighter highlighter) {
            try {
                highlighter.dispose();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$MarkerData;", "", "type", "", "<init>", "(B)V", "getType", "()B", "intellij.platform.diff.impl"})
    public static final class MarkerData {
        private final byte type;

        public MarkerData(byte type) {
            this.type = type;
        }

        public final byte getType() {
            return this.type;
        }
    }
}

