/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.DiffApplicationSettings;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopup;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopupController;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J0\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J,\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0014J(\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001aH\u0002R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopup;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "editorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;)V", "vcsDocument", "Lcom/intellij/openapi/editor/Document;", "getVcsDocument", "()Lcom/intellij/openapi/editor/Document;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "createPopupPanel", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mousePosition", "Ljava/awt/Point;", "popupDisposable", "Lcom/intellij/openapi/Disposable;", "createVcsContentComponent", "Ljavax/swing/JComponent;", "disposable", "createToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createAdditionalToolbarActions", "createEditorContextMenuActions", "createAdditionalInfoPanel", "installWordDiff", "", "textField", "Lcom/intellij/ui/EditorTextField;", "intellij.platform.diff.impl"})
public abstract class LineStatusTrackerMarkerRenderer
extends LineStatusMarkerRendererWithPopup
implements LineStatusMarkerRendererWithPopupController {
    @NotNull
    private final Document vcsDocument;
    @Nullable
    private final FileType fileType;

    public LineStatusTrackerMarkerRenderer(@NotNull LineStatusTrackerI<?> tracker, @Nullable MarkupEditorFilter editorFilter) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        super(tracker.getProject(), tracker.getDocument(), tracker, tracker.getDisposable(), editorFilter, false, 32, null);
        this.vcsDocument = tracker.getVcsDocument();
        VirtualFile virtualFile = tracker.getVirtualFile();
        this.fileType = virtualFile != null ? virtualFile.getFileType() : null;
    }

    public /* synthetic */ LineStatusTrackerMarkerRenderer(LineStatusTrackerI lineStatusTrackerI, MarkupEditorFilter markupEditorFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markupEditorFilter = null;
        }
        this(lineStatusTrackerI, markupEditorFilter);
    }

    @NotNull
    protected final Document getVcsDocument() {
        return this.vcsDocument;
    }

    @Nullable
    protected final FileType getFileType() {
        return this.fileType;
    }

    @Override
    @NotNull
    protected final LineStatusMarkerPopupPanel createPopupPanel(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable popupDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)popupDisposable, (String)"popupDisposable");
        JComponent editorComponent = null;
        if (range.hasVcsLines()) {
            editorComponent = this.createVcsContentComponent(range, editor, mousePosition, popupDisposable);
        }
        List actions = CollectionsKt.plus((Collection)this.createToolbarActions(editor, range, mousePosition), (Iterable)this.createAdditionalToolbarActions(editor, range, mousePosition, popupDisposable));
        ActionToolbar actionToolbar = LineStatusMarkerPopupPanel.buildToolbar(editor, actions, popupDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"buildToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        JComponent additionalInfoPanel = this.createAdditionalInfoPanel(editor, range, mousePosition, popupDisposable);
        LineStatusMarkerPopupPanel lineStatusMarkerPopupPanel = LineStatusMarkerPopupPanel.create(editor, toolbar, editorComponent, additionalInfoPanel);
        Intrinsics.checkNotNullExpressionValue((Object)lineStatusMarkerPopupPanel, (String)"create(...)");
        return lineStatusMarkerPopupPanel;
    }

    private final JComponent createVcsContentComponent(Range range, Editor editor, Point mousePosition, Disposable disposable) {
        TextRange vcsRange = DiffUtil.getLinesRange(this.vcsDocument, range.getVcsLine1(), range.getVcsLine2());
        String vcsContent = ((Object)DiffUtil.getLinesContent(this.vcsDocument, range.getVcsLine1(), range.getVcsLine2())).toString();
        EditorTextField editorTextField = LineStatusMarkerPopupPanel.createTextField(editor, vcsContent);
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"createTextField(...)");
        EditorTextField textField = editorTextField;
        Project project = this.getProject();
        FileType fileType = this.fileType;
        if (fileType == null) {
            fileType = (FileType)PlainTextFileType.INSTANCE;
        }
        LineStatusMarkerPopupPanel.installBaseEditorSyntaxHighlighters(project, textField, this.vcsDocument, vcsRange, fileType);
        this.installWordDiff(editor, textField, range, disposable);
        textField.addSettingsProvider(arg_0 -> LineStatusTrackerMarkerRenderer.createVcsContentComponent$lambda$0(this, editor, range, mousePosition, arg_0));
        JComponent jComponent = LineStatusMarkerPopupPanel.createEditorComponent(editor, (JComponent)textField);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createEditorComponent(...)");
        return jComponent;
    }

    @NotNull
    protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<AnAction> createAdditionalToolbarActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable popupDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)popupDisposable, (String)"popupDisposable");
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<AnAction> createEditorContextMenuActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected JComponent createAdditionalInfoPanel(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        return null;
    }

    private final void installWordDiff(Editor editor, EditorTextField textField, Range range, Disposable disposable) {
        if (!DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES) {
            return;
        }
        if (!range.hasLines() || !range.hasVcsLines()) {
            return;
        }
        CharSequence charSequence = DiffUtil.getLinesContent(this.vcsDocument, range.getVcsLine1(), range.getVcsLine2());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLinesContent(...)");
        CharSequence vcsContent = charSequence;
        CharSequence charSequence2 = DiffUtil.getLinesContent(this.getDocument(), range.getLine1(), range.getLine2());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getLinesContent(...)");
        CharSequence currentContent = charSequence2;
        List list = (List)BackgroundTaskUtil.tryComputeFast(arg_0 -> LineStatusTrackerMarkerRenderer.installWordDiff$lambda$1(arg_0 -> LineStatusTrackerMarkerRenderer.installWordDiff$lambda$0(vcsContent, currentContent, arg_0), arg_0), (long)200L);
        if (list == null) {
            return;
        }
        List wordDiff = list;
        LineStatusMarkerPopupPanel.installMasterEditorWordHighlighters(editor, range.getLine1(), range.getLine2(), wordDiff, disposable);
        LineStatusMarkerPopupPanel.installPopupEditorWordHighlighters(textField, wordDiff);
    }

    private static final void createVcsContentComponent$lambda$0(LineStatusTrackerMarkerRenderer this$0, Editor $editor, Range $range, Point $mousePosition, EditorEx uEditor) {
        if ((uEditor instanceof EditorImpl ? (EditorImpl)uEditor : null) == null) {
            return;
        }
        List<AnAction> contextMenuActions = this$0.createEditorContextMenuActions($editor, $range, $mousePosition);
        if (!((Collection)contextMenuActions).isEmpty()) {
            ((EditorImpl)uEditor).installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(contextMenuActions){
                final /* synthetic */ List<AnAction> $contextMenuActions;
                {
                    this.$contextMenuActions = $contextMenuActions;
                }

                public ActionGroup getActionGroup(EditorMouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    return (ActionGroup)new DefaultActionGroup(this.$contextMenuActions);
                }
            });
        }
    }

    private static final List installWordDiff$lambda$0(CharSequence $vcsContent, CharSequence $currentContent, ProgressIndicator indicator) {
        List<DiffFragment> list = ByWord.compare($vcsContent, $currentContent, ComparisonPolicy.DEFAULT, indicator);
        Intrinsics.checkNotNullExpressionValue(list, (String)"compare(...)");
        return list;
    }

    private static final List installWordDiff$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

