/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.impl.TextAttributeKeyColor;
import com.intellij.openapi.editor.colors.impl.TextAttributeKeyColorType;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TextAttributesReader
extends ValueElementReader {
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String BACKGROUND = "BACKGROUND";
    @NonNls
    private static final String FOREGROUND = "FOREGROUND";
    @NonNls
    private static final String ERROR_STRIPE = "ERROR_STRIPE_COLOR";
    @NonNls
    private static final String EFFECT_COLOR = "EFFECT_COLOR";
    @NonNls
    private static final String EFFECT_TYPE = "EFFECT_TYPE";
    @NonNls
    private static final String FONT_TYPE = "FONT_TYPE";

    @Override
    public <T> T read(Class<T> type, Element element) {
        if (TextAttributes.class.equals(type)) {
            return (T)this.readAttributes(element, null);
        }
        return super.read(type, element);
    }

    public TextAttributes readAttributes(@Nullable Element element, @Nullable String keyName) {
        TextAttributes attributes = new TextAttributes();
        if (element != null) {
            Object foregroundColor = this.readChild(Color.class, element, FOREGROUND);
            Object backgroundColor = this.readChild(Color.class, element, BACKGROUND);
            Object effectColor = this.readChild(Color.class, element, EFFECT_COLOR);
            Object errorStripeColor = this.readChild(Color.class, element, ERROR_STRIPE);
            EffectType effectType = Effect.read(this, element);
            int fontType = FontStyle.read(this, element);
            if (keyName != null) {
                if (foregroundColor != null) {
                    foregroundColor = new TextAttributeKeyColor((Color)foregroundColor, keyName, TextAttributeKeyColorType.FOREGROUND);
                }
                if (backgroundColor != null) {
                    backgroundColor = new TextAttributeKeyColor((Color)backgroundColor, keyName, TextAttributeKeyColorType.BACKGROUND);
                }
                if (effectColor != null) {
                    effectColor = new TextAttributeKeyColor((Color)effectColor, keyName, TextAttributeKeyColorType.EFFECT_COLOR);
                }
                if (errorStripeColor != null) {
                    errorStripeColor = new TextAttributeKeyColor((Color)errorStripeColor, keyName, TextAttributeKeyColorType.ERROR_STRIPE);
                }
            }
            attributes.setAttributes(foregroundColor, backgroundColor, effectColor, errorStripeColor, effectType, fontType);
        }
        return attributes;
    }

    private <T> T readChild(Class<T> type, Element element, String name) {
        for (Element option : element.getChildren(OPTION)) {
            if (!name.equals(option.getAttributeValue(NAME))) continue;
            return this.read(type, option);
        }
        return null;
    }

    private static enum Effect {
        BORDER(EffectType.BOXED),
        LINE(EffectType.LINE_UNDERSCORE),
        WAVE(EffectType.WAVE_UNDERSCORE),
        STRIKEOUT(EffectType.STRIKEOUT),
        BOLD_LINE(EffectType.BOLD_LINE_UNDERSCORE),
        BOLD_DOTTED_LINE(EffectType.BOLD_DOTTED_LINE),
        FADED(EffectType.FADED);

        private final EffectType myType;

        private Effect(EffectType type) {
            this.myType = type;
        }

        static EffectType read(TextAttributesReader reader, Element element) {
            Effect effect = reader.readChild(Effect.class, element, TextAttributesReader.EFFECT_TYPE);
            return effect != null ? effect.myType : EffectType.BOXED;
        }
    }

    private static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        private final int myStyle;

        private FontStyle(int style) {
            this.myStyle = style;
        }

        @JdkConstants.FontStyle
        static int read(TextAttributesReader reader, Element element) {
            FontStyle style = reader.readChild(FontStyle.class, element, TextAttributesReader.FONT_TYPE);
            return style != null ? style.myStyle : 0;
        }
    }
}

