/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.ImaginaryCaret;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImaginaryCaretModel
implements CaretModel {
    private final ImaginaryEditor myEditor;
    private final ImaginaryCaret myCaret;
    private static final Logger LOG = Logger.getInstance(ImaginaryCaretModel.class);

    public ImaginaryCaretModel(ImaginaryEditor editor) {
        this.myEditor = editor;
        this.myCaret = new ImaginaryCaret(this);
    }

    protected ImaginaryEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public Caret getCurrentCaret() {
        Caret caret = this.getPrimaryCaret();
        if (caret == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(0);
        }
        return caret;
    }

    protected RuntimeException notImplemented() {
        return this.myEditor.notImplemented();
    }

    public void addCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(1);
        }
        LOG.info("Called ImaginaryCaretModel#addCaretListener which is stubbed and has no implementation");
    }

    public void removeCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(2);
        }
        LOG.info("Called ImaginaryCaretModel#removeCaretListener which is stubbed and has no implementation");
    }

    public TextAttributes getTextAttributes() {
        throw this.notImplemented();
    }

    public boolean supportsMultipleCarets() {
        return false;
    }

    public int getMaxCaretCount() {
        return 1;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        ImaginaryCaret imaginaryCaret = this.myCaret;
        if (imaginaryCaret == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(3);
        }
        return imaginaryCaret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List<Caret> list = Collections.singletonList(this.getCurrentCaret());
        if (list == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(5);
        }
        throw this.notImplemented();
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(6);
        }
        throw this.notImplemented();
    }

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition pos, boolean makePrimary) {
        if (pos == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(7);
        }
        throw this.notImplemented();
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(8);
        }
        throw this.notImplemented();
    }

    public void removeSecondaryCarets() {
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        if (caretStates == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(9);
        }
        this.setCaretsAndSelections(caretStates, true);
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        CaretState state;
        if (caretStates == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(10);
        }
        if (caretStates.size() != 1) {
            LOG.error("Imaginary caret does not support multicaret. caretStates=" + String.valueOf(caretStates));
        }
        if ((state = caretStates.get(0)).getCaretPosition() != null) {
            this.getCurrentCaret().moveToOffset(this.myEditor.logicalPositionToOffset(state.getCaretPosition()));
        }
        if (state.getSelectionStart() != null && state.getSelectionEnd() != null && !state.getSelectionStart().equals((Object)state.getSelectionEnd())) {
            this.getCurrentCaret().setSelection(this.myEditor.logicalPositionToOffset(state.getSelectionStart()), this.myEditor.logicalPositionToOffset(state.getSelectionEnd()));
        }
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        List<CaretState> list = Collections.singletonList(new CaretState(this.getCurrentCaret().getLogicalPosition(), 0, this.myEditor.offsetToLogicalPosition(this.getCurrentCaret().getSelectionStart()), this.myEditor.offsetToLogicalPosition(this.getCurrentCaret().getSelectionEnd())));
        if (list == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        if (action == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(12);
        }
        action.perform(this.getCurrentCaret());
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        if (action == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(13);
        }
        action.perform(this.getCurrentCaret());
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(14);
        }
        if (disposable == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(15);
        }
        throw this.notImplemented();
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            ImaginaryCaretModel.$$$reportNull$$$0(16);
        }
        throw this.notImplemented();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ImaginaryCaretModel";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ImaginaryCaretModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCaretActionListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

