/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.ImaginaryCaretModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImaginaryCaret
extends UserDataHolderBase
implements Caret {
    private final ImaginaryCaretModel myCaretModel;
    private int myStart;
    private int myPos;
    private int myEnd;

    public ImaginaryCaret(ImaginaryCaretModel caretModel) {
        this.myCaretModel = caretModel;
    }

    public int getSelectionStart() {
        return this.myStart;
    }

    public int getSelectionEnd() {
        return this.myEnd;
    }

    public boolean hasSelection() {
        return this.myEnd > this.myStart;
    }

    @NotNull
    public ImaginaryEditor getEditor() {
        ImaginaryEditor imaginaryEditor = this.myCaretModel.getEditor();
        if (imaginaryEditor == null) {
            ImaginaryCaret.$$$reportNull$$$0(0);
        }
        return imaginaryEditor;
    }

    @NotNull
    public CaretModel getCaretModel() {
        ImaginaryCaretModel imaginaryCaretModel = this.myCaretModel;
        if (imaginaryCaretModel == null) {
            ImaginaryCaret.$$$reportNull$$$0(1);
        }
        return imaginaryCaretModel;
    }

    public int getOffset() {
        return this.myPos;
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        if (offset < 0) {
            offset = 0;
        }
        this.myPos = this.myEnd = offset;
        this.myStart = this.myEnd;
    }

    private RuntimeException notImplemented() {
        return this.getEditor().notImplemented();
    }

    public boolean isValid() {
        throw this.notImplemented();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        if (lineShift == 0) {
            this.myEnd += columnShift;
            if (!withSelection) {
                this.myStart = this.myPos = this.myEnd;
            }
        } else {
            int oldPos = this.myPos;
            LogicalPosition currentPosition = this.getLogicalPosition();
            this.moveToLogicalPosition(new LogicalPosition(currentPosition.line + lineShift, currentPosition.column + columnShift));
            if (withSelection) {
                int newPos = this.myPos;
                this.myStart = Math.min(oldPos, newPos);
                this.myEnd = Math.max(oldPos, newPos);
            }
        }
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            ImaginaryCaret.$$$reportNull$$$0(2);
        }
        this.moveToOffset(this.getEditor().logicalPositionToOffset(pos));
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            ImaginaryCaret.$$$reportNull$$$0(3);
        }
        this.moveToOffset(this.getEditor().visualPositionToOffset(pos));
    }

    public boolean isUpToDate() {
        throw this.notImplemented();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getEditor().offsetToLogicalPosition(this.myStart);
        if (logicalPosition == null) {
            ImaginaryCaret.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(this.myStart);
        if (visualPosition == null) {
            ImaginaryCaret.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    public int getVisualLineStart() {
        throw this.notImplemented();
    }

    public int getVisualLineEnd() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(this.myStart);
        if (visualPosition == null) {
            ImaginaryCaret.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(this.myEnd);
        if (visualPosition == null) {
            ImaginaryCaret.$$$reportNull$$$0(7);
        }
        return visualPosition;
    }

    @Nullable
    public String getSelectedText() {
        return this.getEditor().getDocument().getText(new TextRange(this.myStart, this.myEnd));
    }

    public int getLeadSelectionOffset() {
        return this.getOffset();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        throw this.notImplemented();
    }

    public void setSelection(int startOffset, int endOffset) {
        if (startOffset < 0) {
            startOffset = 0;
        }
        if (endOffset < 0) {
            endOffset = 0;
        }
        if (startOffset == endOffset) {
            this.myStart = this.myPos;
            this.myEnd = this.myPos;
            return;
        }
        if (startOffset > endOffset) {
            this.myStart = endOffset;
            this.myEnd = startOffset;
        } else {
            this.myStart = startOffset;
            this.myEnd = endOffset;
        }
        if (this.myPos < this.myStart) {
            this.myPos = this.myStart;
        } else if (this.myPos > this.myEnd) {
            this.myPos = this.myEnd;
        }
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        throw this.notImplemented();
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        throw this.notImplemented();
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        throw this.notImplemented();
    }

    public void removeSelection() {
        this.myStart = this.myPos = this.myEnd;
    }

    public void selectLineAtCaret() {
        throw this.notImplemented();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        throw this.notImplemented();
    }

    @Nullable
    public Caret clone(boolean above) {
        throw this.notImplemented();
    }

    public boolean isAtRtlLocation() {
        throw this.notImplemented();
    }

    public boolean isAtBidiRunBoundary() {
        throw this.notImplemented();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        throw this.notImplemented();
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            ImaginaryCaret.$$$reportNull$$$0(8);
        }
        throw this.notImplemented();
    }

    public void dispose() {
        throw this.notImplemented();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ImaginaryCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ImaginaryCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 8 -> new IllegalArgumentException(string);
        };
    }
}

