/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.util.treeView.NodeOptions;

public interface ViewSettings
extends NodeOptions {
    public static final ViewSettings DEFAULT = new ViewSettings(){};

    default public boolean isFoldersAlwaysOnTop() {
        return true;
    }

    default public boolean isShowMembers() {
        return false;
    }

    default public boolean isStructureView() {
        return false;
    }

    default public boolean isShowModules() {
        return true;
    }

    default public boolean isShowScratchesAndConsoles() {
        return true;
    }

    default public boolean isFlattenModules() {
        return false;
    }

    default public boolean isShowURL() {
        return true;
    }

    public static class Immutable
    extends NodeOptions.Immutable
    implements ViewSettings {
        public static final ViewSettings DEFAULT = new Immutable(null);
        private final boolean myFoldersAlwaysOnTop;
        private final boolean myShowMembers;
        private final boolean myStructureView;
        private final boolean myShowModules;
        private final boolean myFlattenModules;
        private final boolean myShowURL;
        private final boolean myShowScratchesAndConsoles;

        public Immutable(ViewSettings settings) {
            super(settings);
            this.myFoldersAlwaysOnTop = settings == null || settings.isFoldersAlwaysOnTop();
            this.myShowMembers = settings != null && settings.isShowMembers();
            this.myStructureView = settings != null && settings.isStructureView();
            this.myShowModules = settings == null || settings.isShowModules();
            this.myFlattenModules = settings != null && settings.isFlattenModules();
            this.myShowURL = settings == null || settings.isShowURL();
            this.myShowScratchesAndConsoles = settings == null || settings.isShowScratchesAndConsoles();
        }

        @Override
        public boolean isFoldersAlwaysOnTop() {
            return this.myFoldersAlwaysOnTop;
        }

        @Override
        public boolean isShowMembers() {
            return this.myShowMembers;
        }

        @Override
        public boolean isStructureView() {
            return this.myStructureView;
        }

        @Override
        public boolean isShowModules() {
            return this.myShowModules;
        }

        @Override
        public boolean isFlattenModules() {
            return this.myFlattenModules;
        }

        @Override
        public boolean isShowURL() {
            return this.myShowURL;
        }

        @Override
        public boolean isShowScratchesAndConsoles() {
            return this.myShowScratchesAndConsoles;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            ViewSettings settings = (ViewSettings)object;
            return settings.isFoldersAlwaysOnTop() == this.isFoldersAlwaysOnTop() && settings.isShowMembers() == this.isShowMembers() && settings.isStructureView() == this.isStructureView() && settings.isShowModules() == this.isShowModules() && settings.isFlattenModules() == this.isFlattenModules() && settings.isShowURL() == this.isShowURL() && settings.isShowScratchesAndConsoles() == this.isShowScratchesAndConsoles();
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Boolean.hashCode(this.isFoldersAlwaysOnTop());
            result = 31 * result + Boolean.hashCode(this.isShowMembers());
            result = 31 * result + Boolean.hashCode(this.isStructureView());
            result = 31 * result + Boolean.hashCode(this.isShowModules());
            result = 31 * result + Boolean.hashCode(this.isFlattenModules());
            result = 31 * result + Boolean.hashCode(this.isShowURL());
            result = 31 * result + Boolean.hashCode(this.isShowScratchesAndConsoles());
            return result;
        }
    }
}

