/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.util.Matrix;
import com.intellij.util.Vector;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ColorBlindnessMatrix {
    private static final Matrix CORRECTION = Matrix.createIdentity((int)3);
    private static final Matrix RGB_LMS;
    private static final Matrix LMS_RGB;
    private static final Vector WHITE_BLUE;
    private static final Vector WHITE_RED;

    private static Vector cross(Vector left, Vector right) {
        return Vector.create((double[])new double[]{left.get(1) * right.get(2) - left.get(2) * right.get(1), left.get(2) * right.get(0) - left.get(0) * right.get(2), left.get(0) * right.get(1) - left.get(1) * right.get(0)});
    }

    private static Matrix calculate(Matrix simulation, Matrix correction) {
        Matrix matrix = simulation.multiply(RGB_LMS);
        if (correction == null) {
            correction = CORRECTION;
        }
        return LMS_RGB.multiply(matrix.plus(correction.multiply(RGB_LMS.minus(matrix))));
    }

    static {
        Matrix RGB_XYZ = Matrix.create((int)3, (double[])new double[]{0.4124, 0.2126, 0.0193, 0.3576, 0.7152, 0.1192, 0.1805, 0.0722, 0.9505});
        Matrix XYZ_LMS = Matrix.create((int)3, (double[])new double[]{0.7328, -0.7036, 0.003, 0.4296, 1.6975, 0.0136, -0.1624, 0.0061, 0.9834});
        RGB_LMS = RGB_XYZ.multiply(XYZ_LMS);
        LMS_RGB = RGB_LMS.inverse();
        Vector red = RGB_LMS.getRow(0);
        Vector blue = RGB_LMS.getRow(2);
        Vector white = Vector.create((double[])new double[]{1.0, 1.0, 1.0}).multiply(RGB_LMS);
        WHITE_BLUE = ColorBlindnessMatrix.cross(white, blue);
        WHITE_RED = ColorBlindnessMatrix.cross(white, red);
    }

    @ApiStatus.Internal
    public static final class Tritanopia {
        private static final double V1 = -WHITE_RED.get(0) / WHITE_RED.get(2);
        private static final double V2 = -WHITE_RED.get(1) / WHITE_RED.get(2);
        private static final Matrix SIMULATION = Matrix.create((int)3, (double[])new double[]{1.0, 0.0, V1, 0.0, 1.0, V2, 0.0, 0.0, 0.0});
        private static final Matrix CORRECTION = Matrix.create((int)3, (double[])new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.7, 0.7, 1.0});
        static final Matrix MATRIX = Tritanopia.calculate(CORRECTION);

        public static Matrix calculate(Matrix correction) {
            return ColorBlindnessMatrix.calculate(SIMULATION, correction);
        }
    }

    @ApiStatus.Internal
    public static final class Deuteranopia {
        private static final double V1 = -WHITE_BLUE.get(0) / WHITE_BLUE.get(1);
        private static final double V2 = -WHITE_BLUE.get(2) / WHITE_BLUE.get(1);
        private static final Matrix SIMULATION = Matrix.create((int)3, (double[])new double[]{1.0, V1, 0.0, 0.0, 0.0, 0.0, 0.0, V2, 1.0});
        private static final Matrix CORRECTION = Matrix.create((int)3, (double[])new double[]{1.0, 0.0, 0.0, 0.7, 1.0, 0.7, 0.0, 0.0, 1.0});
        static final Matrix MATRIX = Deuteranopia.calculate(CORRECTION);

        public static Matrix calculate(Matrix correction) {
            return ColorBlindnessMatrix.calculate(SIMULATION, correction);
        }
    }

    @ApiStatus.Internal
    public static final class Protanopia {
        private static final double V1 = -WHITE_BLUE.get(1) / WHITE_BLUE.get(0);
        private static final double V2 = -WHITE_BLUE.get(2) / WHITE_BLUE.get(0);
        private static final Matrix SIMULATION = Matrix.create((int)3, (double[])new double[]{0.0, 0.0, 0.0, V1, 1.0, 0.0, V2, 0.0, 1.0});
        private static final Matrix CORRECTION = Matrix.create((int)3, (double[])new double[]{1.0, 0.7, 0.7, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
        static final Matrix MATRIX = Protanopia.calculate(CORRECTION);

        public static Matrix calculate(Matrix correction) {
            return ColorBlindnessMatrix.calculate(SIMULATION, correction);
        }
    }
}

