/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtilsKt;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.util.ui.JBFont;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/ui/UISettingsUtils;", "", "settings", "Lcom/intellij/ide/ui/UISettings;", "<init>", "(Lcom/intellij/ide/ui/UISettings;)V", "currentIdeScale", "", "getCurrentIdeScale", "()F", "setCurrentIdeScale", "", "scale", "value", "presentationModeFontSize", "getPresentationModeFontSize", "setPresentationModeFontSize", "(F)V", "scaledConsoleFontSize", "getScaledConsoleFontSize", "scaledEditorFontSize", "getScaledEditorFontSize", "scaleFontSize", "fontSize", "currentDefaultScale", "getCurrentDefaultScale", "Companion", "intellij.platform.editor.ui"})
public final class UISettingsUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UISettings settings;

    public UISettingsUtils(@NotNull UISettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    public final float getCurrentIdeScale() {
        return this.settings.getCurrentIdeScale();
    }

    public final void setCurrentIdeScale(float scale) {
        this.settings.setCurrentIdeScale(scale);
    }

    public final float getPresentationModeFontSize() {
        return Companion.scaleFontSize(UISettingsUtils.Companion.getGlobalSchemeEditorFontSize(), this.settings.getPresentationModeIdeScale());
    }

    public final void setPresentationModeFontSize(float value) {
        this.settings.setPresentationModeIdeScale(Companion.presentationModeIdeScaleFromFontSize$intellij_platform_editor_ui(value));
    }

    public final float getScaledConsoleFontSize() {
        return Companion.scaleFontSize(EditorColorsManager.getInstance().getGlobalScheme().getConsoleFontSize2D(), this.getCurrentIdeScale());
    }

    public final float getScaledEditorFontSize() {
        return Companion.scaleFontSize(UISettingsUtils.Companion.getGlobalSchemeEditorFontSize(), this.getCurrentIdeScale());
    }

    public final float scaleFontSize(float fontSize) {
        return Companion.scaleFontSize(fontSize, this.getCurrentIdeScale());
    }

    public final float getCurrentDefaultScale() {
        return Companion.defaultScale(UISettings.Companion.getInstance().getPresentationMode());
    }

    @JvmStatic
    @NotNull
    public static final UISettingsUtils getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final UISettingsUtils with(@NotNull UISettings settings) {
        return Companion.with(settings);
    }

    @JvmStatic
    public static final float scaleFontSize(float fontSize, float scale) {
        return Companion.scaleFontSize(fontSize, scale);
    }

    @JvmStatic
    public static final int percentValue(float value) {
        return Companion.percentValue(value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000fJ\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/ui/UISettingsUtils$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/ui/UISettingsUtils;", "with", "settings", "Lcom/intellij/ide/ui/UISettings;", "globalSchemeEditorFontSize", "", "getGlobalSchemeEditorFontSize", "()F", "presentationModeIdeScaleFromFontSize", "fontSize", "presentationModeIdeScaleFromFontSize$intellij_platform_editor_ui", "scaleFontSize", "scale", "percentValue", "", "value", "defaultScale", "isPresentation", "", "intellij.platform.editor.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UISettingsUtils getInstance() {
            return new UISettingsUtils(UISettings.Companion.getInstance());
        }

        @JvmStatic
        @NotNull
        public final UISettingsUtils with(@NotNull UISettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return new UISettingsUtils(settings);
        }

        private final float getGlobalSchemeEditorFontSize() {
            return EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize2D();
        }

        /*
         * WARNING - void declaration
         */
        public final float presentationModeIdeScaleFromFontSize$intellij_platform_editor_ui(float fontSize) {
            void var2_2;
            float it = fontSize / this.getGlobalSchemeEditorFontSize();
            boolean bl = false;
            return UISettingsUtilsKt.getPercentValue(it) == 100 ? 1.0f : var2_2;
        }

        @JvmStatic
        public final float scaleFontSize(float fontSize, float scale) {
            return JBFont.scaleFontSize((float)fontSize, (float)scale);
        }

        @JvmStatic
        public final int percentValue(float value) {
            return UISettingsUtilsKt.getPercentValue(value);
        }

        public final float defaultScale(boolean isPresentation) {
            return isPresentation ? 1.75f : 1.0f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

