/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.SorterUtil;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.openapi.editor.PlatformEditorBundle;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Sorter
extends TreeAction {
    public static final Sorter[] EMPTY_ARRAY = new Sorter[0];
    public static final Sorter ALPHA_SORTER = new Sorter(){

        @Override
        public Comparator getComparator() {
            return (o1, o2) -> {
                String s1 = SorterUtil.getStringPresentation(o1);
                String s2 = SorterUtil.getStringPresentation(o2);
                return s1.compareToIgnoreCase(s2);
            };
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @NonNls
        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public ActionPresentation getPresentation() {
            return new ActionPresentationData(PlatformEditorBundle.message("action.sort.alphabetically", new Object[0]), null, AllIcons.ObjectBrowser.Sorted);
        }

        @Override
        @NotNull
        public String getName() {
            String string = Sorter.getAlphaSorterId();
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/smartTree/Sorter$1", "getName"));
        }
    };

    @NonNls
    @NotNull
    public static String getAlphaSorterId() {
        return "ALPHA_COMPARATOR";
    }

    public Comparator getComparator();

    public boolean isVisible();
}

