/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.LogicalPosition;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CaretState {
    private final LogicalPosition caretPosition;
    private final int visualColumnAdjustment;
    private final LogicalPosition selectionStart;
    private final LogicalPosition selectionEnd;

    public CaretState(@Nullable LogicalPosition caretPosition, @Nullable LogicalPosition selectionStart, @Nullable LogicalPosition selectionEnd) {
        this(caretPosition, 0, selectionStart, selectionEnd);
    }

    public CaretState(@Nullable LogicalPosition caretPosition, int visualColumnAdjustment, @Nullable LogicalPosition selectionStart, @Nullable LogicalPosition selectionEnd) {
        this.caretPosition = caretPosition;
        this.visualColumnAdjustment = visualColumnAdjustment;
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
    }

    @Nullable
    public LogicalPosition getCaretPosition() {
        return this.caretPosition;
    }

    public int getVisualColumnAdjustment() {
        return this.visualColumnAdjustment;
    }

    @Nullable
    public LogicalPosition getSelectionStart() {
        return this.selectionStart;
    }

    @Nullable
    public LogicalPosition getSelectionEnd() {
        return this.selectionEnd;
    }

    @NonNls
    public String toString() {
        return "CaretState{caretPosition=" + String.valueOf(this.caretPosition) + (String)(this.visualColumnAdjustment == 0 ? "" : ", visualColumnAdjustment=" + this.visualColumnAdjustment) + ", selectionStart=" + String.valueOf(this.selectionStart) + ", selectionEnd=" + String.valueOf(this.selectionEnd) + "}";
    }
}

