/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.rd;

import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.rd.LocalEditorSupportBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\tH\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u000bH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0002\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"isLocalEditorUx", "", "()Z", "isMonolith", "assertLocalEditorSupport", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isLocalEditorSupport", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLocalEditorSupportInternal", "Lcom/intellij/openapi/fileTypes/FileType;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/editor/rd/LocalEditorSupportBean;", "localEditorSupportBeanFor", "fileType", "intellij.platform.editor.ui"})
@ApiStatus.Internal
@JvmName(name="LocalEditorSupportUtil")
public final class LocalEditorSupportUtil {
    @NotNull
    private static final ExtensionPointName<LocalEditorSupportBean> EP_NAME = new ExtensionPointName("com.intellij.editor.rd.localSupport");

    public static final boolean isLocalEditorUx() {
        return Registry.Companion.is("editor.rd.local.ux");
    }

    public static final boolean isMonolith() {
        return LocalEditorSupportUtil.isLocalEditorUx() || AppModeAssertions.isMonolith();
    }

    public static final void assertLocalEditorSupport(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (LocalEditorSupportUtil.isLocalEditorSupport(editor)) {
            AppModeAssertions.assertFrontend((boolean)false);
        }
    }

    public static final boolean isLocalEditorSupport(@NotNull Editor $this$isLocalEditorSupport) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalEditorSupport, (String)"<this>");
        if (!LocalEditorSupportUtil.isLocalEditorUx()) {
            return false;
        }
        VirtualFile virtualFile = $this$isLocalEditorSupport.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return LocalEditorSupportUtil.isLocalEditorSupportInternal(virtualFile);
    }

    public static final boolean isLocalEditorSupport(@NotNull VirtualFile $this$isLocalEditorSupport) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalEditorSupport, (String)"<this>");
        if (!LocalEditorSupportUtil.isLocalEditorUx()) {
            return false;
        }
        return LocalEditorSupportUtil.isLocalEditorSupportInternal($this$isLocalEditorSupport);
    }

    private static final boolean isLocalEditorSupportInternal(VirtualFile $this$isLocalEditorSupportInternal) {
        FileType fileType = $this$isLocalEditorSupportInternal.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return LocalEditorSupportUtil.isLocalEditorSupport(fileType);
    }

    private static final boolean isLocalEditorSupport(FileType $this$isLocalEditorSupport) {
        return LocalEditorSupportUtil.localEditorSupportBeanFor($this$isLocalEditorSupport) != null;
    }

    private static final LocalEditorSupportBean localEditorSupportBeanFor(FileType fileType) {
        String string = fileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (LocalEditorSupportBean)EP_NAME.getByKey((Object)string, LocalEditorSupportBean.class, LocalEditorSupportBean::getKey);
    }
}

