/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import java.awt.Color;
import java.util.function.Supplier;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class FileStatusImpl
implements FileStatus {
    private final String myStatus;
    private final ColorKey myColorKey;
    private final Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> myTextSupplier;

    FileStatusImpl(@NotNull String status, @NotNull ColorKey key, @NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> textSupplier) {
        if (status == null) {
            FileStatusImpl.$$$reportNull$$$0(0);
        }
        if (key == null) {
            FileStatusImpl.$$$reportNull$$$0(1);
        }
        if (textSupplier == null) {
            FileStatusImpl.$$$reportNull$$$0(2);
        }
        this.myStatus = status;
        this.myColorKey = key;
        this.myTextSupplier = textSupplier;
    }

    @NonNls
    public String toString() {
        return this.myStatus;
    }

    @Override
    public String getText() {
        return this.myTextSupplier.get();
    }

    @Override
    public Color getColor() {
        Color themeColor = UIManager.getColor(FileStatusFactory.getFilestatusUiThemePrefix() + this.myStatus);
        if (themeColor != null) {
            return themeColor;
        }
        return EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getColor(this.myColorKey);
    }

    @Override
    @NotNull
    public ColorKey getColorKey() {
        ColorKey colorKey = this.myColorKey;
        if (colorKey == null) {
            FileStatusImpl.$$$reportNull$$$0(3);
        }
        return colorKey;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myStatus;
        if (string == null) {
            FileStatusImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textSupplier";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/FileStatusImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/FileStatusImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

