/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.InplaceCommentAppender;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.presentation.FilePresentationService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractTreeNode<T>
extends PresentableNodeDescriptor<AbstractTreeNode<T>>
implements NavigationItem,
Queryable.Contributor,
LeafState.Supplier {
    private static final TextAttributesKey FILESTATUS_ERRORS = TextAttributesKey.createTextAttributesKey((String)"FILESTATUS_ERRORS");
    private static final Logger LOG = Logger.getInstance(AbstractTreeNode.class);
    private AbstractTreeNode<?> parent;
    private Object myValue;
    private boolean myNullValueSet;
    private final boolean myNodeWrapper;
    protected static final Object TREE_WRAPPER_VALUE = new Object();

    protected AbstractTreeNode(Project project, @NotNull T value) {
        if (value == null) {
            AbstractTreeNode.$$$reportNull$$$0(0);
        }
        super(project, (NodeDescriptor)null);
        this.myNodeWrapper = this.setInternalValue(value);
    }

    public abstract @Unmodifiable @NotNull Collection<? extends AbstractTreeNode<?>> getChildren();

    protected boolean hasProblemFileBeneath() {
        return false;
    }

    protected boolean valueIsCut() {
        return CopyPasteManager.getInstance().isCutElement(this.getValue());
    }

    @Override
    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        Collection<AbstractTreeNode<?>> kids = this.getChildren();
        int i = 0;
        for (AbstractTreeNode<?> kid : kids) {
            if (i == index) {
                return kid;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void postprocess(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(1);
        }
        this.setFileStatusErrors(presentation);
        this.setForcedForeground(presentation);
        this.appendInplaceComments(presentation);
    }

    private void setFileStatusErrors(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(2);
        }
        if (this.hasProblemFileBeneath()) {
            presentation.setAttributesKey(FILESTATUS_ERRORS);
        }
    }

    private void appendInplaceComments(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(3);
        }
        this.appendInplaceComments(new PresentationDataInplaceCommentAppender(presentation));
    }

    protected void appendInplaceComments(@NotNull InplaceCommentAppender appender) {
        if (appender == null) {
            AbstractTreeNode.$$$reportNull$$$0(4);
        }
    }

    private void setForcedForeground(@NotNull PresentationData presentation) {
        FileStatus status;
        Color fgColor;
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(5);
        }
        Color color = fgColor = (fgColor = this.getFileStatusColor(status = this.getFileStatus())) == null ? status.getColor() : fgColor;
        if (this.valueIsCut()) {
            fgColor = CopyPasteManager.getCutColor();
        }
        if (presentation.getForcedTextForeground() == null) {
            presentation.setForcedTextForeground(fgColor);
        }
    }

    @Override
    protected boolean shouldUpdateData() {
        return !this.myProject.isDisposed() && this.getEqualityObject() != null;
    }

    @Override
    @NotNull
    public LeafState getLeafState() {
        if (this.isAlwaysShowPlus()) {
            LeafState leafState = LeafState.NEVER;
            if (leafState == null) {
                AbstractTreeNode.$$$reportNull$$$0(6);
            }
            return leafState;
        }
        if (this.isAlwaysLeaf()) {
            LeafState leafState = LeafState.ALWAYS;
            if (leafState == null) {
                AbstractTreeNode.$$$reportNull$$$0(7);
            }
            return leafState;
        }
        LeafState leafState = LeafState.DEFAULT;
        if (leafState == null) {
            AbstractTreeNode.$$$reportNull$$$0(8);
        }
        return leafState;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public boolean isAlwaysExpand() {
        return false;
    }

    public boolean isIncludedInExpandAll() {
        return true;
    }

    public boolean isAutoExpandAllowed() {
        return true;
    }

    @Override
    @Nullable
    public final AbstractTreeNode<T> getElement() {
        return this.getEqualityObject() != null ? this : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return Comparing.equal((Object)this.myValue, (Object)((AbstractTreeNode)object).myValue);
    }

    public int hashCode() {
        Object value = this.myValue;
        return value == null ? 0 : value.hashCode();
    }

    public final AbstractTreeNode getParent() {
        return this.parent;
    }

    public final void setParent(AbstractTreeNode parent) {
        this.parent = parent;
    }

    @Override
    public final NodeDescriptor<?> getParentDescriptor() {
        return this.parent;
    }

    public final T getValue() {
        Object value = this.getEqualityObject();
        return (T)(value == null ? null : TreeAnchorizer.getService().retrieveElement(value));
    }

    public final void setValue(T value) {
        boolean debug = !this.myNodeWrapper && LOG.isDebugEnabled();
        int hash = !debug ? 0 : this.hashCode();
        this.myNullValueSet = value == null || this.setInternalValue(value);
        this.recordValueSetTrace(this.myNullValueSet);
        if (debug && hash != this.hashCode()) {
            LOG.warn("hash code changed: " + String.valueOf(this.myValue));
        }
    }

    protected void recordValueSetTrace(boolean nullValue) {
    }

    private boolean setInternalValue(@NotNull T value) {
        if (value == null) {
            AbstractTreeNode.$$$reportNull$$$0(9);
        }
        if (value == TREE_WRAPPER_VALUE) {
            return true;
        }
        this.myValue = TreeAnchorizer.getService().createAnchor(value);
        return false;
    }

    public final Object getEqualityObject() {
        return this.myNullValueSet ? null : this.myValue;
    }

    @TestOnly
    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        if (this.getValue() instanceof Queryable) {
            return Queryable.Util.print((Queryable)((Queryable)this.getValue()), (Queryable.PrintInfo)printInfo, (Queryable.Contributor)this);
        }
        return this.getTestPresentation();
    }

    public void apply(@NotNull Map<String, String> info) {
        if (info == null) {
            AbstractTreeNode.$$$reportNull$$$0(10);
        }
    }

    @Deprecated
    @TestOnly
    @Nullable
    @NonNls
    public String getTestPresentation() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    @Nullable
    public Color getFileStatusColor(FileStatus status) {
        VirtualFile vf;
        if (FileStatus.NOT_CHANGED.equals(status) && this.myProject != null && !this.myProject.isDefault() && (vf = this.getVirtualFile()) != null && vf.isDirectory()) {
            return FileStatusManager.getInstance(this.myProject).getRecursiveStatus(vf).getColor();
        }
        return status.getColor();
    }

    protected VirtualFile getVirtualFile() {
        return null;
    }

    public FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Nullable
    protected final Object getParentValue() {
        AbstractTreeNode parent = this.getParent();
        return parent == null ? null : parent.getValue();
    }

    public boolean canRepresent(Object element) {
        return Comparing.equal(this.getValue(), (Object)element);
    }

    @Override
    @Nullable
    protected Color computeBackgroundColor() {
        T value = this.getValue();
        if (!(value instanceof PsiElement)) {
            return null;
        }
        PsiElement element = (PsiElement)value;
        return FilePresentationService.getInstance(element.getProject()).getFileBackgroundColor(element);
    }

    @Nullable
    private VirtualFile extractFileFromValue() {
        Object value = this.getEqualityObject();
        if (value instanceof SmartPsiElementPointer) {
            SmartPsiElementPointer pointer = (SmartPsiElementPointer)value;
            return pointer.getVirtualFile();
        }
        return null;
    }

    @ApiStatus.Internal
    public final boolean mayContain(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        VirtualFile ancestor = this.extractFileFromValue();
        if (ancestor == null) {
            return true;
        }
        if (!ancestor.isValid()) {
            return false;
        }
        if (object instanceof PsiElement) {
            object = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
        }
        if (object instanceof VirtualFile) {
            VirtualFile file = (VirtualFile)object;
            if (!file.isValid()) {
                return false;
            }
            return VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeNode";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postprocess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFileStatusErrors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendInplaceComments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setForcedForeground";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setInternalValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class PresentationDataInplaceCommentAppender
    implements InplaceCommentAppender {
        @NotNull
        private final PresentationData myPresentation;

        PresentationDataInplaceCommentAppender(@NotNull PresentationData presentation) {
            if (presentation == null) {
                PresentationDataInplaceCommentAppender.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation;
        }

        @Override
        public void append(@NotNull @NlsSafe String text, @NotNull SimpleTextAttributes attributes) {
            if (text == null) {
                PresentationDataInplaceCommentAppender.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                PresentationDataInplaceCommentAppender.$$$reportNull$$$0(2);
            }
            if (this.myPresentation.getColoredText().isEmpty() && this.myPresentation.getPresentableText() != null) {
                this.myPresentation.addText(this.myPresentation.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.myPresentation.addText(text, attributes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeNode$PresentationDataInplaceCommentAppender";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

