/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.WeightFilter;
import java.awt.image.ImageFilter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SimulationFilter
extends WeightFilter {
    public static final ImageFilter protanopia = SimulationFilter.forProtanopia(null);
    public static final ImageFilter deuteranopia = SimulationFilter.forDeuteranopia(null);
    public static final ImageFilter tritanopia = SimulationFilter.forTritanopia(null);
    public static final ImageFilter achromatopsia = SimulationFilter.forAchromatopsia(null);
    private final double myConfuseX;
    private final double myConfuseY;
    private final double myConfuseM;
    private final double myConfuseYint;

    public static ImageFilter get(ColorBlindness blindness) {
        if (blindness == ColorBlindness.protanopia) {
            return protanopia;
        }
        if (blindness == ColorBlindness.deuteranopia) {
            return deuteranopia;
        }
        if (blindness == ColorBlindness.tritanopia) {
            return tritanopia;
        }
        if (blindness == ColorBlindness.achromatopsia) {
            return achromatopsia;
        }
        return null;
    }

    public static ImageFilter forProtanopia(Double weight) {
        return new SimulationFilter("Protanopia", weight, 0.7465, 0.2535, 1.273463, -0.073894);
    }

    public static ImageFilter forDeuteranopia(Double weight) {
        return new SimulationFilter("Deuteranopia", weight, 1.4, -0.4, 0.968437, 0.003331);
    }

    public static ImageFilter forTritanopia(Double weight) {
        return new SimulationFilter("Tritanopia", weight, 0.1748, 0.0, 0.062921, 0.292119);
    }

    public static ImageFilter forAchromatopsia(Double weight) {
        return new WeightFilter("Achromatopsia (simulation)", weight){

            @Override
            int toRGB(int srcR, int srcG, int srcB) {
                double gray = 0.212656 * (double)srcR + 0.715158 * (double)srcG + 0.072186 * (double)srcB;
                return this.toRGB(srcR, srcG, srcB, gray, gray, gray);
            }
        };
    }

    private SimulationFilter(String name, Double weight, double x, double y, double m, double yint) {
        super(name + " (simulation)", weight);
        this.myConfuseX = x;
        this.myConfuseY = y;
        this.myConfuseM = m;
        this.myConfuseYint = yint;
    }

    @Override
    int toRGB(int srcR, int srcG, int srcB) {
        double powR = Math.pow(srcR, 2.2);
        double powG = Math.pow(srcG, 2.2);
        double powB = Math.pow(srcB, 2.2);
        double X = 0.412424 * powR + 0.357579 * powG + 0.180464 * powB;
        double Y = 0.212656 * powR + 0.715158 * powG + 0.0721856 * powB;
        double Z = 0.0193324 * powR + 0.119193 * powG + 0.950444 * powB;
        double chroma_x = X / (X + Y + Z);
        double chroma_y = Y / (X + Y + Z);
        double m = (chroma_y - this.myConfuseY) / (chroma_x - this.myConfuseX);
        double yint = chroma_y - chroma_x * m;
        double deviate_x = (this.myConfuseYint - yint) / (m - this.myConfuseM);
        double deviate_y = m * deviate_x + yint;
        X = deviate_x * Y / deviate_y;
        Z = (1.0 - (deviate_x + deviate_y)) * Y / deviate_y;
        double neutral_X = Y * 0.312713 / 0.329016;
        double neutral_Z = Y * 0.358271 / 0.329016;
        double diffX = neutral_X - X;
        double diffZ = neutral_Z - Z;
        double diffR = 3.24071 * diffX - 0.498571 * diffZ;
        double diffG = -0.969258 * diffX + 0.0415557 * diffZ;
        double diffB = 0.0556352 * diffX + 1.05707 * diffZ;
        double dstR = 3.24071 * X - 1.53726 * Y - 0.498571 * Z;
        double dstG = -0.969258 * X + 1.87599 * Y + 0.0415557 * Z;
        double dstB = 0.0556352 * X - 0.203996 * Y + 1.05707 * Z;
        double fitR = ((double)(!(dstR < 0.0) ? 1 : 0) - dstR) / diffR;
        double fitG = ((double)(!(dstG < 0.0) ? 1 : 0) - dstG) / diffG;
        double fitB = ((double)(!(dstB < 0.0) ? 1 : 0) - dstB) / diffB;
        double adjust = Math.max(Math.max(fitR < 0.0 || 1.0 < fitR ? 0.0 : fitR, fitG < 0.0 || 1.0 < fitG ? 0.0 : fitG), fitB < 0.0 || 1.0 < fitB ? 0.0 : fitB);
        dstR += adjust * diffR;
        dstG += adjust * diffG;
        dstB += adjust * diffB;
        dstR = Math.pow(dstR, 0.45454545454545453);
        dstG = Math.pow(dstG, 0.45454545454545453);
        dstB = Math.pow(dstB, 0.45454545454545453);
        return this.toRGB(srcR, srcG, srcB, dstR, dstG, dstB);
    }
}

