/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import java.awt.image.RGBImageFilter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;

@ApiStatus.Internal
public abstract class WeightFilter
extends RGBImageFilter {
    private final String myName;
    private final Double myWeight;

    WeightFilter(String name, Double weight) {
        if (weight != null) {
            if (weight < 0.0 || 1.0 < weight) {
                throw new IllegalArgumentException("weight " + weight + " out of [0..1]");
            }
            name = (String)name + " weight: " + weight;
        }
        this.myName = name;
        this.myWeight = weight;
        this.canFilterIndexColorModel = true;
    }

    @NonNls
    public String toString() {
        return this.myName;
    }

    @Override
    public final int filterRGB(int x, int y, int rgb) {
        return 0xFF000000 & rgb | this.toRGB(0xFF & rgb >> 16, 0xFF & rgb >> 8, 0xFF & rgb);
    }

    abstract int toRGB(int var1, int var2, int var3);

    final int toRGB(int srcR, int srcG, int srcB, double dstR, double dstG, double dstB) {
        if (Double.isNaN(dstR)) {
            dstR = 0.0;
        }
        if (Double.isNaN(dstG)) {
            dstG = 0.0;
        }
        if (Double.isNaN(dstB)) {
            dstB = 0.0;
        }
        if (this.myWeight != null) {
            dstR = dstR * this.myWeight + (double)srcR * (1.0 - this.myWeight);
            dstG = dstG * this.myWeight + (double)srcG * (1.0 - this.myWeight);
            dstB = dstB * this.myWeight + (double)srcB * (1.0 - this.myWeight);
        }
        srcR = (int)dstR;
        srcG = (int)dstG;
        srcB = (int)dstB;
        return srcR << 16 | srcG << 8 | srcB;
    }

    static double fix(double value) {
        return Double.isNaN(value) || value < 0.0 ? 0.0 : (value > 255.0 ? 255.0 : value);
    }
}

