/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class EditorFactory {
    public static EditorFactory getInstance() {
        return (EditorFactory)ApplicationManager.getApplication().getService(EditorFactory.class);
    }

    @NotNull
    public abstract Document createDocument(@NotNull CharSequence var1);

    @NotNull
    public abstract Document createDocument(char @NotNull [] var1);

    @RequiresEdt
    public abstract Editor createEditor(@NotNull Document var1);

    @RequiresEdt
    public abstract Editor createViewer(@NotNull Document var1);

    @RequiresEdt
    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2);

    @RequiresEdt
    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2, @NotNull EditorKind var3);

    @RequiresEdt
    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2, @NotNull FileType var3, boolean var4);

    @RequiresEdt
    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2, @NotNull VirtualFile var3, boolean var4);

    @RequiresEdt
    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2, @NotNull VirtualFile var3, boolean var4, @NotNull EditorKind var5);

    @RequiresEdt
    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2);

    @RequiresEdt
    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2, @NotNull EditorKind var3);

    @RequiresEdt
    public abstract void releaseEditor(@NotNull Editor var1);

    @NotNull
    public abstract Stream<Editor> editors(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public final Stream<Editor> editors(@NotNull Document document) {
        if (document == null) {
            EditorFactory.$$$reportNull$$$0(0);
        }
        Stream<Editor> stream = this.editors(document, null);
        if (stream == null) {
            EditorFactory.$$$reportNull$$$0(1);
        }
        return stream;
    }

    public final Editor @NotNull [] getEditors(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            EditorFactory.$$$reportNull$$$0(2);
        }
        Editor[] editorArray = (Editor[])this.editors(document, project).toArray(Editor[]::new);
        if (editorArray == null) {
            EditorFactory.$$$reportNull$$$0(3);
        }
        return editorArray;
    }

    public final Editor @NotNull [] getEditors(@NotNull Document document) {
        if (document == null) {
            EditorFactory.$$$reportNull$$$0(4);
        }
        return this.getEditors(document, null);
    }

    public abstract Editor @NotNull [] getAllEditors();

    @NotNull
    public abstract List<Editor> getEditorList();

    @Deprecated(forRemoval=true)
    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1);

    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1, @NotNull Disposable var2);

    @Deprecated(forRemoval=true)
    public abstract void removeEditorFactoryListener(@NotNull EditorFactoryListener var1);

    @NotNull
    public abstract EditorEventMulticaster getEventMulticaster();

    @RequiresEdt
    public abstract void refreshAllEditors();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "editors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editors";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

