/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreferences {
    @NlsSafe
    @NotNull
    public static final String DEFAULT_FONT_NAME = FontPreferences.getDefaultFontName();
    public static final String JETBRAINS_MONO = "JetBrains Mono";
    public static final int DEFAULT_FONT_SIZE = SystemInfo.isWindows || "JetBrains Mono".equalsIgnoreCase(DEFAULT_FONT_NAME) ? 13 : 12;
    public static final float DEFAULT_LINE_SPACING = 1.2f;
    public static final String FALLBACK_FONT_FAMILY = "Monospaced";
    public static final String MAC_OS_DEFAULT_FONT_FAMILY = "Menlo";
    public static final String LINUX_DEFAULT_FONT_FAMILY = "DejaVu Sans Mono";
    public static final String WINDOWS_DEFAULT_FONT_FAMILY = "Consolas";

    public @NotNull List<@NlsSafe String> getEffectiveFontFamilies() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            FontPreferences.$$$reportNull$$$0(0);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getRealFontFamilies() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            FontPreferences.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    @NlsSafe
    public String getFontFamily() {
        return FALLBACK_FONT_FAMILY;
    }

    @NlsSafe
    @Nullable
    public String getRegularSubFamily() {
        return null;
    }

    @NlsSafe
    @Nullable
    public String getBoldSubFamily() {
        return null;
    }

    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            FontPreferences.$$$reportNull$$$0(2);
        }
        return DEFAULT_FONT_SIZE;
    }

    public float getSize2D(@NotNull String fontFamily) {
        if (fontFamily == null) {
            FontPreferences.$$$reportNull$$$0(3);
        }
        return this.getSize(fontFamily);
    }

    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            FontPreferences.$$$reportNull$$$0(4);
        }
    }

    public boolean useLigatures() {
        return false;
    }

    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            FontPreferences.$$$reportNull$$$0(5);
        }
        return false;
    }

    public float getLineSpacing() {
        return 1.2f;
    }

    @NlsSafe
    public static String getDefaultFontName() {
        if (SystemInfo.isJetBrainsJvm) {
            return JETBRAINS_MONO;
        }
        if (SystemInfo.isWindows) {
            return WINDOWS_DEFAULT_FONT_FAMILY;
        }
        if (SystemInfoRt.isMac) {
            return MAC_OS_DEFAULT_FONT_FAMILY;
        }
        if (SystemInfoRt.isLinux && !GraphicsEnvironment.isHeadless() && !ApplicationManager.getApplication().isCommandLine()) {
            for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!LINUX_DEFAULT_FONT_FAMILY.equals(font.getName())) continue;
                return font.getFontName();
            }
        }
        return FALLBACK_FONT_FAMILY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/FontPreferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFontFamilies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealFontFamilies";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/FontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSize2D";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

