/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorMouseEvent
extends EventObject {
    @NotNull
    private final MouseEvent myMouseEvent;
    private final EditorMouseEventArea myEditorArea;
    private final int myOffset;
    private final LogicalPosition myLogicalPosition;
    private final VisualPosition myVisualPosition;
    private final boolean myIsOverText;
    private final FoldRegion myCollapsedFoldRegion;
    private final Inlay myInlay;
    private final GutterIconRenderer myGutterIconRenderer;

    public EditorMouseEvent(@NotNull Editor editor, @NotNull MouseEvent mouseEvent, EditorMouseEventArea area) {
        if (editor == null) {
            EditorMouseEvent.$$$reportNull$$$0(0);
        }
        if (mouseEvent == null) {
            EditorMouseEvent.$$$reportNull$$$0(1);
        }
        this(editor, mouseEvent, area, 0, new LogicalPosition(0, 0), new VisualPosition(0, 0), true, null, null, null);
    }

    public EditorMouseEvent(@NotNull Editor editor, @NotNull MouseEvent mouseEvent, EditorMouseEventArea area, int offset, @NotNull LogicalPosition logicalPosition, @NotNull VisualPosition visualPosition, boolean isOverText, FoldRegion collapsedFoldRegion, Inlay inlay, GutterIconRenderer gutterIconRenderer) {
        if (editor == null) {
            EditorMouseEvent.$$$reportNull$$$0(2);
        }
        if (mouseEvent == null) {
            EditorMouseEvent.$$$reportNull$$$0(3);
        }
        if (logicalPosition == null) {
            EditorMouseEvent.$$$reportNull$$$0(4);
        }
        if (visualPosition == null) {
            EditorMouseEvent.$$$reportNull$$$0(5);
        }
        super(editor);
        this.myMouseEvent = mouseEvent;
        this.myEditorArea = area;
        this.myOffset = offset;
        this.myLogicalPosition = logicalPosition;
        this.myVisualPosition = visualPosition;
        this.myIsOverText = isOverText;
        this.myCollapsedFoldRegion = collapsedFoldRegion;
        this.myInlay = inlay;
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = (Editor)this.getSource();
        if (editor == null) {
            EditorMouseEvent.$$$reportNull$$$0(6);
        }
        return editor;
    }

    @NotNull
    public MouseEvent getMouseEvent() {
        MouseEvent mouseEvent = this.myMouseEvent;
        if (mouseEvent == null) {
            EditorMouseEvent.$$$reportNull$$$0(7);
        }
        return mouseEvent;
    }

    public void consume() {
        this.myMouseEvent.consume();
    }

    public boolean isConsumed() {
        return this.myMouseEvent.isConsumed();
    }

    public EditorMouseEventArea getArea() {
        return this.myEditorArea;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.myLogicalPosition;
        if (logicalPosition == null) {
            EditorMouseEvent.$$$reportNull$$$0(8);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.myVisualPosition;
        if (visualPosition == null) {
            EditorMouseEvent.$$$reportNull$$$0(9);
        }
        return visualPosition;
    }

    public boolean isOverText() {
        return this.myIsOverText;
    }

    @Nullable
    public FoldRegion getCollapsedFoldRegion() {
        return this.myCollapsedFoldRegion == null || !this.myCollapsedFoldRegion.isValid() ? null : this.myCollapsedFoldRegion;
    }

    @Nullable
    public Inlay getInlay() {
        return this.myInlay == null || !this.myInlay.isValid() ? null : this.myInlay;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/event/EditorMouseEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/event/EditorMouseEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseEvent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

