/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntaxHighlighterBase
implements SyntaxHighlighter {
    private static final Logger LOG = Logger.getInstance(SyntaxHighlighterBase.class);
    @Deprecated
    protected static final TextAttributesKey[] EMPTY = TextAttributesKey.EMPTY_ARRAY;

    public static TextAttributesKey @NotNull [] pack(@Nullable TextAttributesKey key) {
        TextAttributesKey[] textAttributesKeyArray;
        if (key == null) {
            textAttributesKeyArray = TextAttributesKey.EMPTY_ARRAY;
        } else {
            TextAttributesKey[] textAttributesKeyArray2 = new TextAttributesKey[1];
            textAttributesKeyArray = textAttributesKeyArray2;
            textAttributesKeyArray2[0] = key;
        }
        if (textAttributesKeyArray == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    public static TextAttributesKey @NotNull [] pack(@Nullable TextAttributesKey key1, @Nullable TextAttributesKey key2) {
        if (key1 == null) {
            return SyntaxHighlighterBase.pack(key2);
        }
        if (key2 == null) {
            return SyntaxHighlighterBase.pack(key1);
        }
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{key1, key2};
        if (textAttributesKeyArray == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    public static TextAttributesKey @NotNull [] pack(TextAttributesKey @NotNull [] base, @Nullable TextAttributesKey key) {
        if (base == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(2);
        }
        if (key == null) {
            if (base == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(3);
            }
            return base;
        }
        TextAttributesKey[] result = Arrays.copyOf(base, base.length + 1);
        result[base.length] = key;
        if (result == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(4);
        }
        return result;
    }

    @NotNull
    public static @NotNull TextAttributesKey @NotNull [] pack(@Nullable TextAttributesKey key, @NotNull @NotNull TextAttributesKey @NotNull [] base) {
        if (base == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(5);
        }
        if (key == null) {
            if (base == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(6);
            }
            return base;
        }
        TextAttributesKey[] result = new TextAttributesKey[base.length + 1];
        System.arraycopy(base, 0, result, 1, base.length);
        result[0] = key;
        if (result == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(7);
        }
        return result;
    }

    @NotNull
    public static @NotNull TextAttributesKey @NotNull [] pack(TextAttributesKey @NotNull [] base, @Nullable TextAttributesKey t1, @Nullable TextAttributesKey t2) {
        if (base == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(8);
        }
        int add = 0;
        if (t1 != null) {
            ++add;
        }
        if (t2 != null) {
            ++add;
        }
        if (add == 0) {
            if (base == null) {
                SyntaxHighlighterBase.$$$reportNull$$$0(9);
            }
            return base;
        }
        TextAttributesKey[] result = Arrays.copyOf(base, base.length + add);
        add = base.length;
        if (t1 != null) {
            result[add++] = t1;
        }
        if (t2 != null) {
            result[add] = t2;
        }
        if (result == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(10);
        }
        return result;
    }

    public static void fillMap(@NotNull Map<? super IElementType, ? super TextAttributesKey> map, @NotNull TokenSet keys, @NotNull TextAttributesKey value) {
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(11);
        }
        if (keys == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(12);
        }
        if (value == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(13);
        }
        SyntaxHighlighterBase.fillMap(map, value, keys.getTypes());
    }

    protected static void fillMap(@NotNull Map<? super IElementType, ? super TextAttributesKey> map, @NotNull TextAttributesKey value, IElementType ... types) {
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(14);
        }
        if (value == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(15);
        }
        if (types == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(16);
        }
        for (IElementType type : types) {
            map.put((IElementType)type, (TextAttributesKey)value);
        }
    }

    protected static void safeMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull TokenSet keys, @NotNull TextAttributesKey value) {
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(17);
        }
        if (keys == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(18);
        }
        if (value == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(19);
        }
        for (IElementType type : keys.getTypes()) {
            SyntaxHighlighterBase.safeMap(map, type, value);
        }
    }

    protected static void safeMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull IElementType type, @NotNull TextAttributesKey value) {
        TextAttributesKey oldVal;
        if (map == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(20);
        }
        if (type == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(21);
        }
        if (value == null) {
            SyntaxHighlighterBase.$$$reportNull$$$0(22);
        }
        if ((oldVal = map.put(type, value)) != null && !oldVal.equals((Object)value)) {
            LOG.error("Remapping highlighting for \"" + String.valueOf(type) + "\" val: old=" + String.valueOf(oldVal) + " new=" + String.valueOf(value));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/SyntaxHighlighterBase";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pack";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/SyntaxHighlighterBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pack";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "safeMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 5, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }
}

