/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableNodeDescriptor<E>
extends NodeDescriptor<E> {
    @Nullable
    private volatile PresentationData myTemplatePresentation = null;
    @Nullable
    private volatile PresentationData myUpdatedPresentation = null;

    protected PresentableNodeDescriptor(Project project, @Nullable NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
    }

    @Override
    public final boolean update() {
        if (this.shouldUpdateData()) {
            PresentationData before = this.getPresentation();
            PresentationData updated = this.getUpdatedPresentation();
            return this.shouldApply() && this.apply(updated, before);
        }
        return false;
    }

    protected final boolean apply(@NotNull PresentationData presentation) {
        if (presentation == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(0);
        }
        return this.apply(presentation, null);
    }

    @Override
    public void applyFrom(@NotNull NodeDescriptor desc) {
        if (desc == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (desc instanceof PresentableNodeDescriptor) {
            this.apply(((PresentableNodeDescriptor)desc).getPresentation());
        } else {
            super.applyFrom(desc);
        }
    }

    protected final boolean apply(@NotNull PresentationData presentation, @Nullable PresentationData before) {
        if (presentation == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(2);
        }
        this.setIcon(presentation.getIcon(false));
        this.myName = presentation.getPresentableText();
        if (this.myName == null) {
            this.myName = PresentableNodeDescriptor.getColoredTextAsPlainText(presentation);
        }
        this.myColor = presentation.getForcedTextForeground();
        boolean updated = !presentation.equals(before);
        PresentationData updatedPresentation = this.myUpdatedPresentation;
        updatedPresentation = updatedPresentation == null ? this.createPresentation() : updatedPresentation.clone();
        updatedPresentation.copyFrom(presentation);
        PresentationData templatePresentation = this.myTemplatePresentation;
        if (templatePresentation != null) {
            updatedPresentation.applyFrom(templatePresentation);
        }
        updatedPresentation.setChanged(false);
        this.myUpdatedPresentation = updatedPresentation;
        return updated |= updatedPresentation.isChanged();
    }

    @NotNull
    private PresentationData getUpdatedPresentation() {
        PresentationData presentation = this.getPresentation().clone();
        presentation.clear();
        presentation.setBackground(this.computeBackgroundColor());
        this.update(presentation);
        if (this.shouldPostprocess()) {
            this.postprocess(presentation);
        }
        this.myUpdatedPresentation = presentation;
        PresentationData presentationData = presentation;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(3);
        }
        return presentationData;
    }

    @NotNull
    protected PresentationData createPresentation() {
        return new PresentationData();
    }

    protected void postprocess(@NotNull PresentationData date) {
        if (date == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(4);
        }
    }

    protected boolean shouldPostprocess() {
        return true;
    }

    protected boolean shouldApply() {
        return true;
    }

    protected boolean shouldUpdateData() {
        return true;
    }

    @RequiresReadLock(generateAssertion=false)
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    protected Color computeBackgroundColor() {
        return null;
    }

    protected abstract void update(@NotNull PresentationData var1);

    @NotNull
    public final PresentationData getPresentation() {
        PresentationData updatedPresentation = this.myUpdatedPresentation;
        PresentationData presentationData = updatedPresentation == null ? this.getTemplatePresentation() : updatedPresentation;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(5);
        }
        return presentationData;
    }

    @NotNull
    protected final PresentationData getTemplatePresentation() {
        PresentationData templatePresentation = this.myTemplatePresentation;
        if (templatePresentation == null) {
            this.myTemplatePresentation = templatePresentation = this.createPresentation();
        }
        PresentationData presentationData = templatePresentation;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(6);
        }
        return presentationData;
    }

    public boolean isContentHighlighted() {
        return false;
    }

    public boolean isHighlightableContentNode(@NotNull PresentableNodeDescriptor<?> kid) {
        if (kid == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(7);
        }
        return true;
    }

    public PresentableNodeDescriptor<?> getChildToHighlightAt(int index) {
        return null;
    }

    public boolean isParentOf(@NotNull NodeDescriptor<?> eachNode) {
        if (eachNode == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(8);
        }
        for (NodeDescriptor<?> eachParent = eachNode.getParentDescriptor(); eachParent != null; eachParent = eachParent.getParentDescriptor()) {
            if (eachParent != this) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOrSelf(NodeDescriptor<?> selectedNode) {
        for (NodeDescriptor<?> node = selectedNode; node != null; node = node.getParentDescriptor()) {
            if (!this.equals(node)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Color getHighlightColor() {
        Color color = StartupUiUtil.isUnderDarcula() ? ColorUtil.shift((Color)UIUtil.getTreeBackground(), (double)1.1) : UIUtil.getTreeBackground().brighter();
        if (color == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(9);
        }
        return color;
    }

    @NlsSafe
    public String getName() {
        String result = PresentableNodeDescriptor.getColoredTextAsPlainText(this.getPresentation());
        return result == null ? this.myName : result;
    }

    @ApiStatus.Internal
    @Nullable
    protected static String getColoredTextAsPlainText(PresentationData presentation) {
        List<ColoredFragment> textFragments = presentation.getColoredText();
        int size = textFragments.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return textFragments.get(0).getText();
        }
        StringBuilder result = new StringBuilder();
        for (ColoredFragment each : textFragments) {
            result.append(each.getText());
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/PresentableNodeDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/PresentableNodeDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyFrom";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "postprocess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHighlightableContentNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParentOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 9 -> new IllegalStateException(string);
        };
    }

    public static final class ColoredFragment {
        @NotNull
        @NlsSafe
        private final String text;
        @NlsSafe
        private final String toolTip;
        private final SimpleTextAttributes attributes;

        public ColoredFragment(@Nullable @NlsSafe String aText, SimpleTextAttributes aAttributes) {
            this(aText, null, aAttributes);
        }

        public ColoredFragment(@NlsSafe @Nullable String aText, @NlsSafe String toolTip, SimpleTextAttributes aAttributes) {
            this.text = aText == null ? "" : aText;
            this.attributes = aAttributes;
            this.toolTip = toolTip;
        }

        @NlsSafe
        public String getToolTip() {
            return this.toolTip;
        }

        @NlsSafe
        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                ColoredFragment.$$$reportNull$$$0(0);
            }
            return string;
        }

        public SimpleTextAttributes getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredFragment that = (ColoredFragment)o;
            return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.text, that.text) && Objects.equals(this.toolTip, that.toolTip);
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = 31 * result + (this.toolTip != null ? this.toolTip.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/PresentableNodeDescriptor$ColoredFragment", "getText"));
        }
    }
}

