/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ActionClassMetaData {
    private static final int INIT = 1;
    private static final int UPDATE = 2;
    private static final int CHILDREN = 4;
    private static final int POSTPROCESS = 8;
    private static final int WRAPPER_UPDATE = 16;
    private static final int WRAPPER_CHILDREN = 32;
    private static final int WRAPPER_POSTPROCESS = 64;

    private ActionClassMetaData() {
    }

    public static boolean isDefaultUpdate(@NotNull AnAction action) {
        if (action == null) {
            ActionClassMetaData.$$$reportNull$$$0(0);
        }
        return BitUtil.isSet((int)ActionClassMetaData.getFlags(action), (int)2);
    }

    public static boolean isDefaultGetChildren(@NotNull ActionGroup group) {
        if (group == null) {
            ActionClassMetaData.$$$reportNull$$$0(1);
        }
        return BitUtil.isSet((int)ActionClassMetaData.getFlags(group), (int)4);
    }

    public static boolean isDefaultPostProcessVisibleChildren(@NotNull ActionGroup group) {
        if (group == null) {
            ActionClassMetaData.$$$reportNull$$$0(2);
        }
        return BitUtil.isSet((int)ActionClassMetaData.getFlags(group), (int)8);
    }

    public static boolean isWrapperUpdate(@NotNull AnAction action) {
        if (action == null) {
            ActionClassMetaData.$$$reportNull$$$0(3);
        }
        return BitUtil.isSet((int)ActionClassMetaData.getFlags(action), (int)16);
    }

    public static boolean isWrapperGetChildren(@NotNull ActionGroup group) {
        if (group == null) {
            ActionClassMetaData.$$$reportNull$$$0(4);
        }
        return BitUtil.isSet((int)ActionClassMetaData.getFlags(group), (int)32);
    }

    public static boolean isWrapperPostProcessVisibleChildren(@NotNull ActionGroup group) {
        if (group == null) {
            ActionClassMetaData.$$$reportNull$$$0(5);
        }
        return BitUtil.isSet((int)ActionClassMetaData.getFlags(group), (int)64);
    }

    private static int getFlags(@NotNull AnAction action) {
        if (action == null) {
            ActionClassMetaData.$$$reportNull$$$0(6);
        }
        if (action.myMetaFlags != 0) {
            return action.myMetaFlags;
        }
        int flags = 1;
        boolean isGroup = action instanceof ActionGroup;
        Class c = ReflectionUtil.getMethodDeclaringClass(action.getClass(), (String)"update", (Class[])new Class[]{AnActionEvent.class});
        if (AnAction.class.equals((Object)c)) {
            flags = BitUtil.set((int)flags, (int)2, (boolean)true);
        } else if (ActionClassMetaData.isActionWrapper(c)) {
            flags = BitUtil.set((int)flags, (int)16, (boolean)true);
        }
        if (isGroup) {
            c = ReflectionUtil.getMethodDeclaringClass(action.getClass(), (String)"getChildren", (Class[])new Class[]{AnActionEvent.class});
            if (ActionClassMetaData.isDefaultActionGroup(c)) {
                flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            } else if (ActionClassMetaData.isActionWrapper(c)) {
                flags = BitUtil.set((int)flags, (int)32, (boolean)true);
            }
        }
        if (isGroup) {
            Class c1 = ReflectionUtil.getMethodDeclaringClass(action.getClass(), (String)"postProcessVisibleChildren", (Class[])new Class[]{List.class, UpdateSession.class});
            Class c2 = ReflectionUtil.getMethodDeclaringClass(action.getClass(), (String)"postProcessVisibleChildren", (Class[])new Class[]{AnActionEvent.class, List.class});
            if (ActionGroup.class.equals((Object)c1) && ActionGroup.class.equals((Object)c2)) {
                flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            } else if (ActionClassMetaData.isActionWrapper(c1) && ActionClassMetaData.isActionWrapper(c2)) {
                flags = BitUtil.set((int)flags, (int)64, (boolean)true);
            }
        }
        action.myMetaFlags = flags;
        return flags;
    }

    private static boolean isActionWrapper(@Nullable Class<?> c) {
        String s = c == null ? null : c.getName();
        return "com.intellij.openapi.actionSystem.AnActionWrapper".equals(s) || "com.intellij.openapi.actionSystem.ActionGroupWrapper".equals(s);
    }

    private static boolean isDefaultActionGroup(@Nullable Class<?> c) {
        String s = c == null ? null : c.getName();
        return "com.intellij.openapi.actionSystem.DefaultActionGroup".equals(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/ActionClassMetaData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultGetChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultPostProcessVisibleChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isWrapperUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWrapperGetChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWrapperPostProcessVisibleChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFlags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

