/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterIconRenderer
implements GutterMark,
PossiblyDumbAware,
SimpleAccessible {
    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return null;
    }

    @Nullable
    public AnAction getClickAction() {
        return null;
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return null;
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return null;
    }

    public boolean isNavigateAction() {
        return false;
    }

    @NotNull
    public Alignment getAlignment() {
        Alignment alignment = Alignment.CENTER;
        if (alignment == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        return alignment;
    }

    @Nullable
    public GutterDraggableObject getDraggableObject() {
        return null;
    }

    @NotNull
    public String getAccessibleName() {
        return GutterIconRenderer.getAccessibleName(this.getIcon(), "icon: ");
    }

    @NonNls
    @NotNull
    public final String getFeatureId() {
        return GutterIconRenderer.getAccessibleName(this.getIcon(), "");
    }

    @NotNull
    private static String getAccessibleName(@Nullable Icon icon, @NotNull String prefix) {
        String path;
        if (prefix == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        if (icon instanceof RetrievableIcon) {
            return GutterIconRenderer.getAccessibleName(((RetrievableIcon)icon).retrieveIcon(), prefix);
        }
        if (icon instanceof CompositeIcon) {
            StringBuilder b = new StringBuilder("composite icon: ");
            int count = ((CompositeIcon)icon).getIconCount();
            for (int i = 0; i < count; ++i) {
                b.append(GutterIconRenderer.getAccessibleName(((CompositeIcon)icon).getIcon(i), ""));
                if (i >= count - 1) continue;
                b.append(" & ");
            }
            String string = b.toString();
            if (string == null) {
                GutterIconRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (icon instanceof CachedImageIcon && (path = ((CachedImageIcon)icon).getOriginalPath()) != null) {
            String[] split = path.split(Pattern.quote("/") + "|" + Pattern.quote("\\"));
            String name = split[split.length - 1];
            String string = prefix + name.split(Pattern.quote("."))[0];
            if (string == null) {
                GutterIconRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = prefix + "unknown";
        if (string == null) {
            GutterIconRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getAccessibleTooltipText() {
        return this.getTooltipText();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/GutterIconRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/GutterIconRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static enum Alignment {
        LINE_NUMBERS(0),
        LEFT(1),
        RIGHT(3),
        CENTER(2);

        private final int myWeight;

        private Alignment(int weight) {
            this.myWeight = weight;
        }

        public int getWeight() {
            return this.myWeight;
        }
    }
}

