/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/eel/provider/LocalEelMachine;", "Lcom/intellij/platform/eel/EelMachine;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "name", "", "Lorg/jetbrains/annotations/NonNls;", "getName", "()Ljava/lang/String;", "osFamily", "Lcom/intellij/platform/eel/EelOsFamily;", "getOsFamily", "()Lcom/intellij/platform/eel/EelOsFamily;", "osFamily$delegate", "Lkotlin/Lazy;", "toEelApi", "Lcom/intellij/platform/eel/EelApi;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.eel.provider"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nEelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelProvider.kt\ncom/intellij/platform/eel/provider/LocalEelMachine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n1#2:211\n13#3:212\n*S KotlinDebug\n*F\n+ 1 EelProvider.kt\ncom/intellij/platform/eel/provider/LocalEelMachine\n*L\n139#1:212\n*E\n"})
public final class LocalEelMachine
implements EelMachine {
    @NotNull
    public static final LocalEelMachine INSTANCE = new LocalEelMachine();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String name;
    @NotNull
    private static final Lazy osFamily$delegate;

    private LocalEelMachine() {
    }

    @NotNull
    public String getName() {
        return name;
    }

    @NotNull
    public EelOsFamily getOsFamily() {
        Lazy lazy = osFamily$delegate;
        return (EelOsFamily)lazy.getValue();
    }

    @Nullable
    public Object toEelApi(@NotNull EelDescriptor descriptor, @NotNull Continuation<? super EelApi> $completion) {
        if (!(descriptor == LocalEelDescriptor.INSTANCE)) {
            boolean bl = false;
            String string = "Wrong descriptor: " + descriptor + " for machine: " + INSTANCE;
            throw new IllegalStateException(string.toString());
        }
        return EelProviderUtil.getLocalEel();
    }

    @NotNull
    public String toString() {
        return "LocalEelMachine";
    }

    public int hashCode() {
        return -339642532;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalEelMachine)) {
            return false;
        }
        LocalEelMachine cfr_ignored_0 = (LocalEelMachine)other;
        return true;
    }

    private static final EelOsFamily osFamily_delegate$lambda$0() {
        EelOsFamily eelOsFamily;
        if (SystemInfo.isWindows) {
            eelOsFamily = EelOsFamily.Windows;
        } else if (SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isFreeBSD) {
            eelOsFamily = EelOsFamily.Posix;
        } else {
            LOG.info("Eel is not supported on current platform");
            eelOsFamily = EelOsFamily.Posix;
        }
        return eelOsFamily;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalEelDescriptor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        name = "Local: " + System.getProperty("os.name");
        osFamily$delegate = LazyKt.lazy(LocalEelMachine::osFamily_delegate$lambda$0);
    }
}

