// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.*
import com.intellij.platform.eel.EelExecApi.ExecuteProcessOptions
import com.intellij.platform.eel.EelExecApi.InteractionOptions
import com.intellij.platform.eel.EelExecApi.PtyOrStdErrSettings
import com.intellij.platform.eel.EelExecPosixApi.PosixEnvironmentVariablesOptions.Mode
import com.intellij.platform.eel.channels.EelDelicateApi
import com.intellij.platform.eel.path.EelPath
import kotlinx.coroutines.CoroutineScope
import org.jetbrains.annotations.ApiStatus


/**
 * @param exe An **absolute** path to the executable.
 *  TODO Or do relative paths also work?
 *  
 *  All argument, all paths, should be valid for the remote machine. F.i., if the IDE runs on Windows, but IJent runs on Linux,
 *  [ExecuteProcessOptions.workingDirectory] is the path on the Linux host. There's no automatic path mapping in this interface.
 */
@GeneratedBuilder.Result
@ApiStatus.Experimental
fun EelExecPosixApi.spawnProcess(
  exe: String,
): EelExecPosixApiHelpers.SpawnProcess =
  EelExecPosixApiHelpers.SpawnProcess(
    owner = this,
    exe = exe,
  )

@GeneratedBuilder.Result
@ApiStatus.Experimental
fun EelExecPosixApi.environmentVariables(): EelExecPosixApiHelpers.EnvironmentVariables =
  EelExecPosixApiHelpers.EnvironmentVariables(
    owner = this,
  )

@ApiStatus.Experimental
object EelExecPosixApiHelpers {
  /**
   * Create it via [com.intellij.platform.eel.EelExecPosixApi.spawnProcess].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Experimental
  class SpawnProcess(
    private val owner: EelExecPosixApi,
    private var exe: String,
  ) : OwnedBuilder<EelPosixProcess> {
    private var args: List<String> = listOf()

    private var env: Map<String, String> = mapOf()

    private var interactionOptions: InteractionOptions? = null

    private var ptyOrStdErrSettings: PtyOrStdErrSettings? = interactionOptions

    private var scope: CoroutineScope? = null

    private var workingDirectory: EelPath? = null

    @ApiStatus.Experimental
    fun args(arg: List<String>): SpawnProcess = apply {
      this.args = arg
    }

    fun args(vararg arg: String): SpawnProcess = apply {
      this.args = listOf(*arg)
    }

    /**
     * By default, environment is always inherited, which may be unwanted. [ExecuteProcessOptions.env] allows
     * to alter some environment variables, it doesn't clear the variables from the parent. When the process should be started in an
     * environment like in a terminal, the response of [fetchLoginShellEnvVariables] should be put into [ExecuteProcessOptions.env].
     */
    @ApiStatus.Experimental
    fun env(arg: Map<String, String>): SpawnProcess = apply {
      this.env = arg
    }

    /**
     * An **absolute** path to the executable.
     * TODO Or do relative paths also work?
     *
     * All argument, all paths, should be valid for the remote machine. F.i., if the IDE runs on Windows, but IJent runs on Linux,
     * [ExecuteProcessOptions.workingDirectory] is the path on the Linux host. There's no automatic path mapping in this interface.
     */
    @ApiStatus.Experimental
    fun exe(arg: String): SpawnProcess = apply {
      this.exe = arg
    }

    /**
     * When set pty, be sure to accept esc codes for a terminal you are emulating.
     * This terminal should also be set in `TERM` environment variable, so setting it in [env] worth doing.
     * If not set, `xterm` will be used as a most popular one.
     *
     * See `termcap(2)`, `terminfo(2)`, `ncurses(3X)` and ISBN `0937175226`.
     */
    @ApiStatus.Experimental
    fun interactionOptions(arg: InteractionOptions?): SpawnProcess = apply {
      this.interactionOptions = arg
    }

    @Deprecated("Switch to interactionOptions", replaceWith = ReplaceWith("interactionOptions"))
    @ApiStatus.Internal
    fun ptyOrStdErrSettings(arg: PtyOrStdErrSettings?): SpawnProcess = apply {
      this.ptyOrStdErrSettings = arg
    }

    /**
     * Scope this process is bound to. Once scope dies -- this process dies as well.
     */
    fun scope(arg: CoroutineScope?): SpawnProcess = apply {
      this.scope = arg
    }

    /**
     * All argument, all paths, should be valid for the remote machine. F.i., if the IDE runs on Windows, but IJent runs on Linux,
     * [ExecuteProcessOptions.workingDirectory] is the path on the Linux host. There's no automatic path mapping in this interface.
     */
    @ApiStatus.Experimental
    fun workingDirectory(arg: EelPath?): SpawnProcess = apply {
      this.workingDirectory = arg
    }

    /**
     * Complete the builder and call [com.intellij.platform.eel.EelExecPosixApi.spawnProcess]
     * with an instance of [com.intellij.platform.eel.EelExecApi.ExecuteProcessOptions].
     */
    @ThrowsChecked(ExecuteProcessException::class)
    override suspend fun eelIt(): EelPosixProcess =
      owner.spawnProcess(
        ExecuteProcessOptionsImpl(
          args = args,
          env = env,
          exe = exe,
          interactionOptions = interactionOptions,
          ptyOrStdErrSettings = ptyOrStdErrSettings,
          scope = scope,
          workingDirectory = workingDirectory,
        )
      )
  }

  /**
   * Create it via [com.intellij.platform.eel.EelExecPosixApi.environmentVariables].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Experimental
  class EnvironmentVariables(
    private val owner: EelExecPosixApi,
  ) : OwnedBuilder<EelExecApi.EnvironmentVariablesDeferred> {
    private var mode: Mode = Mode.DEFAULT

    private var onlyActual: Boolean = false

    fun mode(arg: Mode): EnvironmentVariables = apply {
      this.mode = arg
    }

    /**
     * * On remote Eel it works like [LOGIN_NON_INTERACTIVE], but in case of an error it returns [MINIMAL] instead of throwing an exception.
     * * On local Windows and Linux it always works like [MINIMAL]
     *   because historically the IDE haven't called the shell for environment variables in most cases.
     * * On local macOS it works like [LOGIN_NON_INTERACTIVE] + [MINIMAL], but it returns values cached at start
     *   with no effect from the [onlyActual] option. This is the historical behaviour too.
     *
     * In this mode [EelExecApi.EnvironmentVariablesException] is not thrown.
     */
    fun default(): EnvironmentVariables =
      mode(Mode.DEFAULT)

    /**
     *  **Use with caution, avoid when possible.**
     *
     * This mode executes a shell process supposed to load various profile scripts:
     * `~/.profile`, `~/.bashrc`, `~/.zshrc`, `/etc/profile` and so on.
     *
     * The implementation launches an interactive shell session, so it reads all environment variables unlike [LOGIN_NON_INTERACTIVE].
     *
     * However, it's not conventional to run interactive shells without having an actual user interaction.
     * And no way for user interaction is provided.
     *
     * Here are some real cases reported by our users. They're not exceptional cases but rather usual things.
     * In these cases this mode led to inability to fetch environment variables or high CPU consumption:
     * * `ssh-add` in `~/.bashrc` waits for a key passphrase, and the shell process hangs forever, IDE becomes unusable.
     * * `~/.bashrc` starts `screen` or `tmux`, the shell process hangs forever.
     * * `~/.bashrc` starts `ssh-agent`, and the operating system quickly becomes polluted with lots of unused SSH agents.
     * * `~/.bashrc` calls `curl` to write the current weather, news, jokes, etc. CPU consumption grows, IDE works slower.
     *
     * **Notice:** In this mode [EelExecApi.EnvironmentVariablesException] MAY be thrown.
     */
    @EelDelicateApi
    fun loginInteractive(): EnvironmentVariables =
      mode(Mode.LOGIN_INTERACTIVE)

    /**
     * This mode executes a shell process supposed to load various profile scripts:
     * `~/.profile`, `~/.bashrc`, `~/.zshrc`, `/etc/profile` and so on.
     *
     * This mode may load not all environment variables, depending on what's written in user's configs
     * because default `~/.bashrc` files in some distros like Debian and Ubuntu contain strings like `[ -z "$PS1" ] && return`.
     * Often people put their adjustments at the bottom of the profile file, and therefore their code is not executed in the non-interactive mode.
     *
     * **Notice:** In this mode [EelExecApi.EnvironmentVariablesException] MAY be thrown.
     */
    fun loginNonInteractive(): EnvironmentVariables =
      mode(Mode.LOGIN_NON_INTERACTIVE)

    /**
     * The fastest way to get environment variables. It doesn't call shell scripts written by users.
     * At least, the environment variable `PATH` exists, but it may differ from what the user has in their `~/.profile` written.
     * No guarantee for other environment variables.
     *
     * In this mode [EelExecApi.EnvironmentVariablesException] is not thrown.
     */
    fun minimal(): EnvironmentVariables =
      mode(Mode.MINIMAL)

    /**
     * The implementation MAY cache the environment variables by default because they rarely change in real life.
     * By setting this value to `true`, the cache will be refreshed, and the result will contain the freshest environment variables.
     *
     * Makes sense only for remote Eels (via IJent)
     * or with such [EelExecPosixApi.PosixEnvironmentVariablesOptions.mode] that invoke a shell.
     * In other cases this option has no effect.
     */
    fun onlyActual(arg: Boolean): EnvironmentVariables = apply {
      this.onlyActual = arg
    }

    /**
     * Complete the builder and call [com.intellij.platform.eel.EelExecPosixApi.environmentVariables]
     * with an instance of [com.intellij.platform.eel.EelExecPosixApi.PosixEnvironmentVariablesOptions].
     */
    override suspend fun eelIt(): EelExecApi.EnvironmentVariablesDeferred =
      owner.environmentVariables(
        PosixEnvironmentVariablesOptionsImpl(
          mode = mode,
          onlyActual = onlyActual,
        )
      )
  }
}