// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.EelExecPosixApi.PosixEnvironmentVariablesOptions
import com.intellij.platform.eel.EelExecPosixApi.PosixEnvironmentVariablesOptions.Mode
import com.intellij.platform.eel.channels.EelDelicateApi
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Experimental
class PosixEnvironmentVariablesOptionsBuilder {
  private var mode: Mode = Mode.DEFAULT

  private var onlyActual: Boolean = false

  fun mode(arg: Mode): PosixEnvironmentVariablesOptionsBuilder = apply {
    this.mode = arg
  }

  /**
   * * On remote Eel it works like [LOGIN_NON_INTERACTIVE], but in case of an error it returns [MINIMAL] instead of throwing an exception.
   * * On local Windows and Linux it always works like [MINIMAL]
   *   because historically the IDE haven't called the shell for environment variables in most cases.
   * * On local macOS it works like [LOGIN_NON_INTERACTIVE] + [MINIMAL], but it returns values cached at start
   *   with no effect from the [onlyActual] option. This is the historical behaviour too.
   *
   * In this mode [EelExecApi.EnvironmentVariablesException] is not thrown.
   */
  fun default(): PosixEnvironmentVariablesOptionsBuilder =
    mode(Mode.DEFAULT)

  /**
   *  **Use with caution, avoid when possible.**
   *
   * This mode executes a shell process supposed to load various profile scripts:
   * `~/.profile`, `~/.bashrc`, `~/.zshrc`, `/etc/profile` and so on.
   *
   * The implementation launches an interactive shell session, so it reads all environment variables unlike [LOGIN_NON_INTERACTIVE].
   *
   * However, it's not conventional to run interactive shells without having an actual user interaction.
   * And no way for user interaction is provided.
   *
   * Here are some real cases reported by our users. They're not exceptional cases but rather usual things.
   * In these cases this mode led to inability to fetch environment variables or high CPU consumption:
   * * `ssh-add` in `~/.bashrc` waits for a key passphrase, and the shell process hangs forever, IDE becomes unusable.
   * * `~/.bashrc` starts `screen` or `tmux`, the shell process hangs forever.
   * * `~/.bashrc` starts `ssh-agent`, and the operating system quickly becomes polluted with lots of unused SSH agents.
   * * `~/.bashrc` calls `curl` to write the current weather, news, jokes, etc. CPU consumption grows, IDE works slower.
   *
   * **Notice:** In this mode [EelExecApi.EnvironmentVariablesException] MAY be thrown.
   */
  @EelDelicateApi
  fun loginInteractive(): PosixEnvironmentVariablesOptionsBuilder =
    mode(Mode.LOGIN_INTERACTIVE)

  /**
   * This mode executes a shell process supposed to load various profile scripts:
   * `~/.profile`, `~/.bashrc`, `~/.zshrc`, `/etc/profile` and so on.
   *
   * This mode may load not all environment variables, depending on what's written in user's configs
   * because default `~/.bashrc` files in some distros like Debian and Ubuntu contain strings like `[ -z "$PS1" ] && return`.
   * Often people put their adjustments at the bottom of the profile file, and therefore their code is not executed in the non-interactive mode.
   *
   * **Notice:** In this mode [EelExecApi.EnvironmentVariablesException] MAY be thrown.
   */
  fun loginNonInteractive(): PosixEnvironmentVariablesOptionsBuilder =
    mode(Mode.LOGIN_NON_INTERACTIVE)

  /**
   * The fastest way to get environment variables. It doesn't call shell scripts written by users.
   * At least, the environment variable `PATH` exists, but it may differ from what the user has in their `~/.profile` written.
   * No guarantee for other environment variables.
   *
   * In this mode [EelExecApi.EnvironmentVariablesException] is not thrown.
   */
  fun minimal(): PosixEnvironmentVariablesOptionsBuilder =
    mode(Mode.MINIMAL)

  /**
   * The implementation MAY cache the environment variables by default because they rarely change in real life.
   * By setting this value to `true`, the cache will be refreshed, and the result will contain the freshest environment variables.
   *
   * Makes sense only for remote Eels (via IJent)
   * or with such [EelExecPosixApi.PosixEnvironmentVariablesOptions.mode] that invoke a shell.
   * In other cases this option has no effect.
   */
  fun onlyActual(arg: Boolean): PosixEnvironmentVariablesOptionsBuilder = apply {
    this.onlyActual = arg
  }

  fun build(): PosixEnvironmentVariablesOptions =
    PosixEnvironmentVariablesOptionsImpl(
      mode = mode,
      onlyActual = onlyActual,
    )
}

@GeneratedBuilder.Result
internal class PosixEnvironmentVariablesOptionsImpl(
  override val mode: Mode,
  override val onlyActual: Boolean,
) : PosixEnvironmentVariablesOptions