// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.*
import com.intellij.platform.eel.EelTunnelsApi.Connection
import com.intellij.platform.eel.path.EelPath
import kotlinx.coroutines.channels.SendChannel
import org.jetbrains.annotations.ApiStatus
import kotlin.time.Duration
import kotlin.time.Duration.Companion.seconds


/**
 * **For applied usages, please consider [withConnectionToRemotePort]**.
 * 
 * Accepts remote connections to a named host specified by [address].
 * 
 * If an error occurs during creation of the server, an [EelConnectionError] will be thrown.
 * Otherwise, a [ConnectionAcceptor] object is returned, which means that the server was created successfully.
 * 
 * Locally, the server exists as a channel of [Connection]s, which allows imitating a server on the IDE side.
 * 
 * Packets sent to the channels and received from the channel may be split and/or concatenated.
 * The packets may be split only if their size exceeds [com.intellij.platform.ijent.spi.RECOMMENDED_MAX_PACKET_SIZE].
 * 
 * If the connections get closed, then the channels also get closed in the sense of [SendChannel.close].
 * 
 * If an exception happens during sending, then [Connection.sendChannel] gets closed exceptionally with [RemoteNetworkException].
 * 
 * [Connection.sendChannel] can be closed separately with [SendChannel.close]. In this case, the EOF is sent to the server.
 * Note, that [Connection.receiveChannel] is __not__ closed in this case.
 * 
 * One should not forget to invoke [Connection.close] when the connection is not needed.
 */
@GeneratedBuilder.Result
@ApiStatus.Internal
fun EelTunnelsApi.getAcceptorForRemotePort(): EelTunnelsApiHelpers.GetAcceptorForRemotePort =
  EelTunnelsApiHelpers.GetAcceptorForRemotePort(
    owner = this,
  )

/**
 * **For applied usages, consider using [withConnectionToRemotePort]**.
 * 
 * Creates a connection to a TCP socket to a named host specified by [address].
 * 
 * If an error occurs during establishment of the connection, an [EelConnectionError] will be thrown.
 * Otherwise, a [Connection] object is returned, which means that the connection is ready to use.
 * 
 * The connection exists as a pair of channels [Connection.sendChannel] and [Connection.receiveChannel],
 * which allow communicating to a remote server from the IDE side.
 * 
 * Packets sent to the channel and received from the channel may be split and/or concatenated.
 * The packets may be split only if their size exceeds [com.intellij.platform.ijent.spi.RECOMMENDED_MAX_PACKET_SIZE].
 * 
 * If the connection gets closed from the server, then the channels also get closed in the sense of [SendChannel.close].
 * 
 * If an exception happens during sending, then [Connection.receiveChannel] gets closed exceptionally with [RemoteNetworkException].
 * 
 * [Connection.sendChannel] can be closed separately with [SendChannel.close]. In this case, the EOF is sent to the server.
 * Note, that [Connection.receiveChannel] is __not__ closed in this case.
 * 
 * One should not forget to invoke [Connection.close] when the connection is not needed.
 * 
 * To configure a socket before connection use [configureSocketBeforeConnection]. After that, use [Connection.configureSocket]
 */
@GeneratedBuilder.Result
@ApiStatus.Experimental
fun EelTunnelsApi.getConnectionToRemotePort(): EelTunnelsApiHelpers.GetConnectionToRemotePort =
  EelTunnelsApiHelpers.GetConnectionToRemotePort(
    owner = this,
  )

/**
 * See [listenOnUnixSocket] that accepts [EelPath] parameter for full documentation.
 */
@GeneratedBuilder.Result
@ApiStatus.Experimental
fun EelTunnelsApi.listenOnUnixSocket(): EelTunnelsApiHelpers.ListenOnUnixSocket =
  EelTunnelsApiHelpers.ListenOnUnixSocket(
    owner = this,
  )

@ApiStatus.Experimental
object EelTunnelsApiHelpers {
  /**
   * Create it via [com.intellij.platform.eel.EelTunnelsApi.getAcceptorForRemotePort].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Internal
  class GetAcceptorForRemotePort(
    private val owner: EelTunnelsApi,
  ) : OwnedBuilder<EelTunnelsApi.ConnectionAcceptor> {
    private var configureServerSocket: ConfigurableSocket.() -> Unit = {}

    private var hostname: String = "localhost"

    private var port: UShort = 0u

    private var protocolPreference: EelIpPreference = EelIpPreference.USE_SYSTEM_DEFAULT

    private var timeout: Duration = 10.seconds

    fun configureServerSocket(arg: ConfigurableSocket.() -> Unit): GetAcceptorForRemotePort = apply {
      this.configureServerSocket = arg
    }

    @ApiStatus.Experimental
    fun hostname(arg: String): GetAcceptorForRemotePort = apply {
      this.hostname = arg
    }

    @ApiStatus.Experimental
    fun port(arg: UShort): GetAcceptorForRemotePort = apply {
      this.port = arg
    }

    /**
     * @see [Builder.preferIPv4]
     */
    @ApiStatus.Experimental
    fun protocolPreference(arg: EelIpPreference): GetAcceptorForRemotePort = apply {
      this.protocolPreference = arg
    }

    fun preferV4(): GetAcceptorForRemotePort =
      protocolPreference(EelIpPreference.PREFER_V4)

    fun preferV6(): GetAcceptorForRemotePort =
      protocolPreference(EelIpPreference.PREFER_V6)

    fun useSystemDefault(): GetAcceptorForRemotePort =
      protocolPreference(EelIpPreference.USE_SYSTEM_DEFAULT)

    /**
     * @see [Builder.connectionTimeout]
     */
    @ApiStatus.Experimental
    fun timeout(arg: Duration): GetAcceptorForRemotePort = apply {
      this.timeout = arg
    }

    /**
     * Complete the builder and call [com.intellij.platform.eel.EelTunnelsApi.getAcceptorForRemotePort]
     * with an instance of [com.intellij.platform.eel.EelTunnelsApi.GetAcceptorForRemotePort].
     */
    @Throws(EelConnectionError::class)
    @ThrowsChecked(EelConnectionError::class)
    override suspend fun eelIt(): EelTunnelsApi.ConnectionAcceptor =
      owner.getAcceptorForRemotePort(
        GetAcceptorForRemotePortImpl(
          configureServerSocket = configureServerSocket,
          hostname = hostname,
          port = port,
          protocolPreference = protocolPreference,
          timeout = timeout,
        )
      )
  }

  /**
   * Create it via [com.intellij.platform.eel.EelTunnelsApi.getConnectionToRemotePort].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Experimental
  class GetConnectionToRemotePort(
    private val owner: EelTunnelsApi,
  ) : OwnedBuilder<Connection> {
    private var configureSocketBeforeConnection: ConfigurableClientSocket.() -> Unit = {}

    private var hostname: String = "localhost"

    private var port: UShort = 0u

    private var protocolPreference: EelIpPreference = EelIpPreference.USE_SYSTEM_DEFAULT

    private var timeout: Duration = 10.seconds

    @ApiStatus.Internal
    fun configureSocketBeforeConnection(arg: ConfigurableClientSocket.() -> Unit): GetConnectionToRemotePort = apply {
      this.configureSocketBeforeConnection = arg
    }

    @ApiStatus.Experimental
    fun hostname(arg: String): GetConnectionToRemotePort = apply {
      this.hostname = arg
    }

    @ApiStatus.Experimental
    fun port(arg: UShort): GetConnectionToRemotePort = apply {
      this.port = arg
    }

    /**
     * @see [Builder.preferIPv4]
     */
    @ApiStatus.Experimental
    fun protocolPreference(arg: EelIpPreference): GetConnectionToRemotePort = apply {
      this.protocolPreference = arg
    }

    fun preferV4(): GetConnectionToRemotePort =
      protocolPreference(EelIpPreference.PREFER_V4)

    fun preferV6(): GetConnectionToRemotePort =
      protocolPreference(EelIpPreference.PREFER_V6)

    fun useSystemDefault(): GetConnectionToRemotePort =
      protocolPreference(EelIpPreference.USE_SYSTEM_DEFAULT)

    /**
     * @see [Builder.connectionTimeout]
     */
    @ApiStatus.Experimental
    fun timeout(arg: Duration): GetConnectionToRemotePort = apply {
      this.timeout = arg
    }

    /**
     * Complete the builder and call [com.intellij.platform.eel.EelTunnelsApi.getConnectionToRemotePort]
     * with an instance of [com.intellij.platform.eel.EelTunnelsApi.GetConnectionToRemotePortArgs].
     */
    @Throws(EelConnectionError::class)
    @ThrowsChecked(EelConnectionError::class)
    override suspend fun eelIt(): Connection =
      owner.getConnectionToRemotePort(
        GetConnectionToRemotePortArgsImpl(
          configureSocketBeforeConnection = configureSocketBeforeConnection,
          hostname = hostname,
          port = port,
          protocolPreference = protocolPreference,
          timeout = timeout,
        )
      )
  }

  /**
   * Create it via [com.intellij.platform.eel.EelTunnelsApi.listenOnUnixSocket].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Experimental
  class ListenOnUnixSocket(
    private val owner: EelTunnelsApi,
  ) : OwnedBuilder<EelTunnelsApi.ListenOnUnixSocketResult> {
    private var parentDirectory: EelPath? = null

    private var prefix: String = ""

    private var suffix: String = ""

    fun parentDirectory(arg: EelPath?): ListenOnUnixSocket = apply {
      this.parentDirectory = arg
    }

    fun prefix(arg: String): ListenOnUnixSocket = apply {
      this.prefix = arg
    }

    fun suffix(arg: String): ListenOnUnixSocket = apply {
      this.suffix = arg
    }

    /**
     * Complete the builder and call [com.intellij.platform.eel.EelTunnelsApi.listenOnUnixSocket]
     * with an instance of [com.intellij.platform.eel.EelTunnelsApi.ListenOnUnixSocketTemporaryPathOptions].
     */
    override suspend fun eelIt(): EelTunnelsApi.ListenOnUnixSocketResult =
      owner.listenOnUnixSocket(
        ListenOnUnixSocketTemporaryPathOptionsImpl(
          parentDirectory = parentDirectory,
          prefix = prefix,
          suffix = suffix,
        )
      )
  }
}