// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.EelTunnelsApi.GetConnectionToRemotePortArgs
import org.jetbrains.annotations.ApiStatus
import kotlin.time.Duration
import kotlin.time.Duration.Companion.seconds


@GeneratedBuilder.Result
@ApiStatus.Experimental
class GetConnectionToRemotePortArgsBuilder {
  private var configureSocketBeforeConnection: ConfigurableClientSocket.() -> Unit = {}

  private var hostname: String = "localhost"

  private var port: UShort = 0u

  private var protocolPreference: EelIpPreference = EelIpPreference.USE_SYSTEM_DEFAULT

  private var timeout: Duration = 10.seconds

  @ApiStatus.Internal
  fun configureSocketBeforeConnection(arg: ConfigurableClientSocket.() -> Unit): GetConnectionToRemotePortArgsBuilder = apply {
    this.configureSocketBeforeConnection = arg
  }

  @ApiStatus.Experimental
  fun hostname(arg: String): GetConnectionToRemotePortArgsBuilder = apply {
    this.hostname = arg
  }

  @ApiStatus.Experimental
  fun port(arg: UShort): GetConnectionToRemotePortArgsBuilder = apply {
    this.port = arg
  }

  /**
   * @see [Builder.preferIPv4]
   */
  @ApiStatus.Experimental
  fun protocolPreference(arg: EelIpPreference): GetConnectionToRemotePortArgsBuilder = apply {
    this.protocolPreference = arg
  }

  fun preferV4(): GetConnectionToRemotePortArgsBuilder =
    protocolPreference(EelIpPreference.PREFER_V4)

  fun preferV6(): GetConnectionToRemotePortArgsBuilder =
    protocolPreference(EelIpPreference.PREFER_V6)

  fun useSystemDefault(): GetConnectionToRemotePortArgsBuilder =
    protocolPreference(EelIpPreference.USE_SYSTEM_DEFAULT)

  /**
   * @see [Builder.connectionTimeout]
   */
  @ApiStatus.Experimental
  fun timeout(arg: Duration): GetConnectionToRemotePortArgsBuilder = apply {
    this.timeout = arg
  }

  fun build(): GetConnectionToRemotePortArgs =
    GetConnectionToRemotePortArgsImpl(
      configureSocketBeforeConnection = configureSocketBeforeConnection,
      hostname = hostname,
      port = port,
      protocolPreference = protocolPreference,
      timeout = timeout,
    )
}

@GeneratedBuilder.Result
internal class GetConnectionToRemotePortArgsImpl(
  override val configureSocketBeforeConnection: ConfigurableClientSocket.() -> Unit,
  override val hostname: String,
  override val port: UShort,
  override val protocolPreference: EelIpPreference,
  override val timeout: Duration,
) : GetConnectionToRemotePortArgs