// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.execution.dashboard.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.FolderDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.GroupingNode;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

import java.util.List;

import static com.intellij.execution.services.ServiceViewActionUtils.getTargets;
import static com.intellij.platform.execution.dashboard.RunDashboardServiceViewContributorHelper.scheduleRemoveFolderGroup;

/**
 * @author Konstantin Aleev
 */
final class UngroupConfigurationsActions extends AnAction {

  @Override
  public @NotNull ActionUpdateThread getActionUpdateThread() {
    return ActionUpdateThread.BGT;
  }

  @Override
  public void update(@NotNull AnActionEvent e) {
    List<GroupingNode> targets = getTargets(e, GroupingNode.class);
    boolean enabled = e.getProject() != null &&
                      !targets.isEmpty() &&
                      ContainerUtil.all(targets, node -> node.getGroup() instanceof FolderDashboardGroupingRule.FolderDashboardGroup);
    e.getPresentation().setEnabledAndVisible(enabled);
  }

  @Override
  public void actionPerformed(@NotNull AnActionEvent e) {
    Project project = e.getProject();
    if (project == null) return;

    for (GroupingNode node : getTargets(e, GroupingNode.class)) {
      doActionPerformed(project, node);
    }
  }

  private static void doActionPerformed(Project project, GroupingNode node) {
    scheduleRemoveFolderGroup(project, node.getGroup().getName());
  }
}
