/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private static final int CURRENT_VERSION = 5;
    private final File myFile;
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    @Nullable
    private PersistentHashMap<String, Record> myMap;
    private volatile ScheduledFuture<?> myMapFlusher;

    public static File getTestHistoryRoot(@NotNull Project project) {
        if (project == null) {
            TestStateStorage.$$$reportNull$$$0(0);
        }
        return new File(TEST_HISTORY_PATH, project.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project) {
        if (project == null) {
            TestStateStorage.$$$reportNull$$$0(1);
        }
        return (TestStateStorage)project.getService(TestStateStorage.class);
    }

    public TestStateStorage(Project project) {
        String directoryPath = TestStateStorage.getTestHistoryRoot(project).getPath();
        this.myFile = new File(directoryPath + "/testStateMap");
        FileUtilRt.createParentDirs((File)this.myFile);
        try {
            this.myMap = this.initializeMap();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.myMapFlusher = FlushingDaemon.runPeriodically(this::flushMap);
    }

    private PersistentHashMap<String, Record> initializeMap() throws IOException {
        return (PersistentHashMap)IOUtil.openCleanOrResetBroken(TestStateStorage.getComputable(this.myFile), (File)this.myFile);
    }

    private synchronized void flushMap() {
        if (this.myMapFlusher == null) {
            return;
        }
        if (this.myMap != null && this.myMap.isDirty()) {
            this.myMap.force();
        }
    }

    @NotNull
    private static ThrowableComputable<PersistentHashMap<String, Record>, IOException> getComputable(File file) {
        ThrowableComputable throwableComputable = () -> new PersistentHashMap(file.toPath(), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<Record>(){

            public void save(@NotNull DataOutput out, Record value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                out.writeInt(value.magnitude);
                out.writeLong(value.date.getTime());
                out.writeLong(value.configurationHash);
                out.writeInt(value.failedLine);
                out.writeUTF(StringUtil.notNullize((String)value.failedMethod));
                out.writeUTF(StringUtil.notNullize((String)value.errorMessage));
                out.writeUTF(StringUtil.notNullize((String)value.topStacktraceLine));
            }

            public Record read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new Record(in.readInt(), new Date(in.readLong()), in.readLong(), in.readInt(), in.readUTF(), in.readUTF(), in.readUTF());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/TestStateStorage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 4096, 5);
        if (throwableComputable == null) {
            TestStateStorage.$$$reportNull$$$0(2);
        }
        return throwableComputable;
    }

    @NotNull
    public synchronized Collection<String> getKeys() {
        block6: {
            List<String> list;
            try {
                if (this.myMap != null) break block6;
                list = Collections.emptyList();
            }
            catch (IOException e) {
                this.thingsWentWrongLetsReinitialize(e, "Can't get keys");
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    TestStateStorage.$$$reportNull$$$0(5);
                }
                return list2;
            }
            if (list == null) {
                TestStateStorage.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        this.myMap.processKeysWithExistingMapping((Processor)new CommonProcessors.CollectProcessor(result2));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            TestStateStorage.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public synchronized Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get state for " + testUrl);
            return null;
        }
    }

    public synchronized void removeState(String url) {
        if (this.myMap != null) {
            try {
                this.myMap.remove((Object)url);
            }
            catch (IOException e) {
                this.thingsWentWrongLetsReinitialize(e, "Can't remove state for " + url);
            }
        }
    }

    @Nullable
    public synchronized Map<String, Record> getRecentTests(int limit, Date since) {
        if (this.myMap == null) {
            return null;
        }
        HashMap<String, Record> result2 = new HashMap<String, Record>();
        try {
            this.myMap.processKeysWithExistingMapping(key -> {
                Record record;
                try {
                    record = (Record)this.myMap.get(key);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (record != null && record.date.compareTo(since) > 0) {
                    result2.put((String)key, record);
                    if (result2.size() >= limit) {
                        return false;
                    }
                }
                return true;
            });
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get recent tests");
        }
        return result2;
    }

    public synchronized void writeState(@NotNull String testUrl, Record record) {
        if (testUrl == null) {
            TestStateStorage.$$$reportNull$$$0(6);
        }
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't write state for " + testUrl);
        }
    }

    public synchronized void dispose() {
        this.myMapFlusher.cancel(false);
        this.myMapFlusher = null;
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myMap = null;
        }
    }

    private void thingsWentWrongLetsReinitialize(IOException e, String message) {
        try {
            if (this.myMap != null) {
                try {
                    this.myMap.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
            }
            this.myMap = this.initializeMap();
            LOG.warn(message, (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error("Cannot repair", (Throwable)e1);
            this.myMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/TestStateStorage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/TestStateStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComputable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestHistoryRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static final class Record {
        public final int magnitude;
        public final long configurationHash;
        public final Date date;
        public int failedLine;
        public String failedMethod;
        @NlsSafe
        public final String errorMessage;
        public final String topStacktraceLine;

        public Record(int magnitude, Date date, long configurationHash, int failLine, String method, String errorMessage, String topStacktraceLine) {
            this.magnitude = magnitude;
            this.date = date;
            this.configurationHash = configurationHash;
            this.failedLine = failLine;
            this.failedMethod = method;
            this.errorMessage = errorMessage;
            this.topStacktraceLine = topStacktraceLine;
        }
    }
}

