/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExecutorGroupActionGroup
extends ActionGroup
implements DumbAware {
    protected final ExecutorGroup<?> myExecutorGroup;
    private final Function<? super Executor, ? extends AnAction> myChildConverter;

    public ExecutorGroupActionGroup(@NotNull ExecutorGroup<?> executorGroup, @NotNull Function<? super Executor, ? extends AnAction> childConverter) {
        if (executorGroup == null) {
            ExecutorGroupActionGroup.$$$reportNull$$$0(0);
        }
        if (childConverter == null) {
            ExecutorGroupActionGroup.$$$reportNull$$$0(1);
        }
        this.myExecutorGroup = executorGroup;
        this.myChildConverter = childConverter;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(executorGroup.getStartActionText());
        presentation.setIconSupplier(() -> executorGroup.getIcon());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExecutorGroupActionGroup.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.getChildren();
        if (anActionArray == null) {
            ExecutorGroupActionGroup.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public AnAction @NotNull [] getChildren() {
        List childExecutors = this.myExecutorGroup.childExecutors();
        AnAction[] result2 = new AnAction[childExecutors.size()];
        for (int i = 0; i < childExecutors.size(); ++i) {
            result2[i] = this.myChildConverter.apply((Executor)childExecutors.get(i));
        }
        if (result2 == null) {
            ExecutorGroupActionGroup.$$$reportNull$$$0(4);
        }
        return result2;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorGroupActionGroup.$$$reportNull$$$0(5);
        }
        if ((project = e.getProject()) == null || !project.isInitialized() || project.isDisposed()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (!this.myExecutorGroup.isApplicable(project)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ExecutorGroupActionGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ExecutorGroupActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

