/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.VirtualConfigurationType;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0012\u0010\r\u001a\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0010H\u0014J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/impl/RunConfigurationTemplatesConfigurable;", "Lcom/intellij/execution/impl/RunConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "configurationType", "Lcom/intellij/execution/configurations/ConfigurationType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationType;)V", "postInit", "", "disposable", "Lcom/intellij/openapi/Disposable;", "postInit$intellij_platform_execution_impl", "selectTypeNode", "expandTemplatesNode", "templatesNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "addRunConfigurationsToModel", "model", "apply", "isModified", "", "createComponent", "Ljavax/swing/JComponent;", "createLeftPanel", "getDisplayName", "", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationTemplatesConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationTemplatesConfigurable.kt\ncom/intellij/execution/impl/RunConfigurationTemplatesConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n774#2:104\n865#2,2:105\n*S KotlinDebug\n*F\n+ 1 RunConfigurationTemplatesConfigurable.kt\ncom/intellij/execution/impl/RunConfigurationTemplatesConfigurable\n*L\n62#1:104\n62#1:105,2\n*E\n"})
public final class RunConfigurationTemplatesConfigurable
extends RunConfigurable {
    @Nullable
    private final ConfigurationType configurationType;

    public RunConfigurationTemplatesConfigurable(@NotNull Project project, @Nullable ConfigurationType configurationType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.configurationType = configurationType;
    }

    public final void postInit$intellij_platform_execution_impl(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.initTreeSelectionListener(disposable);
        this.selectTypeNode(this.configurationType);
    }

    private final void selectTypeNode(ConfigurationType configurationType) {
        block1: {
            ConfigurationType configurationType2 = configurationType;
            if (configurationType2 == null) break block1;
            ConfigurationType it = configurationType2;
            boolean bl = false;
            TreeNode treeNode = TreeUtil.findNodeWithObject((Object)it, (TreeModel)this.getTree().getModel(), (Object)this.getRoot());
            if (treeNode == null) {
                return;
            }
            TreeNode node = treeNode;
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            this.expandTemplatesNode((DefaultMutableTreeNode)node);
        }
    }

    private final void expandTemplatesNode(DefaultMutableTreeNode templatesNode) {
        TreePath treePath = TreeUtil.getPath((TreeNode)this.getRoot(), (TreeNode)templatesNode);
        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"getPath(...)");
        TreePath path = treePath;
        this.getTree().expandPath(path);
        TreeUtil.selectInTree((DefaultMutableTreeNode)templatesNode, (boolean)true, (JTree)((JTree)this.getTree()));
        this.getTree().scrollPathToVisible(path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addRunConfigurationsToModel(@NotNull DefaultMutableTreeNode model) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Iterable $this$filter$iv = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfigurationType it = (ConfigurationType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof VirtualConfigurationType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ConfigurationType type : (List)destination$iv$iv) {
            ConfigurationFactory[] configurationFactories = type.getConfigurationFactories();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            this.getRoot().add(typeNode);
            if (configurationFactories.length == 1) continue;
            Intrinsics.checkNotNull((Object)configurationFactories);
            for (ConfigurationFactory factory : configurationFactories) {
                typeNode.add(new DefaultMutableTreeNode(factory));
            }
        }
    }

    @Override
    public void apply() {
        this.applyTemplates();
    }

    @Override
    public boolean isModified() {
        return this.isConfigurableModified();
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JComponent component = super.createComponent();
        JLabel label2 = new JLabel(ExecutionBundle.message((String)"templates.disclaimer", (Object[])new Object[0]));
        label2.setBorder(JBUI.Borders.empty((int)10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)label2, "West");
        panel2.setBorder(IdeBorderFactory.createBorder((int)8));
        panel2.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(HintUtil.PROMOTION_PANE_KEY));
        JComponent jComponent = component;
        Intrinsics.checkNotNull((Object)jComponent);
        jComponent.add((Component)panel2, "North");
        return component;
    }

    @Override
    @NotNull
    protected JComponent createLeftPanel() {
        JComponent leftPanel = super.createLeftPanel();
        leftPanel.setMinimumSize(new Dimension(250, 100));
        return leftPanel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = ExecutionBundle.message((String)"configurable.name.run.debug.configuration.templates", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

