/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.runToolbar.DraggablePane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\n*\u0001\u0012\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/runToolbar/DraggablePane;", "Ljavax/swing/JPanel;", "<init>", "()V", "listener", "Lcom/intellij/execution/runToolbar/DraggablePane$DragListener;", "startPoint", "Ljava/awt/Point;", "myUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "awtDragListener", "Ljava/awt/event/AWTEventListener;", "setListener", "", "getOffset", "Ljava/awt/Dimension;", "locationOnScreen", "startDragListener", "com/intellij/execution/runToolbar/DraggablePane$startDragListener$1", "Lcom/intellij/execution/runToolbar/DraggablePane$startDragListener$1;", "setCursor", "resetCursor", "addNotify", "removeNotify", "removeAWTListener", "removeListeners", "DragListener", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public class DraggablePane
extends JPanel {
    @Nullable
    private DragListener listener;
    @Nullable
    private Point startPoint;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("draggingQueue", 50, true, MergingUpdateQueue.ANY_COMPONENT, null, null, false, 112, null);
    @NotNull
    private final AWTEventListener awtDragListener = arg_0 -> DraggablePane.awtDragListener$lambda$0(this, arg_0);
    @NotNull
    private final startDragListener.1 startDragListener = new MouseAdapter(this){
        final /* synthetic */ DraggablePane this$0;
        {
            this.this$0 = $receiver;
        }

        public void mouseEntered(MouseEvent e) {
            DraggablePane.access$setCursor(this.this$0);
        }

        public void mouseExited(MouseEvent e) {
            Point point = DraggablePane.access$getStartPoint$p(this.this$0);
            if (point == null) {
                startDragListener.1 var2_2 = this;
                DraggablePane draggablePane = this.this$0;
                startDragListener.1 $this$mouseExited_u24lambda_u240 = var2_2;
                boolean bl = false;
                DraggablePane.access$resetCursor(draggablePane);
                point = Unit.INSTANCE;
            }
        }

        public void mousePressed(MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DraggablePane.access$setStartPoint$p(this.this$0, e.getLocationOnScreen());
            DragListener dragListener = DraggablePane.access$getListener$p(this.this$0);
            if (dragListener != null) {
                Point point = e.getLocationOnScreen();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
                dragListener.dragStarted(point);
            }
            DraggablePane.access$setCursor(this.this$0);
            Toolkit.getDefaultToolkit().addAWTEventListener(DraggablePane.access$getAwtDragListener$p(this.this$0), 48L);
        }
    };

    public DraggablePane() {
        this.setOpaque(false);
        this.setPreferredSize((Dimension)new JBDimension(7, 21));
        this.setMinimumSize((Dimension)new JBDimension(7, 21));
    }

    public final void setListener(@NotNull DragListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listener = listener2;
    }

    private final Dimension getOffset(Point locationOnScreen) {
        Dimension dimension;
        Point point = this.startPoint;
        if (point != null) {
            Point it = point;
            boolean bl = false;
            int offsetX = locationOnScreen.x - it.x;
            int offsetY = locationOnScreen.y - it.y;
            dimension = new Dimension(offsetX, offsetY);
        } else {
            dimension = null;
        }
        return dimension;
    }

    private final void setCursor() {
        block0: {
            JComponent jComponent = UIUtil.getRootPane((Component)this);
            if (jComponent == null || (jComponent = ((JRootPane)jComponent).getLayeredPane()) == null) break block0;
            jComponent.setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    private final void resetCursor() {
        block0: {
            JComponent jComponent = UIUtil.getRootPane((Component)this);
            if (jComponent == null || (jComponent = ((JRootPane)jComponent).getLayeredPane()) == null) break block0;
            jComponent.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this.startDragListener);
    }

    @Override
    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private final void removeAWTListener() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtDragListener);
        this.resetCursor();
        this.startPoint = null;
    }

    private final void removeListeners() {
        this.removeMouseListener(this.startDragListener);
        this.removeAWTListener();
    }

    private static final void awtDragListener$lambda$0(DraggablePane this$0, AWTEvent it) {
        switch (it.getID()) {
            case 502: {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
                MouseEvent cfr_ignored_0 = (MouseEvent)it;
                Point point = ((MouseEvent)it).getLocationOnScreen();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
                Dimension dimension = this$0.getOffset(point);
                if (dimension != null) {
                    Dimension offset = dimension;
                    boolean bl = false;
                    DragListener dragListener = this$0.listener;
                    if (dragListener != null) {
                        Point point2 = ((MouseEvent)it).getLocationOnScreen();
                        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocationOnScreen(...)");
                        dragListener.dragStopped(point2, offset);
                    }
                }
                this$0.removeAWTListener();
                break;
            }
            case 506: {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
                MouseEvent cfr_ignored_1 = (MouseEvent)it;
                Point point = ((MouseEvent)it).getLocationOnScreen();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
                Dimension dimension = this$0.getOffset(point);
                if (dimension != null) {
                    Dimension offset = dimension;
                    boolean bl = false;
                    this$0.myUpdateQueue.queue(new Update(this$0, it, offset){
                        final /* synthetic */ DraggablePane this$0;
                        final /* synthetic */ AWTEvent $it;
                        final /* synthetic */ Dimension $offset;
                        {
                            this.this$0 = $receiver;
                            this.$it = $it;
                            this.$offset = $offset;
                            super((Object)"draggingUpdate", false, 1);
                        }

                        public void run() {
                            block0: {
                                DragListener dragListener = DraggablePane.access$getListener$p(this.this$0);
                                if (dragListener == null) break block0;
                                Point point = ((MouseEvent)this.$it).getLocationOnScreen();
                                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
                                dragListener.dragged(point, this.$offset);
                            }
                        }
                    });
                }
                break;
            }
        }
    }

    public static final /* synthetic */ DragListener access$getListener$p(DraggablePane $this) {
        return $this.listener;
    }

    public static final /* synthetic */ void access$setCursor(DraggablePane $this) {
        $this.setCursor();
    }

    public static final /* synthetic */ Point access$getStartPoint$p(DraggablePane $this) {
        return $this.startPoint;
    }

    public static final /* synthetic */ void access$setStartPoint$p(DraggablePane $this, Point point) {
        $this.startPoint = point;
    }

    public static final /* synthetic */ AWTEventListener access$getAwtDragListener$p(DraggablePane $this) {
        return $this.awtDragListener;
    }

    public static final /* synthetic */ void access$resetCursor(DraggablePane $this) {
        $this.resetCursor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/runToolbar/DraggablePane$DragListener;", "", "dragStarted", "", "locationOnScreen", "Ljava/awt/Point;", "dragged", "offset", "Ljava/awt/Dimension;", "dragStopped", "intellij.platform.execution.impl"})
    public static interface DragListener {
        public void dragStarted(@NotNull Point var1);

        public void dragged(@NotNull Point var1, @NotNull Dimension var2);

        public void dragStopped(@NotNull Point var1, @NotNull Dimension var2);
    }
}

