/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.runToolbar.RTRunConfiguration;
import com.intellij.execution.runToolbar.RunToolbarData;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarMainSlotState;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarProcessStartedAction;
import com.intellij.execution.runToolbar.RunToolbarRunConfigurationsAction;
import com.intellij.execution.runToolbar.RunWidgetWidthHelper;
import com.intellij.execution.runToolbar.components.MouseListenerHelper;
import com.intellij.execution.runToolbar.components.TrimmedMiddleLabel;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.segmentedActionBar.SegmentedCustomPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarProcessStartedAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "Lcom/intellij/execution/runToolbar/RTRunConfiguration;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkMainSlotVisibility", "", "state", "Lcom/intellij/execution/runToolbar/RunToolbarMainSlotState;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "Companion", "intellij.platform.execution.impl"})
public final class RunToolbarProcessStartedAction
extends ComboBoxAction
implements RTRunConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<ExecutionEnvironment> PROP_ACTIVE_ENVIRONMENT = new Key("PROP_ACTIVE_ENVIRONMENT");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public boolean checkMainSlotVisibility(@NotNull RunToolbarMainSlotState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return state == RunToolbarMainSlotState.PROCESS;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Companion.updatePresentation(e);
        if (!RunToolbarProcess.Companion.isExperimentalUpdatingEnabled()) {
            RunToolbarMainSlotState runToolbarMainSlotState = RunToolbarDataKt.mainState(e);
            if (runToolbarMainSlotState != null) {
                RunToolbarMainSlotState it = runToolbarMainSlotState;
                boolean bl = false;
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
                Presentation presentation2 = presentation;
                presentation2.setEnabledAndVisible(presentation2.isEnabledAndVisible() && this.checkMainSlotVisibility(it));
            }
        }
        e.getPresentation().setEnabled(e.getPresentation().isEnabled() && e.isFromActionToolbar());
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return (JComponent)new SegmentedCustomPanel(presentation){
            private final Key<ExecutionEnvironment> PROP_ACTIVE_ENVIRONMENT;
            private final createCustomComponent.setting.1 setting;
            private final createCustomComponent.process.1 process;
            final /* synthetic */ Presentation $presentation;
            {
                void $this$process_u24lambda_u240;
                JLabel jLabel;
                this.$presentation = $presentation;
                super($presentation);
                this.PROP_ACTIVE_ENVIRONMENT = new Key("PROP_ACTIVE_ENVIRONMENT");
                this.setting = new TrimmedMiddleLabel(){

                    public Font getFont() {
                        Font font = UIUtil.getToolbarFont();
                        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getToolbarFont(...)");
                        return font;
                    }
                };
                JLabel jLabel2 = jLabel = new JLabel(){

                    public Font getFont() {
                        Font font = UIUtil.getToolbarFont();
                        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getToolbarFont(...)");
                        return font;
                    }
                };
                var var5_4 = this;
                boolean bl = false;
                $this$process_u24lambda_u240.setForeground(UIUtil.getLabelInfoForeground());
                var5_4.process = jLabel;
                MouseListenerHelper.Companion.addListener((JComponent)((Object)this), (Function0<Unit>)((Function0)() -> createCustomComponent.1._init_$lambda$1(this)), (Function0<Unit>)((Function0)() -> createCustomComponent.1._init_$lambda$2(this)), (Function0<Unit>)((Function0)() -> createCustomComponent.1._init_$lambda$3(this)));
                this.fill();
            }

            public final Key<ExecutionEnvironment> getPROP_ACTIVE_ENVIRONMENT() {
                return this.PROP_ACTIVE_ENVIRONMENT;
            }

            protected void presentationChanged(PropertyChangeEvent event) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.setting.setIcon(this.$presentation.getIcon());
                    this.setting.setText(this.$presentation.getText());
                    ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.$presentation.getClientProperty(RunToolbarProcessStartedAction.Companion.getPROP_ACTIVE_ENVIRONMENT());
                    if (executionEnvironment == null) break block2;
                    ExecutionEnvironment environment = executionEnvironment;
                    boolean bl = false;
                    RunToolbarProcess runToolbarProcess = RunToolbarDataKt.getRunToolbarProcess(environment);
                    if (runToolbarProcess != null) {
                        RunToolbarProcess it = runToolbarProcess;
                        boolean bl2 = false;
                        this.updatePresentation(it);
                        if (RunToolbarDataKt.isProcessTerminating(environment)) {
                            this.process.setText(ActionsBundle.message((String)"action.RunToolbarRemoveSlotAction.terminating", (Object[])new Object[0]));
                        }
                    }
                }
            }

            private final void updatePresentation(RunToolbarProcess toolbarProcess) {
                this.setting.setText(this.$presentation.getText());
                this.setting.setIcon(this.$presentation.getIcon());
                this.setEnabled(true);
                this.setToolTipText(this.$presentation.getDescription());
                this.process.setText(toolbarProcess.getName());
                this.setBackground((Color)toolbarProcess.getPillColor());
            }

            private final void fill() {
                this.setLayout((LayoutManager)new MigLayout("ins 0 0 0 3, novisualpadding, gap 0, fill", "4[shp 1]3[grow]push"));
                this.add(this.setting, "ay center, pushx, wmin 10");
                this.add(this.process, "ay center, pushx, wmin 0");
                this.setting.setBorder((Border)JBUI.Borders.empty());
                this.process.setBorder((Border)JBUI.Borders.empty());
            }

            private final void showPopup() {
                block0: {
                    ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.$presentation.getClientProperty(this.PROP_ACTIVE_ENVIRONMENT);
                    if (executionEnvironment == null) break block0;
                    RunToolbarDataKt.showToolWindowTab(executionEnvironment);
                }
            }

            private final void doRightClick() {
                DataContext dataContext = ActionToolbar.getDataContextFor((Component)((Component)((Object)this)));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContextFor(...)");
                RunToolbarRunConfigurationsAction.Companion.doRightClick(dataContext);
            }

            private final void doShiftClick() {
                DataContext dataContext = ActionToolbar.getDataContextFor((Component)((Component)((Object)this)));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContextFor(...)");
                RunToolbarDataKt.editConfiguration(dataContext);
            }

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                Project project = this.getProject();
                if (project != null) {
                    Project it = project;
                    boolean bl = false;
                    d.width = RunWidgetWidthHelper.Companion.getInstance(it).getRunConfig();
                }
                Intrinsics.checkNotNull((Object)d);
                return d;
            }

            private static final Unit _init_$lambda$1(createCustomComponent.1 this$0) {
                this$0.showPopup();
                return Unit.INSTANCE;
            }

            private static final Unit _init_$lambda$2(createCustomComponent.1 this$0) {
                this$0.doShiftClick();
                return Unit.INSTANCE;
            }

            private static final Unit _init_$lambda$3(createCustomComponent.1 this$0) {
                this$0.doRightClick();
                return Unit.INSTANCE;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarProcessStartedAction$Companion;", "", "<init>", "()V", "PROP_ACTIVE_ENVIRONMENT", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getPROP_ACTIVE_ENVIRONMENT", "()Lcom/intellij/openapi/util/Key;", "updatePresentation", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ExecutionEnvironment> getPROP_ACTIVE_ENVIRONMENT() {
            return PROP_ACTIVE_ENVIRONMENT;
        }

        public final void updatePresentation(@NotNull AnActionEvent e) {
            boolean bl;
            Presentation presentation;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            Presentation presentation3 = presentation = presentation2;
            Project project = e.getProject();
            if (project != null) {
                boolean bl2;
                Project project2 = project;
                Presentation presentation4 = presentation3;
                boolean bl3 = false;
                RunToolbarData runToolbarData = RunToolbarDataKt.runToolbarData(e);
                if (runToolbarData != null) {
                    RunToolbarData it = runToolbarData;
                    boolean bl4 = false;
                    ExecutionEnvironment executionEnvironment = it.getEnvironment();
                    if (executionEnvironment != null) {
                        ExecutionEnvironment environment = executionEnvironment;
                        boolean bl5 = false;
                        presentation.putClientProperty(Companion.getPROP_ACTIVE_ENVIRONMENT(), (Object)environment);
                        RunContentDescriptor runContentDescriptor2 = environment.getContentToReuse();
                        if (runContentDescriptor2 != null) {
                            RunContentDescriptor contentDescriptor = runContentDescriptor2;
                            boolean bl6 = false;
                            presentation.setText(contentDescriptor.getDisplayName(), false);
                            presentation.setIcon(contentDescriptor.getIcon());
                        } else {
                            Companion $this$updatePresentation_u24lambda_u240_u240_u240_u241 = Companion;
                            boolean bl7 = false;
                            presentation.setText("");
                            presentation.setIcon(null);
                        }
                        String string = presentation.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        String string2 = ActionsBundle.message((String)"action.RunToolbarShowHidePopupAction.click.to.open.toolwindow.text", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        presentation.setDescription(RunToolbarData.Companion.prepareDescription$intellij_platform_execution_impl(string, string2));
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
                boolean bl8 = bl2;
                presentation3 = presentation4;
                bl = bl8;
            } else {
                bl = false;
            }
            presentation3.setEnabledAndVisible(bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

