/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentLanguagesPanel;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00040123BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\f0\nj\u0002`\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010%\u001a\u00020\u0010J\u0006\u0010&\u001a\u00020\u0010J\u0006\u0010'\u001a\u00020\u0010J\b\u0010(\u001a\u00020\u0010H\u0002J\b\u0010)\u001a\u00020\u001bH\u0002J\b\u0010*\u001a\u00020\u0010H\u0002J\b\u0010+\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u000bH\u0002J\b\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\f0\nj\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010 \u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$\u00a8\u00064"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "targetEnvironmentType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "targetSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "languagesList", "Lcom/intellij/execution/target/ContributedConfigurationsList;", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "Lcom/intellij/execution/target/LanguageRuntimeType;", "Lcom/intellij/execution/target/LanguagesList;", "parentRefresh", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/target/TargetEnvironmentType;Ljava/util/function/Supplier;Lcom/intellij/execution/target/ContributedConfigurationsList;Lkotlin/jvm/functions/Function0;)V", "getLanguagesList", "()Lcom/intellij/execution/target/ContributedConfigurationsList;", "languagePanels", "", "Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$LanguagePanel;", "mainPanel", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "component$delegate", "Lkotlin/Lazy;", "preferredFocusedComponent", "getPreferredFocusedComponent", "isModified", "", "()Z", "applyAll", "reset", "disposeUIResources", "clearLanguagePanels", "createComponent", "recreateRuntimePanels", "isModelListChanged", "createRuntimePanel", "language", "createAddRuntimeHyperlink", "Ljavax/swing/JButton;", "ChangeRuntimeActionBase", "DuplicateRuntimeAction", "RemoveRuntimeAction", "LanguagePanel", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nTargetEnvironmentLanguagesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetEnvironmentLanguagesPanel.kt\ncom/intellij/execution/target/TargetEnvironmentLanguagesPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1761#2,3:170\n1869#2,2:173\n1869#2,2:175\n1869#2,2:177\n1869#2,2:179\n1563#2:181\n1634#2,3:182\n1563#2:185\n1634#2,3:186\n*S KotlinDebug\n*F\n+ 1 TargetEnvironmentLanguagesPanel.kt\ncom/intellij/execution/target/TargetEnvironmentLanguagesPanel\n*L\n43#1:170,3\n45#1:173,2\n52#1:175,2\n60#1:177,2\n78#1:179,2\n86#1:181\n86#1:182,3\n126#1:185\n126#1:186,3\n*E\n"})
public final class TargetEnvironmentLanguagesPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TargetEnvironmentType<?> targetEnvironmentType;
    @NotNull
    private final Supplier<TargetEnvironmentConfiguration> targetSupplier;
    @NotNull
    private final ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<? extends LanguageRuntimeConfiguration>> languagesList;
    @NotNull
    private final Function0<Unit> parentRefresh;
    @NotNull
    private final List<LanguagePanel> languagePanels;
    private JPanel mainPanel;
    @NotNull
    private final Lazy component$delegate;

    public TargetEnvironmentLanguagesPanel(@NotNull Project project, @NotNull TargetEnvironmentType<?> targetEnvironmentType, @NotNull Supplier<TargetEnvironmentConfiguration> targetSupplier, @NotNull ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<? extends LanguageRuntimeConfiguration>> languagesList, @NotNull Function0<Unit> parentRefresh) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetEnvironmentType, (String)"targetEnvironmentType");
        Intrinsics.checkNotNullParameter(targetSupplier, (String)"targetSupplier");
        Intrinsics.checkNotNullParameter(languagesList, (String)"languagesList");
        Intrinsics.checkNotNullParameter(parentRefresh, (String)"parentRefresh");
        this.project = project;
        this.targetEnvironmentType = targetEnvironmentType;
        this.targetSupplier = targetSupplier;
        this.languagesList = languagesList;
        this.parentRefresh = parentRefresh;
        this.languagePanels = new ArrayList();
        this.component$delegate = LazyKt.lazy(() -> TargetEnvironmentLanguagesPanel.component_delegate$lambda$0(this));
    }

    @NotNull
    public final ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<? extends LanguageRuntimeConfiguration>> getLanguagesList() {
        return this.languagesList;
    }

    @NotNull
    public final JComponent getComponent() {
        Lazy lazy = this.component$delegate;
        return (JComponent)lazy.getValue();
    }

    @Nullable
    public final JComponent getPreferredFocusedComponent() {
        LanguagePanel languagePanel = (LanguagePanel)CollectionsKt.firstOrNull(this.languagePanels);
        return languagePanel != null && (languagePanel = languagePanel.getConfigurable()) != null ? languagePanel.getPreferredFocusedComponent() : null;
    }

    public final boolean isModified() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.languagePanels;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LanguagePanel it = (LanguagePanel)element$iv;
                    boolean bl2 = false;
                    if (!it.getConfigurable().isModified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void applyAll() {
        Iterable $this$forEach$iv = this.languagePanels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguagePanel it = (LanguagePanel)element$iv;
            boolean bl = false;
            it.getConfigurable().apply();
        }
    }

    public final void reset() {
        if (this.isModelListChanged()) {
            this.recreateRuntimePanels();
            this.parentRefresh.invoke();
        }
        Iterable $this$forEach$iv = this.languagePanels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguagePanel it = (LanguagePanel)element$iv;
            boolean bl = false;
            it.getConfigurable().reset();
        }
    }

    public final void disposeUIResources() {
        this.clearLanguagePanels();
    }

    private final void clearLanguagePanels() {
        Iterable $this$forEach$iv = this.languagePanels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguagePanel it = (LanguagePanel)element$iv;
            boolean bl = false;
            it.getConfigurable().disposeUIResources();
        }
        this.languagePanels.clear();
    }

    private final JComponent createComponent() {
        BorderLayoutPanel result2 = new BorderLayoutPanel();
        this.mainPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        this.recreateRuntimePanels();
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        result2.addToCenter((Component)jPanel);
        result2.addToBottom((Component)this.createAddRuntimeHyperlink());
        return (JComponent)result2;
    }

    private final void recreateRuntimePanels() {
        this.clearLanguagePanels();
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        JPanel $this$recreateRuntimePanels_u24lambda_u240 = jPanel;
        boolean bl = false;
        $this$recreateRuntimePanels_u24lambda_u240.removeAll();
        Iterable $this$forEach$iv = this.languagesList.resolvedConfigs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageRuntimeConfiguration it = (LanguageRuntimeConfiguration)element$iv;
            boolean bl2 = false;
            $this$recreateRuntimePanels_u24lambda_u240.add(this.createRuntimePanel(it).getPanel());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isModelListChanged() {
        void $this$mapTo$iv$iv;
        ArrayList modelValues = new ArrayList(this.languagesList.resolvedConfigs());
        Iterable $this$map$iv = this.languagePanels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LanguagePanel languagePanel = (LanguagePanel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLanguage());
        }
        Collection collection = (List)destination$iv$iv;
        ArrayList panelValues = new ArrayList(collection);
        return !Intrinsics.areEqual(modelValues, panelValues);
    }

    private final LanguagePanel createRuntimePanel(LanguageRuntimeConfiguration language) {
        LanguagePanel languagePanel;
        Configurable configurable = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)language).createConfigurable(this.project, language, this.targetEnvironmentType, this.targetSupplier);
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> TargetEnvironmentLanguagesPanel.createRuntimePanel$lambda$0(language, this, configurable, arg_0));
        configurable.reset();
        LanguagePanel it = languagePanel = new LanguagePanel(language, configurable, (JComponent)panel2);
        boolean bl = false;
        this.languagePanels.add(it);
        return languagePanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JButton createAddRuntimeHyperlink() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = LanguageRuntimeType.EXTENSION_NAME.getExtensionList();
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"com/intellij/execution/target/TargetEnvironmentLanguagesPanel$createAddRuntimeHyperlink$Item", "", "type", "Lcom/intellij/execution/target/LanguageRuntimeType;", "<init>", "(Lcom/intellij/execution/target/LanguageRuntimeType;)V", "getType", "()Lcom/intellij/execution/target/LanguageRuntimeType;", "toString", "", "intellij.platform.execution.impl"})
        public final class Item {
            private final LanguageRuntimeType<?> type;

            public Item(LanguageRuntimeType<?> type) {
                this.type = type;
            }

            public final LanguageRuntimeType<?> getType() {
                return this.type;
            }

            public String toString() {
                Object object = this.type;
                if (object == null || (object = object.getDisplayName()) == null) {
                    String string = ExecutionBundle.message((String)"targets.details.hyperlink.add.language.runtime", (Object[])new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                }
                return object;
            }
        }
        Item item = new Item(null);
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LanguageRuntimeType languageRuntimeType = (LanguageRuntimeType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Item((LanguageRuntimeType<?>)it));
        }
        Consumer<Item> consumer = arg_0 -> TargetEnvironmentLanguagesPanel.createAddRuntimeHyperlink$lambda$1(this, arg_0);
        List list = (List)destination$iv$iv;
        Item item2 = item;
        return (JButton)new DropDownLink((Object)item2, list, consumer);
    }

    private static final JComponent component_delegate$lambda$0(TargetEnvironmentLanguagesPanel this$0) {
        return this$0.createComponent();
    }

    private static final Unit createRuntimePanel$lambda$0(LanguageRuntimeConfiguration $language, TargetEnvironmentLanguagesPanel this$0, Configurable $configurable, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TargetEnvironmentLanguagesPanel.createRuntimePanel$lambda$0$0($language, this$0, arg_0), (int)1, null);
        $this$panel.indent(arg_0 -> TargetEnvironmentLanguagesPanel.createRuntimePanel$lambda$0$1($configurable, $language, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createRuntimePanel$lambda$0$0(LanguageRuntimeConfiguration $language, TargetEnvironmentLanguagesPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TitledSeparator separator = new TitledSeparator(LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)$language).getConfigurableDescription());
        separator.setTitleFont(separator.getTitleFont().deriveFont(1));
        $this$row.cell((JComponent)separator).gap(RightGap.SMALL).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
        AnAction[] anActionArray = new AnAction[]{this$0.new DuplicateRuntimeAction($language), this$0.new RemoveRuntimeAction($language)};
        ExtensionsKt.actionsButton$default((Row)$this$row, (AnAction[])anActionArray, null, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createRuntimePanel$lambda$0$1(Configurable $configurable, LanguageRuntimeConfiguration $language, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> TargetEnvironmentLanguagesPanel.createRuntimePanel$lambda$0$1$0($configurable, $language, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createRuntimePanel$lambda$0$1$0(Configurable $configurable, LanguageRuntimeConfiguration $language, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = $configurable.createComponent();
        if (jComponent == null) {
            throw new IllegalStateException("for runtime: " + $language);
        }
        JComponent languageUI = jComponent;
        $this$row.cell(languageUI).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void createAddRuntimeHyperlink$lambda$1(TargetEnvironmentLanguagesPanel this$0, createAddRuntimeHyperlink.Item it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LanguageRuntimeConfiguration languageRuntimeConfiguration = it.getType();
        if (languageRuntimeConfiguration == null || (languageRuntimeConfiguration = (LanguageRuntimeConfiguration)languageRuntimeConfiguration.createDefaultConfig()) == null) {
            return;
        }
        LanguageRuntimeConfiguration newLanguage = languageRuntimeConfiguration;
        this$0.languagesList.addConfig((ContributedConfigurationBase)newLanguage);
        JPanel jPanel = this$0.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        jPanel.add(this$0.createRuntimePanel(newLanguage).getPanel());
        this$0.parentRefresh.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$ChangeRuntimeActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "language", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "text", "", "<init>", "(Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;Lcom/intellij/execution/target/LanguageRuntimeConfiguration;Ljava/lang/String;)V", "getLanguage", "()Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "intellij.platform.execution.impl"})
    private abstract class ChangeRuntimeActionBase
    extends AnAction {
        @NotNull
        private final LanguageRuntimeConfiguration language;

        public ChangeRuntimeActionBase(@NlsActions.ActionText @NotNull LanguageRuntimeConfiguration language, String text) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
            this.language = language;
        }

        @NotNull
        protected final LanguageRuntimeConfiguration getLanguage() {
            return this.language;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$DuplicateRuntimeAction;", "Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$ChangeRuntimeActionBase;", "Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;", "runtime", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "<init>", "(Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;Lcom/intellij/execution/target/LanguageRuntimeConfiguration;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.execution.impl"})
    private final class DuplicateRuntimeAction
    extends ChangeRuntimeActionBase {
        public DuplicateRuntimeAction(LanguageRuntimeConfiguration runtime) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            String string = ExecutionBundle.message((String)"targets.details.action.duplicate.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(runtime, string);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            LanguageRuntimeConfiguration copy = (LanguageRuntimeConfiguration)LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)this.getLanguage()).duplicateConfig((ContributedConfigurationBase)this.getLanguage());
            TargetEnvironmentLanguagesPanel.this.getLanguagesList().addConfig((ContributedConfigurationBase)copy);
            JPanel jPanel = TargetEnvironmentLanguagesPanel.this.mainPanel;
            if (jPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
                jPanel = null;
            }
            jPanel.add(TargetEnvironmentLanguagesPanel.this.createRuntimePanel(copy).getPanel());
            TargetEnvironmentLanguagesPanel.this.parentRefresh.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$LanguagePanel;", "", "language", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "panel", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/execution/target/LanguageRuntimeConfiguration;Lcom/intellij/openapi/options/Configurable;Ljavax/swing/JComponent;)V", "getLanguage", "()Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "getConfigurable", "()Lcom/intellij/openapi/options/Configurable;", "getPanel", "()Ljavax/swing/JComponent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.execution.impl"})
    private static final class LanguagePanel {
        @NotNull
        private final LanguageRuntimeConfiguration language;
        @NotNull
        private final Configurable configurable;
        @NotNull
        private final JComponent panel;

        public LanguagePanel(@NotNull LanguageRuntimeConfiguration language, @NotNull Configurable configurable, @NotNull JComponent panel2) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            this.language = language;
            this.configurable = configurable;
            this.panel = panel2;
        }

        @NotNull
        public final LanguageRuntimeConfiguration getLanguage() {
            return this.language;
        }

        @NotNull
        public final Configurable getConfigurable() {
            return this.configurable;
        }

        @NotNull
        public final JComponent getPanel() {
            return this.panel;
        }

        @NotNull
        public final LanguageRuntimeConfiguration component1() {
            return this.language;
        }

        @NotNull
        public final Configurable component2() {
            return this.configurable;
        }

        @NotNull
        public final JComponent component3() {
            return this.panel;
        }

        @NotNull
        public final LanguagePanel copy(@NotNull LanguageRuntimeConfiguration language, @NotNull Configurable configurable, @NotNull JComponent panel2) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return new LanguagePanel(language, configurable, panel2);
        }

        public static /* synthetic */ LanguagePanel copy$default(LanguagePanel languagePanel, LanguageRuntimeConfiguration languageRuntimeConfiguration, Configurable configurable, JComponent jComponent, int n, Object object) {
            if ((n & 1) != 0) {
                languageRuntimeConfiguration = languagePanel.language;
            }
            if ((n & 2) != 0) {
                configurable = languagePanel.configurable;
            }
            if ((n & 4) != 0) {
                jComponent = languagePanel.panel;
            }
            return languagePanel.copy(languageRuntimeConfiguration, configurable, jComponent);
        }

        @NotNull
        public String toString() {
            return "LanguagePanel(language=" + this.language + ", configurable=" + this.configurable + ", panel=" + this.panel + ")";
        }

        public int hashCode() {
            int result2 = this.language.hashCode();
            result2 = result2 * 31 + this.configurable.hashCode();
            result2 = result2 * 31 + this.panel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LanguagePanel)) {
                return false;
            }
            LanguagePanel languagePanel = (LanguagePanel)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)languagePanel.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configurable, (Object)languagePanel.configurable)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.panel, (Object)languagePanel.panel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$RemoveRuntimeAction;", "Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel$ChangeRuntimeActionBase;", "Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;", "runtime", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "<init>", "(Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;Lcom/intellij/execution/target/LanguageRuntimeConfiguration;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nTargetEnvironmentLanguagesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetEnvironmentLanguagesPanel.kt\ncom/intellij/execution/target/TargetEnvironmentLanguagesPanel$RemoveRuntimeAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n295#2,2:170\n2746#2,3:172\n*S KotlinDebug\n*F\n+ 1 TargetEnvironmentLanguagesPanel.kt\ncom/intellij/execution/target/TargetEnvironmentLanguagesPanel$RemoveRuntimeAction\n*L\n151#1:170,2\n159#1:172,3\n*E\n"})
    private final class RemoveRuntimeAction
    extends ChangeRuntimeActionBase {
        public RemoveRuntimeAction(LanguageRuntimeConfiguration runtime) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            String string = ExecutionBundle.message((String)"targets.details.action.remove.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(runtime, string);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TargetEnvironmentLanguagesPanel.this.getLanguagesList().removeConfig((ContributedConfigurationBase)this.getLanguage());
                Iterable $this$firstOrNull$iv = TargetEnvironmentLanguagesPanel.this.languagePanels;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LanguagePanel it = (LanguagePanel)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getLanguage(), (Object)this.getLanguage())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            LanguagePanel languagePanel = v0;
            if (languagePanel != null) {
                LanguagePanel languagePanel2 = languagePanel;
                TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = TargetEnvironmentLanguagesPanel.this;
                LanguagePanel removedOne = languagePanel2;
                boolean bl = false;
                JPanel jPanel = targetEnvironmentLanguagesPanel.mainPanel;
                if (jPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
                    jPanel = null;
                }
                jPanel.remove(removedOne.getPanel());
                removedOne.getConfigurable().disposeUIResources();
            }
            TargetEnvironmentLanguagesPanel.this.parentRefresh.invoke();
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable $this$none$iv = TargetEnvironmentLanguagesPanel.this.getLanguagesList().resolvedConfigs();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        LanguageRuntimeConfiguration it = (LanguageRuntimeConfiguration)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)this.getLanguage()))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            boolean lastLanguage = bl;
            e.getPresentation().setEnabled(!lastLanguage);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }
}

