/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.UnknownBeforeRunTaskProvider;
import com.intellij.execution.ui.TagButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WrapLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class BeforeRunComponent
extends JPanel
implements DnDTarget,
Disposable {
    @NotNull
    private final List<TaskButton> myTags;
    private final InplaceButton myAddButton;
    private final JPanel myAddPanel;
    private final ActionLink myAddLabel;
    private final JLabel myDropFirst;
    Runnable myChangeListener;
    private RunConfiguration myConfiguration;

    public BeforeRunComponent(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            BeforeRunComponent.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new WrapLayout(3, 0, JBUI.scale((int)6)));
        this.myTags = new ArrayList<TaskButton>();
        this.myDropFirst = new JLabel(AllIcons.General.DropPlace);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.add(Box.createVerticalStrut(30));
        JPanel panel2 = new JPanel(new FlowLayout(1, 0, 0));
        this.myDropFirst.setBorder((Border)JBUI.Borders.empty());
        panel2.add(this.myDropFirst);
        panel2.setPreferredSize(this.myDropFirst.getPreferredSize());
        this.add(panel2);
        this.myDropFirst.setVisible(false);
        JBEmptyBorder border = JBUI.Borders.emptyRight((int)5);
        this.myAddButton = new InplaceButton(ExecutionBundle.message((String)"run.configuration.before.run.add.task", (Object[])new Object[0]), AllIcons.General.Add, e -> this.showPopup());
        this.myAddPanel = new JPanel();
        this.myAddPanel.setBorder((Border)border);
        this.myAddPanel.add((Component)this.myAddButton);
        this.myAddLabel = new ActionLink(ExecutionBundle.message((String)"run.configuration.before.run.add.task", (Object[])new Object[0]), e -> this.showPopup());
        this.myAddLabel.setBorder((Border)border);
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)this, (Disposable)this);
    }

    private @Unmodifiable List<BeforeRunTaskProvider<BeforeRunTask<?>>> getProviders() {
        Set existing = ContainerUtil.map2Set(this.myTags, button -> button.myTask.getProviderId());
        return ContainerUtil.filter((Collection)BeforeRunTaskProvider.EP_NAME.getExtensions((AreaInstance)this.myConfiguration.getProject()), provider -> provider.createTask(this.myConfiguration) != null && (!provider.isSingleton() || !existing.contains(provider.getId())));
    }

    private TaskButton createTag(BeforeRunTaskProvider<BeforeRunTask<?>> provider) {
        return new TaskButton(provider, e -> {
            this.myChangeListener.run();
            this.buildPanel();
        });
    }

    private void updateAddLabel() {
        this.myAddLabel.setVisible(this.getEnabledTasks().isEmpty());
    }

    public void showPopup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (BeforeRunTaskProvider<BeforeRunTask<?>> provider : this.getProviders()) {
            group2.add((AnAction)new TagAction(provider));
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"add.new.before.run.task.name", (Object[])new Object[0]), (ActionGroup)group2, DataManager.getInstance().getDataContext((Component)this.myAddButton), false, false, false, null, -1, Conditions.alwaysTrue());
        popup.showUnderneathOf((Component)this.myAddButton);
    }

    public void addOrRemove(Key<? extends BeforeRunTask<?>> providerId, boolean add) {
        TaskButton taskButton = (TaskButton)((Object)ContainerUtil.find(this.myTags, button -> button.myProvider.getId() == providerId));
        if (add) {
            if (taskButton == null) {
                this.createTask(null, (BeforeRunTaskProvider)ContainerUtil.find(this.getProviders(), provider -> providerId == provider.getId()));
            }
        } else if (taskButton != null) {
            this.myTags.remove((Object)taskButton);
        }
    }

    private void createTask(@Nullable AnActionEvent e, BeforeRunTaskProvider<BeforeRunTask<?>> myProvider) {
        BeforeRunTask task2 = myProvider.createTask(this.myConfiguration);
        if (task2 == null) {
            return;
        }
        TaskButton tag = this.createTag(myProvider);
        if (e == null) {
            this.addTask(tag, task2);
            return;
        }
        myProvider.configureTask(e.getDataContext(), this.myConfiguration, task2).onSuccess(changed -> {
            if (!myProvider.canExecuteTask(this.myConfiguration, task2)) {
                return;
            }
            this.addTask(tag, task2);
        });
    }

    private void addTask(TaskButton tag, BeforeRunTask<?> task2) {
        task2.setEnabled(true);
        tag.setTask(task2);
        this.myTags.remove((Object)tag);
        this.myTags.add(tag);
        this.buildPanel();
        this.myChangeListener.run();
    }

    public void reset(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            BeforeRunComponent.$$$reportNull$$$0(1);
        }
        this.myConfiguration = s.getConfiguration();
        for (TaskButton tag : this.myTags) {
            this.remove((Component)((Object)tag));
        }
        this.myTags.clear();
        List<BeforeRunTask<?>> tasks = s.getManager().getBeforeRunTasks(s.getConfiguration());
        for (BeforeRunTask<?> task2 : tasks) {
            BeforeRunTaskProvider taskProvider = (BeforeRunTaskProvider)ContainerUtil.find(this.getProviders(), provider -> task2.getProviderId() == provider.getId());
            if (taskProvider == null) {
                taskProvider = new UnknownBeforeRunTaskProvider(task2.getProviderId().toString());
            }
            TaskButton tag = this.createTag(taskProvider);
            tag.setTask(task2);
            this.myTags.add(tag);
        }
        this.buildPanel();
    }

    private void buildPanel() {
        this.remove(this.myAddPanel);
        this.remove((Component)this.myAddLabel);
        int i = 1;
        for (TaskButton tag : this.myTags) {
            if (tag.isVisible() && tag.myTask != null) {
                tag.myOrder = i++;
                tag.updateButton();
            }
            this.add((Component)((Object)tag));
        }
        this.add(this.myAddPanel);
        this.add((Component)this.myAddLabel);
        this.updateAddLabel();
    }

    public void apply(RunnerAndConfigurationSettingsImpl s) {
        s.getManager().setBeforeRunTasks(s.getConfiguration(), (List<? extends BeforeRunTask<?>>)this.getEnabledTasks());
    }

    @NotNull
    public List<BeforeRunTask<?>> getEnabledTasks() {
        List<BeforeRunTask<?>> list = this.myTags.stream().filter(button -> button.myTask != null && button.isVisible()).map(button -> button.myTask).collect(Collectors.toList());
        if (list == null) {
            BeforeRunComponent.$$$reportNull$$$0(2);
        }
        return list;
    }

    public <T extends BeforeRunTask<?>> boolean hasEnabledTask(Key<T> providerId) {
        return ContainerUtil.or(this.getEnabledTasks(), task2 -> task2.getProviderId() == providerId);
    }

    public void drop(DnDEvent event) {
        TagButton replaceButton = this.getReplaceButton(event);
        if (replaceButton == null) {
            return;
        }
        TaskButton button = (TaskButton)((Object)event.getAttachedObject());
        int i = this.myTags.indexOf(replaceButton);
        this.myTags.remove((Object)button);
        this.myTags.add(i, button);
        this.buildPanel();
        this.myChangeListener.run();
        IdeFocusManager.getInstance((Project)this.myConfiguration.getProject()).requestFocus((Component)((Object)button), false);
    }

    public void cleanUpOnLeave() {
        if (this.myTags != null) {
            this.myTags.forEach(button -> button.showDropPlace(false));
        }
        this.myDropFirst.setVisible(false);
    }

    private TagButton getReplaceButton(DnDEvent event) {
        Object object = event.getAttachedObject();
        if (!(object instanceof TaskButton)) {
            return null;
        }
        Rectangle area = new Rectangle(event.getPoint().x - 5, event.getPoint().y - 5, 10, 10);
        TaskButton button = (TaskButton)((Object)ContainerUtil.find(this.myTags, tag -> tag.isVisible() && tag.getBounds().intersects(area)));
        if (button == null || button == object) {
            return null;
        }
        boolean left = button.getBounds().getCenterX() > (double)event.getPoint().x;
        int i = this.myTags.indexOf((Object)button);
        if (i < this.myTags.indexOf(object)) {
            if (!left) {
                button = (TaskButton)((Object)ContainerUtil.find(this.myTags, b -> b.isVisible() && this.myTags.indexOf(b) > i));
            }
        } else if (left) {
            button = (TaskButton)((Object)ContainerUtil.findLast(this.myTags, b -> b.isVisible() && this.myTags.indexOf(b) < i));
        }
        return button == object ? null : button;
    }

    private TagButton getDropButton(TagButton replaceButton, DnDEvent event) {
        int i = this.myTags.indexOf(replaceButton);
        if (i > this.myTags.indexOf(event.getAttachedObject())) {
            return replaceButton;
        }
        return (TagButton)ContainerUtil.findLast(this.myTags, button -> button.isVisible() && this.myTags.indexOf(button) < i);
    }

    public boolean update(DnDEvent event) {
        TagButton replace = this.getReplaceButton(event);
        if (replace != null) {
            TagButton dropButton = this.getDropButton(replace, event);
            this.myTags.forEach(button -> button.showDropPlace(button == dropButton));
            this.myDropFirst.setVisible(dropButton == null);
            event.setDropPossible(true);
            return false;
        }
        this.myTags.forEach(button -> button.showDropPlace(false));
        event.setDropPossible(false);
        return true;
    }

    public void dispose() {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JPanel.AccessibleJPanel(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibilityUtils.GROUPED_ELEMENTS;
                }
            };
            this.accessibleContext.setAccessibleName(IdeBundle.message((String)"before.run.component.accessible.name", (Object[])new Object[0]));
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/BeforeRunComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/BeforeRunComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private final class TaskButton
    extends TagButton
    implements DnDSource {
        private final BeforeRunTaskProvider<BeforeRunTask<?>> myProvider;
        private final JLabel myDropPlace;
        private BeforeRunTask<?> myTask;
        private int myOrder;

        private TaskButton(BeforeRunTaskProvider<BeforeRunTask<?>> provider, Consumer<? super AnActionEvent> action) {
            if (provider == null) {
                TaskButton.$$$reportNull$$$0(0);
            }
            super(provider.getName(), action);
            this.myDropPlace = new JLabel(AllIcons.General.DropPlace);
            Disposer.register((Disposable)BeforeRunComponent.this, (Disposable)this);
            this.add(this.myDropPlace, JLayeredPane.DRAG_LAYER);
            this.myProvider = provider;
            this.myDropPlace.setVisible(false);
            this.myButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        BeforeRunTask clone = TaskButton.this.myTask.clone();
                        if (DumbService.getInstance((Project)BeforeRunComponent.this.myConfiguration.getProject()).isUsableInCurrentContext(TaskButton.this.myProvider)) {
                            TaskButton.this.myProvider.configureTask(DataManager.getInstance().getDataContext((Component)((Object)TaskButton.this)), BeforeRunComponent.this.myConfiguration, clone).onSuccess(aBoolean -> {
                                TaskButton.this.setTask(clone);
                                TaskButton.this.updateButton();
                            });
                        }
                    }
                }
            });
            DnDManager.getInstance().registerSource((DnDSource)this, (JComponent)this.myButton, (Disposable)this);
            this.myButton.setToolTipText(ExecutionBundle.message((String)"run.configuration.before.run.tooltip", (Object[])new Object[0]));
            this.myButton.getAccessibleContext().setAccessibleDescription(ExecutionBundle.message((String)"run.configuration.before.run.tag.button.accessible.description", (Object[])new Object[0]));
            this.layoutButtons();
        }

        protected void layoutButtons() {
            super.layoutButtons();
            if (this.myDropPlace == null) {
                return;
            }
            Rectangle bounds = this.myButton.getBounds();
            Dimension size = this.myDropPlace.getPreferredSize();
            int gap = JBUI.scale((int)2);
            this.setPreferredSize(new Dimension(bounds.width + size.width + 2 * gap, bounds.height));
            this.myDropPlace.setBounds((int)(bounds.getMaxX() + (double)gap), bounds.y + (bounds.height - size.height) / 2, size.width, size.height);
        }

        private void setTask(@Nullable BeforeRunTask<?> task2) {
            this.myTask = task2;
            this.setVisible(task2 != null);
        }

        private void updateButton() {
            if (this.myTask == null) {
                return;
            }
            this.setEnabled(DumbService.getInstance((Project)BeforeRunComponent.this.myConfiguration.getProject()).isUsableInCurrentContext(this.myProvider));
            this.updateButton(this.myOrder + ". " + this.myProvider.getDescription(this.myTask), this.myProvider.getTaskIcon(this.myTask));
        }

        private void showDropPlace(boolean show2) {
            this.myDropPlace.setVisible(show2);
        }

        public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                TaskButton.$$$reportNull$$$0(1);
            }
            return true;
        }

        public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                TaskButton.$$$reportNull$$$0(2);
            }
            return new DnDDragStartBean((Object)this);
        }

        public String toString() {
            return this.myProvider.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/BeforeRunComponent$TaskButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class TagAction
    extends AnAction
    implements PossiblyDumbAware {
        private final BeforeRunTaskProvider<BeforeRunTask<?>> myProvider;

        private TagAction(BeforeRunTaskProvider<BeforeRunTask<?>> provider) {
            super(provider.getName(), null, provider.getIcon());
            this.myProvider = provider;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TagAction.$$$reportNull$$$0(0);
            }
            BeforeRunComponent.this.createTask(e, this.myProvider);
        }

        public boolean isDumbAware() {
            return DumbService.isDumbAware(this.myProvider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/BeforeRunComponent$TagAction", "actionPerformed"));
        }
    }
}

