/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.EditorMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProgramParametersPanel
extends JPanel
implements PanelWithAnchor {
    protected LabeledComponent<RawCommandLineEditor> myProgramParametersComponent;
    protected LabeledComponent<JComponent> myWorkingDirectoryComponent;
    protected TextFieldWithBrowseButton myWorkingDirectoryField;
    protected EnvironmentVariablesComponent myEnvVariablesComponent;
    protected JComponent myAnchor;
    private Module myModuleContext = null;
    private boolean myHasModuleMacro;
    protected final Map<String, String> myMacrosMap = new HashMap<String, String>();

    public CommonProgramParametersPanel() {
        this(true);
    }

    public CommonProgramParametersPanel(boolean init2) {
        this.setLayout((LayoutManager)new VerticalFlowLayout(1, 0, 5, true, false));
        if (init2) {
            this.init();
        }
    }

    protected void init() {
        this.initComponents();
        this.updateUI();
        this.setupAnchor();
    }

    protected void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myProgramParametersComponent, this.myWorkingDirectoryComponent, this.myEnvVariablesComponent});
    }

    @Nullable
    protected Project getProject() {
        return this.myModuleContext != null ? this.myModuleContext.getProject() : null;
    }

    protected void initComponents() {
        this.myProgramParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]));
        this.myWorkingDirectoryField = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]));
        this.myWorkingDirectoryField.addBrowseFolderListener(this.getProject(), descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myWorkingDirectoryComponent = LabeledComponent.create((JComponent)this.myWorkingDirectoryField, (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]));
        this.myEnvVariablesComponent = this.createEnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setLabelLocation("West");
        this.myProgramParametersComponent.setLabelLocation("West");
        this.myWorkingDirectoryComponent.setLabelLocation("West");
        this.addComponents();
        if (this.isMacroSupportEnabled()) {
            this.initMacroSupport();
        }
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    @NotNull
    protected EnvironmentVariablesComponent createEnvironmentVariablesComponent() {
        return new EnvironmentVariablesComponent();
    }

    @Deprecated(forRemoval=true)
    protected JComponent createComponentWithMacroBrowse(final @NotNull TextFieldWithBrowseButton textAccessor2) {
        if (textAccessor2 == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(0);
        }
        final FixedSizeButton button = new FixedSizeButton((JComponent)textAccessor2);
        button.setIcon(AllIcons.Actions.ListFiles);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List macros = ContainerUtil.map(CommonProgramParametersPanel.this.myMacrosMap.keySet(), s -> s.startsWith("%") ? s : "$" + s + "$");
                JBPopupFactory.getInstance().createPopupChooserBuilder(macros).setItemChosenCallback(value -> textAccessor2.setText(value)).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)button);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)textAccessor2, "Center");
        panel2.add((Component)button, "East");
        return panel2;
    }

    protected void addComponents() {
        this.add((Component)this.myProgramParametersComponent);
        this.add((Component)this.myWorkingDirectoryComponent);
        this.add((Component)((Object)this.myEnvVariablesComponent));
    }

    protected boolean isMacroSupportEnabled() {
        return false;
    }

    protected void initMacroSupport() {
        this.updatePathMacros();
        this.addMacroSupport((ExtendableTextField)((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).getEditorField(), MacrosDialog.Filters.ALL);
        this.addMacroSupport((ExtendableTextField)this.myWorkingDirectoryField.getTextField(), MacrosDialog.Filters.DIRECTORY_PATH);
    }

    public static void addMacroSupport(@NotNull ExtendableTextField textField) {
        if (textField == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(1);
        }
        CommonProgramParametersPanel.doAddMacroSupport(textField, MacrosDialog.Filters.ALL, null);
    }

    protected void addMacroSupport(@NotNull ExtendableTextField textField, @NotNull Predicate<? super Macro> macroFilter) {
        if (textField == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(2);
        }
        if (macroFilter == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(3);
        }
        Predicate<? super Macro> commonMacroFilter = this.getCommonMacroFilter();
        CommonProgramParametersPanel.doAddMacroSupport(textField, t -> commonMacroFilter.test((Macro)t) && macroFilter.test((Macro)t), this.myMacrosMap);
    }

    @NotNull
    protected Predicate<? super Macro> getCommonMacroFilter() {
        Predicate<? super Macro> predicate = MacrosDialog.Filters.ALL;
        if (predicate == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(4);
        }
        return predicate;
    }

    private static void doAddMacroSupport(@NotNull ExtendableTextField textField, @NotNull Predicate<? super Macro> macroFilter, @Nullable Map<String, String> userMacros) {
        if (textField == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(5);
        }
        if (macroFilter == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(6);
        }
        if (Registry.is((String)"allow.macros.for.run.configurations")) {
            MacrosDialog.addTextFieldExtension(textField, macroFilter.and(macro -> !(macro instanceof EditorMacro)), userMacros);
        }
    }

    protected void copyDialogCaption(LabeledComponent<RawCommandLineEditor> component) {
        RawCommandLineEditor rawCommandLineEditor = (RawCommandLineEditor)component.getComponent();
        rawCommandLineEditor.setDialogCaption(component.getRawText());
        component.getLabel().setLabelFor((Component)rawCommandLineEditor.getTextField());
    }

    public void setProgramParametersLabel(@Nls String textWithMnemonic) {
        this.myProgramParametersComponent.setText(textWithMnemonic);
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    public void setProgramParameters(String params) {
        ((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).setText(params);
    }

    public TextAccessor getWorkingDirectoryAccessor() {
        return this.myWorkingDirectoryField;
    }

    public void setWorkingDirectory(String dir) {
        this.myWorkingDirectoryField.setText(dir);
    }

    public void setModuleContext(Module moduleContext) {
        this.myModuleContext = moduleContext;
        this.updatePathMacros();
    }

    public void setHasModuleMacro() {
        this.myHasModuleMacro = true;
        this.updatePathMacros();
    }

    protected void updatePathMacros() {
        this.myMacrosMap.clear();
        this.myMacrosMap.putAll(MacrosDialog.getPathMacros(this.myModuleContext != null || this.myHasModuleMacro));
    }

    public LabeledComponent<RawCommandLineEditor> getProgramParametersComponent() {
        return this.myProgramParametersComponent;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myProgramParametersComponent.setAnchor(anchor);
        this.myWorkingDirectoryComponent.setAnchor(anchor);
        this.myEnvVariablesComponent.setAnchor(anchor);
    }

    public void applyTo(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(7);
        }
        configuration.setProgramParameters(this.fromTextField((TextAccessor)this.myProgramParametersComponent.getComponent(), configuration));
        configuration.setWorkingDirectory(this.fromTextField((TextAccessor)this.myWorkingDirectoryField, configuration));
        this.myEnvVariablesComponent.apply(configuration);
    }

    @Nullable
    protected String fromTextField(@NotNull TextAccessor textAccessor2, @NotNull CommonProgramRunConfigurationParameters configuration) {
        if (textAccessor2 == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(9);
        }
        return textAccessor2.getText();
    }

    public void reset(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(10);
        }
        this.setProgramParameters(configuration.getProgramParameters());
        this.setWorkingDirectory(PathUtil.toSystemDependentName((String)configuration.getWorkingDirectory()));
        this.myEnvVariablesComponent.reset(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAccessor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/CommonProgramParametersPanel";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/CommonProgramParametersPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonMacroFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createComponentWithMacroBrowse";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMacroSupport";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doAddMacroSupport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromTextField";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

