/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.PermissionsKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.EditRunConfigAndRunCurrentFileExecutorAction;
import com.intellij.execution.actions.RunCurrentFileExecutorAction;
import com.intellij.execution.actions.RunSpecifiedConfigExecutorAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runToolbar.RunToolbarSlotManager;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.platform.ide.core.permissions.RequiresPermissions;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    private static final String BUTTON_MODE = "ButtonMode";
    private static final String RUN_CONFIGURATION_GROUP_ID = "RunConfiguration.Group";
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;

    public static boolean hasRunCurrentFileItem(@NotNull Project project) {
        if (project == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(0);
        }
        if (RunToolbarSlotManager.Companion.getInstance(project).getActive$intellij_platform_execution_impl()) {
            return false;
        }
        if (PlatformUtils.isIntelliJ()) {
            return true;
        }
        if (PlatformUtils.isPhpStorm()) {
            return true;
        }
        if (PlatformUtils.isWebStorm()) {
            return true;
        }
        if (PlatformUtils.isRubyMine()) {
            return true;
        }
        if (PlatformUtils.isPyCharmPro()) {
            return true;
        }
        if (PlatformUtils.isPyCharmCommunity()) {
            return true;
        }
        if (PlatformUtils.isDataGrip()) {
            return true;
        }
        return Registry.is((String)"run.current.file.item.in.run.configurations.combobox");
    }

    private static boolean hasRunSubActions(@NotNull Project project) {
        if (project == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(1);
        }
        return RunConfigurationsComboBoxAction.hasRunCurrentFileItem(project) || ExperimentalUI.isNewUI() || PlatformUtils.isCLion();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(3);
        }
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            presentation.setDescription(ExecutionBundle.messagePointer((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
        }
        try {
            if (project == null || project.isDisposed() || !project.isOpen() || RunManager.IS_RUN_MANAGER_INITIALIZED.get((UserDataHolder)project) != Boolean.TRUE) {
                RunConfigurationsComboBoxAction.updatePresentation(null, null, null, presentation, e.getPlace());
                presentation.setEnabled(false);
            } else {
                RunConfigurationsComboBoxAction.updatePresentation(this.getSelectedExecutionTarget(e), this.getSelectedConfiguration(e), project, presentation, e.getPlace());
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    @Nullable
    protected ExecutionTarget getSelectedExecutionTarget(AnActionEvent e) {
        Project project = e.getProject();
        return project == null ? null : ExecutionTargetManager.getActiveTarget((Project)project);
    }

    @Nullable
    protected RunnerAndConfigurationSettings getSelectedConfiguration(AnActionEvent e) {
        Project project = e.getProject();
        return project == null ? null : RunManager.getInstance((Project)project).getSelectedConfiguration();
    }

    protected static void updatePresentation(@Nullable ExecutionTarget target, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project, @NotNull Presentation presentation, String actionPlace) {
        if (presentation == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(4);
        }
        presentation.putClientProperty(BUTTON_MODE, null);
        if (project != null && target != null && settings != null) {
            Object name;
            if (!ExperimentalUI.isNewUI()) {
                name = Executor.shortenNameIfNeeded((String)settings.getName());
                if (target != DefaultExecutionTarget.INSTANCE && !target.isExternallyManaged()) {
                    name = (String)name + " | " + target.getDisplayName();
                } else if (!ExecutionTargetManager.canRun((RunConfiguration)settings.getConfiguration(), (ExecutionTarget)target)) {
                    name = (String)name + " | " + ExecutionBundle.message((String)"run.configurations.combo.action.nothing.to.run.on", (Object[])new Object[0]);
                }
            } else {
                name = StringUtil.shortenTextWithEllipsis((String)settings.getName(), (int)41, (int)8, (boolean)true);
            }
            presentation.setText((String)name, false);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project, true);
            }
        } else {
            if (project != null && RunConfigurationsComboBoxAction.hasRunCurrentFileItem(project)) {
                presentation.setText(ExecutionBundle.messagePointer((String)"run.configurations.combo.run.current.file.selected", (Object[])new Object[0]));
                presentation.setIcon(null);
                return;
            }
            presentation.putClientProperty(BUTTON_MODE, (Object)Boolean.TRUE);
            presentation.setText(ExecutionBundle.messagePointer((String)"action.presentation.RunConfigurationsComboBoxAction.text", (Object[])new Object[0]));
            presentation.setDescription(ActionsBundle.actionDescription((String)"editRunConfigurations"));
            if ("TouchBarGeneral".equals(actionPlace)) {
                presentation.setIcon(AllIcons.General.Add);
            } else {
                presentation.setIcon(null);
            }
        }
    }

    protected static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project) {
        RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project, true);
    }

    private static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project, boolean withLiveIndicator) {
        try {
            presentation.setIcon(RunManagerEx.getInstanceEx(project).getConfigurationIcon(settings, withLiveIndicator));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Presentation presentation;
        if (e == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(5);
        }
        if ("TouchBarGeneral".equals(e.getPlace()) && Boolean.TRUE.equals((presentation = e.getPresentation()).getClientProperty(BUTTON_MODE))) {
            Component component;
            InputEvent inputEvent = e.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component != null) {
                RunConfigurationsComboBoxAction.performWhenButton(component, "TouchBarGeneral");
            }
            return;
        }
        super.actionPerformed(e);
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(6);
        }
        if (place == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(7);
        }
        RunConfigurationsComboBoxButton button = new RunConfigurationsComboBoxButton(presentation);
        if (this.isNoWrapping(place)) {
            RunConfigurationsComboBoxButton runConfigurationsComboBoxButton = button;
            if (runConfigurationsComboBoxButton == null) {
                RunConfigurationsComboBoxAction.$$$reportNull$$$0(8);
            }
            return runConfigurationsComboBoxButton;
        }
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JBEmptyBorder border = UIUtil.isUnderDefaultMacTheme() ? JBUI.Borders.empty((int)0, (int)2) : JBUI.Borders.empty((int)0, (int)5, (int)0, (int)4);
        panel2.setBorder((Border)border);
        panel2.add((Component)((Object)button));
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(9);
        }
        return nonOpaquePanel;
    }

    private static void performWhenButton(@NotNull Component src, String place) {
        if (src == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(10);
        }
        ActionManager manager = ActionManager.getInstance();
        manager.tryToExecute(manager.getAction("editRunConfigurations"), (InputEvent)new MouseEvent(src, 501, System.currentTimeMillis(), 0, 0, 0, 0, false, 0), src, place, true);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
        if (button == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(11);
        }
        if (context == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(12);
        }
        DefaultActionGroup result2 = new DefaultActionGroup();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
        if (project == null) {
            DefaultActionGroup defaultActionGroup = result2;
            if (defaultActionGroup == null) {
                RunConfigurationsComboBoxAction.$$$reportNull$$$0(13);
            }
            return defaultActionGroup;
        }
        AnAction editRunConfigurationAction = this.getEditRunConfigurationAction();
        if (editRunConfigurationAction != null) {
            result2.add(editRunConfigurationAction);
        }
        result2.add((AnAction)new SaveTemporaryAction());
        result2.addSeparator();
        if (!ExperimentalUI.isNewUI()) {
            this.addTargetGroup(project, result2);
        }
        result2.add((AnAction)new RunCurrentFileAction());
        result2.addSeparator(ExecutionBundle.message((String)"run.configurations.popup.existing.configurations.separator.text", (Object[])new Object[0]));
        Map<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>> configurationMap = RunManagerImpl.getInstanceImpl(project).getConfigurationsGroupedByTypeAndFolder(true);
        result2.add(this.createRunConfigurationFolderActions(project, configurationMap.values()));
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(14);
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction createRunConfigurationFolderActions(final @NotNull Project project, final @NotNull Collection<Map<String, List<RunnerAndConfigurationSettings>>> folderMaps) {
        if (project == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(15);
        }
        if (folderMaps == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(16);
        }
        return new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                ArrayList<1> result2 = new ArrayList<1>();
                for (final Map folderMap : folderMaps) {
                    result2.add(new ActionGroup(){

                        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                            ArrayList<1> result2 = new ArrayList<1>();
                            for (final Map.Entry folderEntry : folderMap.entrySet()) {
                                final @NlsSafe String folderName = (String)folderEntry.getKey();
                                if (folderName == null) {
                                    result2.addAll(ContainerUtil.map((Collection)((Collection)folderEntry.getValue()), o -> RunConfigurationsComboBoxAction.this.createFinalAction(project, (RunnerAndConfigurationSettings)o)));
                                    continue;
                                }
                                result2.add(new ActionGroup(){
                                    {
                                        this.getTemplatePresentation().setPopupGroup(true);
                                        this.getTemplatePresentation().setText(folderName);
                                        this.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                                    }

                                    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                                        AnAction[] anActionArray = ContainerUtil.map((Collection)((Collection)folderEntry.getValue()), o -> RunConfigurationsComboBoxAction.this.createFinalAction(project, (RunnerAndConfigurationSettings)o)).toArray(AnAction.EMPTY_ARRAY);
                                        if (anActionArray == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        return anActionArray;
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$1$1$1", "getChildren"));
                                    }
                                });
                            }
                            AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
                            if (anActionArray == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return anActionArray;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$1$1", "getChildren"));
                        }
                    });
                    result2.add(Separator.getInstance());
                }
                AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$1", "getChildren"));
            }
        };
    }

    protected void addTargetGroup(Project project, DefaultActionGroup allActionsGroup) {
        RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selected != null) {
            ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
            for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)selected.getConfiguration())) {
                allActionsGroup.add((AnAction)new SelectTargetAction(project, eachTarget, eachTarget.equals((Object)activeTarget)));
            }
            allActionsGroup.addSeparator();
        }
    }

    @Nullable
    protected AnAction getEditRunConfigurationAction() {
        return ActionManager.getInstance().getAction("editRunConfigurations");
    }

    @NotNull
    protected AnAction createFinalAction(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration) {
        if (project == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(17);
        }
        if (configuration == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(18);
        }
        return new SelectConfigAction(project, configuration);
    }

    protected JBPopup createActionPopup(DefaultActionGroup group2, @NotNull DataContext context, @Nullable Runnable disposeCallback) {
        PopupFactoryImpl.ActionGroupPopup actionGroupPopup;
        PopupStep step2;
        JBPopup popup;
        if (context == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(19);
        }
        if ((popup = super.createActionPopup(group2, context, disposeCallback)) instanceof PopupFactoryImpl.ActionGroupPopup && (step2 = (actionGroupPopup = (PopupFactoryImpl.ActionGroupPopup)popup).getStep()) instanceof ActionPopupStep) {
            ActionPopupStep actionPopupStep = (ActionPopupStep)step2;
            actionPopupStep.setSubStepContextAdjuster((stepContext, action) -> {
                if (action instanceof SelectConfigAction) {
                    SelectConfigAction selectConfigAction = (SelectConfigAction)((Object)action);
                    return CustomizedDataContext.withSnapshot((DataContext)stepContext, sink -> sink.set(RunToolbarPopupKt.RUN_CONFIGURATION_KEY, (Object)selectConfigAction.getConfiguration()));
                }
                return stepContext;
            });
        }
        return popup;
    }

    public static void forAllExecutors(@NotNull Consumer<? super Executor> executorProcessor) {
        if (executorProcessor == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(20);
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (executor instanceof ExecutorGroup) {
                for (Executor childExecutor : ((ExecutorGroup)executor).childExecutors()) {
                    executorProcessor.accept((Executor)childExecutor);
                }
                continue;
            }
            executorProcessor.accept((Executor)executor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderMaps";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunCurrentFileItem";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasRunSubActions";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performWhenButton";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfigurationFolderActions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFinalAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forAllExecutors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 13, 14 -> new IllegalStateException(string);
        };
    }

    public final class RunConfigurationsComboBoxButton
    extends ComboBoxAction.ComboBoxButton {
        public RunConfigurationsComboBoxButton(Presentation presentation) {
            if (presentation == null) {
                RunConfigurationsComboBoxButton.$$$reportNull$$$0(0);
            }
            super((ComboBoxAction)RunConfigurationsComboBoxAction.this, presentation);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.max(d.width, JBUIScale.scale((int)75));
            return d;
        }

        protected void doShiftClick() {
            DataContext context = DataManager.getInstance().getDataContext((Component)((Object)this));
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project != null && !ActionUtil.isDumbMode((Project)project)) {
                new EditConfigurationsDialog(project).show();
                return;
            }
            super.doShiftClick();
        }

        protected void fireActionPerformed(ActionEvent event) {
            if (Boolean.TRUE.equals(this.getPresentation().getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE))) {
                RunConfigurationsComboBoxAction.performWhenButton((Component)((Object)this), "unknown");
                return;
            }
            super.fireActionPerformed(event);
        }

        protected boolean isArrowVisible(@NotNull Presentation presentation) {
            if (presentation == null) {
                RunConfigurationsComboBoxButton.$$$reportNull$$$0(1);
            }
            return !Boolean.TRUE.equals(presentation.getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "presentation";
            objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$RunConfigurationsComboBoxButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isArrowVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SaveTemporaryAction
    extends DumbAwareAction {
        SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.MenuSaveall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project;
            if (e == null) {
                SaveTemporaryAction.$$$reportNull$$$0(0);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) != null && (settings = SaveTemporaryAction.chooseTempSettings(project)) != null) {
                RunManager runManager = RunManager.getInstance((Project)project);
                runManager.makeStable(settings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SaveTemporaryAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.messagePointer((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{Executor.shortenNameIfNeeded((String)settings.getName())}));
                presentation.setDescription(presentation.getText());
                presentation.setEnabledAndVisible(true);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SaveTemporaryAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabledAndVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project) {
            RunnerAndConfigurationSettings selectedConfiguration;
            if (project == null) {
                SaveTemporaryAction.$$$reportNull$$$0(3);
            }
            if ((selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration()) != null && selectedConfiguration.isTemporary()) {
                return selectedConfiguration;
            }
            return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)RunManager.getInstance((Project)project).getTempConfigurationsList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseTempSettings";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class RunCurrentFileAction
    extends ActionGroup
    implements DumbAware,
    RequiresPermissions {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = this.getDefaultChildren(null).toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                RunCurrentFileAction.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        @NotNull
        protected List<AnAction> getDefaultChildren(@Nullable Predicate<? super Executor> executorFilter) {
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            RunConfigurationsComboBoxAction.forAllExecutors(o -> {
                if (executorFilter == null || executorFilter.test((Executor)o)) {
                    result2.add(new RunCurrentFileExecutorAction((Executor)o));
                }
            });
            result2.add((AnAction)Separator.getInstance());
            result2.add(new EditRunConfigAndRunCurrentFileExecutorAction(DefaultRunExecutor.getRunExecutorInstance()));
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                RunCurrentFileAction.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RunCurrentFileAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setPopupGroup(true);
            e.getPresentation().setPerformGroup(true);
            e.getPresentation().setText(ExecutionBundle.messagePointer((String)"run.configurations.combo.run.current.file.item.in.dropdown", (Object[])new Object[0]));
            e.getPresentation().setDescription(ExecutionBundle.messagePointer((String)"run.configurations.combo.run.current.file.description", (Object[])new Object[0]));
            e.getPresentation().setEnabledAndVisible(e.getProject() != null && RunConfigurationsComboBoxAction.hasRunCurrentFileItem(e.getProject()));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RunCurrentFileAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                RunCurrentFileAction.$$$reportNull$$$0(4);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            RunManager.getInstance((Project)project).setSelectedConfiguration(null);
            RunConfigurationsComboBoxAction.updatePresentation(null, null, project, e.getPresentation(), e.getPlace());
        }

        @NotNull
        public @NotNull Collection<@NotNull Permission> getRequiredPermissions() {
            List<Permission> list = List.of(PermissionsKt.getRunViewAccess());
            if (list == null) {
                RunCurrentFileAction.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$RunCurrentFileAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultChildren";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$RunCurrentFileAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequiredPermissions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;
        private static final Icon CHECKED_ICON = JBUIScale.scaleIcon((JBScalableIcon)new SizedIcon(AllIcons.Actions.Checked, 16, 16));
        private static final Icon CHECKED_SELECTED_ICON = JBUIScale.scaleIcon((JBScalableIcon)new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16));

        SelectTargetAction(Project project, ExecutionTarget target, boolean selected) {
            this.myProject = project;
            this.myTarget = target;
            String name = target.getDisplayName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription(ExecutionBundle.message((String)"select.0", (Object[])new Object[]{name}));
            presentation.setIcon(selected ? CHECKED_ICON : EMPTY_ICON);
            presentation.setSelectedIcon(selected ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectTargetAction.$$$reportNull$$$0(0);
            }
            ExecutionTargetManager.setActiveTarget((Project)this.myProject, (ExecutionTarget)this.myTarget);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation(), e.getPlace());
        }

        public boolean isDumbAware() {
            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            return configuration == null || configuration.getType().isDumbAware();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectTargetAction", "actionPerformed"));
        }
    }

    @ApiStatus.Internal
    public static class SelectConfigAction
    extends ActionGroup
    implements DumbAware,
    RequiresPermissions {
        private final Project myProject;
        private final RunnerAndConfigurationSettings myConfiguration;

        public SelectConfigAction(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration) {
            if (project == null) {
                SelectConfigAction.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                SelectConfigAction.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myConfiguration = configuration;
            this.getTemplatePresentation().putClientProperty(RunToolbarPopupKt.RUN_CONFIGURATION_ID, (Object)this.myConfiguration.getUniqueID());
        }

        @NotNull
        public RunnerAndConfigurationSettings getConfiguration() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myConfiguration;
            if (runnerAndConfigurationSettings == null) {
                SelectConfigAction.$$$reportNull$$$0(2);
            }
            return runnerAndConfigurationSettings;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = this.getDefaultChildren(null).toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                SelectConfigAction.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        @NotNull
        protected List<AnAction> getDefaultChildren(@Nullable Predicate<? super Executor> executorFilter) {
            if (!RunConfigurationsComboBoxAction.hasRunSubActions(this.myProject)) {
                List<AnAction> list = Collections.emptyList();
                if (list == null) {
                    SelectConfigAction.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            RunConfigurationsComboBoxAction.forAllExecutors(o -> {
                if (executorFilter == null || executorFilter.test((Executor)o)) {
                    result2.add(new RunSpecifiedConfigExecutorAction((Executor)o, this.myConfiguration, false));
                }
            });
            result2.add((AnAction)Separator.create(ExperimentalUI.isNewUI() ? ExecutionBundle.message((String)"choose.run.popup.separator", (Object[])new Object[0]) : null));
            if (!ExperimentalUI.isNewUI()) {
                Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
                result2.add(new RunSpecifiedConfigExecutorAction(runExecutor, this.myConfiguration, true));
            } else {
                result2.add(ActionManager.getInstance().getAction("editRunConfigurations"));
            }
            result2.add(ActionManager.getInstance().getAction(RunConfigurationsComboBoxAction.RUN_CONFIGURATION_GROUP_ID));
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                SelectConfigAction.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectConfigAction.$$$reportNull$$$0(6);
            }
            RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), this.myConfiguration, this.myProject, e.getPresentation(), e.getPlace());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectConfigAction.$$$reportNull$$$0(7);
            }
            e.getPresentation().setPopupGroup(true);
            e.getPresentation().setPerformGroup(true);
            e.getPresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
            String fullName = this.myConfiguration.getName();
            String name = StringUtil.notNullize((String)StringUtil.nullize((String)Executor.shortenNameIfNeeded((String)fullName), (String)" "));
            String toolTip = name.equals(fullName) ? null : fullName;
            Presentation presentation = e.getPresentation();
            presentation.setText(name, false);
            presentation.setDescription(ExecutionBundle.message((String)"select.0.1", (Object[])new Object[]{this.myConfiguration.getType().getConfigurationTypeDescription(), name}));
            presentation.putClientProperty(ActionUtil.TOOLTIP_TEXT, (Object)toolTip);
            RunConfigurationsComboBoxAction.setConfigurationIcon(e.getPresentation(), this.myConfiguration, this.myProject);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SelectConfigAction.$$$reportNull$$$0(8);
            }
            return actionUpdateThread;
        }

        @NotNull
        public @NotNull Collection<@NotNull Permission> getRequiredPermissions() {
            List<Permission> list = List.of(PermissionsKt.getRunViewAccess());
            if (list == null) {
                SelectConfigAction.$$$reportNull$$$0(9);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectConfigAction";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectConfigAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfiguration";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultChildren";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequiredPermissions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

