/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.PermissionsKt;
import com.intellij.execution.StoppableRunDescriptorsKt;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.platform.ide.core.permissions.RequiresPermissions;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopAction
extends DumbAwareAction
implements RequiresPermissions,
ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    private WeakReference<JBPopup> myActivePopupRef = null;

    private static boolean isPlaceGlobal(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(0);
        }
        return ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "NewUiRunToolbar".equals(e.getPlace()) || "MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()) || "TouchBarGeneral".equals(e.getPlace());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            StopAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(2);
        }
        boolean enable = false;
        Icon icon = this.getActionIcon(e);
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e.getPresentation();
        if (StopAction.isPlaceGlobal(e)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e.getProject());
            int stopCount = stoppableDescriptors.size();
            boolean bl = enable = stopCount >= 1;
            if (!enable && e.getPlace().equals("NewUiRunToolbar")) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            if (stopCount > 1) {
                presentation.setText(this.getTemplatePresentation().getText() + "...");
                String text = RunToolbarPopupKt.runCounterToString(e, stopCount);
                icon = IconUtil.addText((Icon)icon, (String)text);
            } else if (stopCount == 1) {
                presentation.setText(ExecutionBundle.messagePointer((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.notNullize((String)stoppableDescriptors.get(0).getDisplayName()))}));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler2 = processHandler = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler != null && !processHandler.isProcessTerminated()) {
                if (!processHandler.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = ExecutionBundle.message((String)"action.terminating.process.progress.kill.description", (Object[])new Object[0]);
                }
            }
            if ((runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(ExecutionBundle.messagePointer((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)(runProfile == null ? StringUtil.notNullize((String)contentDescriptor.getDisplayName()) : runProfile.getName()))}));
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    protected Icon getActionIcon(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(3);
        }
        return this.getTemplatePresentation().getIcon();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(4);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(project);
        int stopCount = stoppableDescriptors.size();
        if (StopAction.isPlaceGlobal(e)) {
            if (stopCount == 1) {
                ExecutionManagerImpl.stopProcess(stoppableDescriptors.get(0));
                return;
            }
            if ("NewUiRunToolbar".equals(e.getPlace()) && project != null) {
                JBPopup popup = RunToolbarPopupKt.createStopPopup(dataContext, project);
                StopAction.showStopPopup(e, dataContext, project, popup);
                return;
            }
            final com.intellij.openapi.util.Pair<List<HandlerItem>, HandlerItem> handlerItems = this.getItemsList(project, stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            HandlerItem stopAllItem = new HandlerItem(this, ExecutionBundle.message((String)"stop.all", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"Stop")}), this.getActionIcon(e), true){

                @Override
                void stop() {
                    for (HandlerItem item : (List)handlerItems.first) {
                        if (item == this) continue;
                        item.stop();
                    }
                }
            };
            JBPopup activePopup = (JBPopup)SoftReference.dereference(this.myActivePopupRef);
            if (activePopup != null) {
                stopAllItem.stop();
                activePopup.cancel();
                return;
            }
            List items = (List)handlerItems.first;
            if (stopCount > 1) {
                items.add(stopAllItem);
            }
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter<HandlerItem>(this){

                @Nullable
                public String getTextFor(HandlerItem item) {
                    return item.displayName;
                }

                @Nullable
                public Icon getIconFor(HandlerItem item) {
                    return item.icon;
                }

                public boolean hasSeparatorAboveOf(HandlerItem item) {
                    return item.hasSeparator;
                }
            })).setMovable(true).setTitle(items.size() == 1 ? ExecutionBundle.message((String)"confirm.process.stop", (Object[])new Object[0]) : ExecutionBundle.message((String)"stop.process", (Object[])new Object[0])).setNamerForFiltering(o -> o.displayName).setItemsChosenCallback(valuesList -> {
                for (HandlerItem item : valuesList) {
                    item.stop();
                }
            }).addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    StopAction.this.myActivePopupRef = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/actions/StopAction$2", "onClosed"));
                }
            }).setRequestFocus(true);
            if (handlerItems.second != null) {
                builder2.setSelectedValue((Object)((HandlerItem)handlerItems.second), true);
            }
            JBPopup popup = builder2.createPopup();
            this.myActivePopupRef = new WeakReference<JBPopup>(popup);
            StopAction.showStopPopup(e, dataContext, project, popup);
        } else {
            ExecutionManagerImpl.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    private static void showStopPopup(@NotNull AnActionEvent e, DataContext dataContext, Project project, JBPopup popup) {
        InputEvent inputEvent;
        Component component;
        if (e == null) {
            StopAction.$$$reportNull$$$0(5);
        }
        Component component2 = component = (inputEvent = e.getInputEvent()) != null ? inputEvent.getComponent() : null;
        if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace())) || "NewUiRunToolbar".equals(e.getPlace())) {
            popup.showUnderneathOf(component);
        } else if (project == null) {
            popup.showInBestPositionFor(dataContext);
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
    }

    @Nullable
    private com.intellij.openapi.util.Pair<List<HandlerItem>, HandlerItem> getItemsList(Project project, List<? extends RunContentDescriptor> descriptors, RunContentDescriptor toSelect) {
        if (descriptors.isEmpty()) {
            return null;
        }
        ArrayList<4> items = new ArrayList<4>(descriptors.size());
        HandlerItem selected = null;
        for (final RunContentDescriptor runContentDescriptor2 : descriptors) {
            ProcessHandler handler2 = runContentDescriptor2.getProcessHandler();
            if (handler2 == null) continue;
            HandlerItem item = new HandlerItem(this, this.getDisplayName(project, runContentDescriptor2), runContentDescriptor2.getIcon(), false){

                @Override
                void stop() {
                    ExecutionManagerImpl.stopProcess(runContentDescriptor2);
                }
            };
            items.add(item);
            if (runContentDescriptor2 != toSelect) continue;
            selected = item;
        }
        return com.intellij.openapi.util.Pair.create(items, selected);
    }

    @BuildEventsNls.Title
    protected String getDisplayName(Project project, RunContentDescriptor descriptor) {
        return descriptor.getDisplayName();
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        RunContentDescriptor contentDescriptor;
        if (dataContext == null) {
            StopAction.$$$reportNull$$$0(6);
        }
        if ((contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext)) != null) {
            return contentDescriptor;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project == null ? null : RunContentManager.getInstance((Project)project).getSelectedContent();
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RunContentDescriptor> getActiveStoppableDescriptors(@Nullable Project project) {
        List runningProcesses;
        List list = runningProcesses = project != null ? ContainerUtil.map(StoppableRunDescriptorsKt.getStoppableDescriptors(project), Pair::getFirst) : Collections.emptyList();
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                StopAction.$$$reportNull$$$0(7);
            }
            return list2;
        }
        SmartList activeDescriptors = new SmartList();
        for (RunContentDescriptor descriptor : runningProcesses) {
            if (!StopAction.canBeStopped(descriptor)) continue;
            activeDescriptors.add(descriptor);
        }
        SmartList smartList = activeDescriptors;
        if (smartList == null) {
            StopAction.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor) {
        @Nullable ProcessHandler processHandler = descriptor != null ? descriptor.getProcessHandler() : null;
        return processHandler != null && !processHandler.isProcessTerminated() && (!processHandler.isProcessTerminating() || processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess());
    }

    @NotNull
    public @NotNull Collection<@NotNull Permission> getRequiredPermissions() {
        List<Permission> list = List.of(PermissionsKt.getFullRunAccess());
        if (list == null) {
            StopAction.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/StopAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/StopAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveStoppableDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredPermissions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceGlobal";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showStopPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRecentlyStartedContentDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    static abstract class HandlerItem {
        @Nls
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        HandlerItem(@Nls String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

