/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvFilesDialog;
import com.intellij.execution.configuration.EnvFilesDialogKt;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesDialog;
import com.intellij.execution.util.EnvVariables;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton.NoPathCompletion
implements UserActivityProviderComponent {
    protected EnvironmentVariablesData myData = EnvironmentVariablesData.DEFAULT;
    protected final Map<String, String> myParentDefaults = new LinkedHashMap<String, String>();
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private List<String> myEnvFilePaths = new ArrayList<String>();
    private ExtendableTextComponent.Extension myEnvFilesExtension;
    private final List<ChangeListener> myEnvFilePathsChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(EnvVariablesTable.parseEnvsFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText()));
                EnvironmentVariablesTextFieldWithBrowseButton.this.createDialog().show();
            }
        });
        this.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!StringUtil.equals((CharSequence)EnvironmentVariablesTextFieldWithBrowseButton.this.getEnvText(), (CharSequence)EnvironmentVariablesTextFieldWithBrowseButton.this.getText())) {
                    EnvVariables parsedEnvsAndFiles = EnvVariables.parseFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText());
                    EnvironmentVariablesTextFieldWithBrowseButton.this.myData = EnvironmentVariablesTextFieldWithBrowseButton.this.myData.with(parsedEnvsAndFiles.getEnvs());
                    EnvironmentVariablesTextFieldWithBrowseButton.this.updateEnvFiles(parsedEnvsAndFiles.getEnvFiles());
                    EnvironmentVariablesTextFieldWithBrowseButton.this.fireStateChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton$2", "textChanged"));
            }
        });
        this.getTextField().getEmptyText().setText(ExecutionBundle.message((String)"status.text.environment.variables", (Object[])new Object[0]));
    }

    private void addEnvFilesExtension() {
        if (this.myEnvFilesExtension != null) {
            return;
        }
        this.myEnvFilesExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, (String)ExecutionBundle.message((String)"tooltip.browse.for.environment.files", (Object[])new Object[0]), (boolean)true, () -> this.browseForEnvFile());
        this.getTextField().addExtension(this.myEnvFilesExtension);
        this.getTextField().getEmptyText().setText(ExecutionBundle.message((String)"status.text.environment.variables.or.env.files", (Object[])new Object[0]));
    }

    private void browseForEnvFile() {
        if (this.myEnvFilePaths.isEmpty()) {
            EnvFilesDialogKt.addEnvFile((Component)this.getTextField(), null, (Function1<? super String, Unit>)((Function1)s -> {
                this.myEnvFilePaths.add((String)s);
                this.updateText();
                this.fireEnvFilePathsChanged();
                return Unit.INSTANCE;
            }));
        } else {
            EnvFilesDialog dialog = new EnvFilesDialog((JComponent)((Object)this), this.myEnvFilePaths);
            dialog.show();
            if (dialog.isOK()) {
                this.myEnvFilePaths = new ArrayList<String>(dialog.getPaths());
                this.updateText();
                this.fireEnvFilePathsChanged();
            }
        }
    }

    @NotNull
    public ExtendableTextField getTextField() {
        ExtendableTextField extendableTextField = (ExtendableTextField)super.getTextField();
        if (extendableTextField == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(0);
        }
        return extendableTextField;
    }

    @NotNull
    protected EnvironmentVariablesDialog createDialog() {
        return new EnvironmentVariablesDialog(this);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myData.getEnvs();
        if (map == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(1);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(2);
        }
        this.setData(this.myData.with(envs));
    }

    @NotNull
    public EnvironmentVariablesData getData() {
        EnvironmentVariablesData environmentVariablesData = this.myData;
        if (environmentVariablesData == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(3);
        }
        return environmentVariablesData;
    }

    public void setData(@NotNull EnvironmentVariablesData data) {
        if (data == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(4);
        }
        EnvironmentVariablesData oldData = this.myData;
        this.myData = data;
        this.updateText();
        if (!oldData.equals(data)) {
            this.fireStateChanged();
        }
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon = AllIcons.General.InlineVariables;
        if (icon == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        Icon icon = AllIcons.General.InlineVariablesHover;
        if (icon == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(6);
        }
        return icon;
    }

    private String getEnvText() {
        String s = this.stringifyEnvs(this.myData);
        if (this.myEnvFilePaths.isEmpty()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s);
        for (String path : this.myEnvFilePaths) {
            if (!buf.isEmpty()) {
                buf.append(";");
            }
            buf.append(path);
        }
        return buf.toString();
    }

    private void updateText() {
        this.setText(this.getEnvText());
    }

    @NotNull
    protected String stringifyEnvs(@NotNull EnvironmentVariablesData evd) {
        if (evd == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(7);
        }
        String string = EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvironment(evd);
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(8);
        }
        return string;
    }

    @ApiStatus.Internal
    public static String stringifyEnvironment(@NotNull EnvironmentVariablesData evd) {
        if (evd == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(9);
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : evd.getEnvs().entrySet()) {
            if (!buf.isEmpty()) {
                buf.append(";");
            }
            buf.append(EnvironmentVariablesTextFieldWithBrowseButton.tryEscapeKeyOrValue(entry.getKey())).append("=").append(EnvironmentVariablesTextFieldWithBrowseButton.tryEscapeKeyOrValue(entry.getValue()));
        }
        return buf.toString();
    }

    @NotNull
    private static String tryEscapeKeyOrValue(@NotNull String keyOrValue) {
        if (keyOrValue == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(10);
        }
        if (keyOrValue.contains(";") || keyOrValue.contains("=") || keyOrValue.contains("\"")) {
            String string = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeChars((String)keyOrValue, (char[])new char[]{'\\', '\"'}));
            if (string == null) {
                EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = keyOrValue;
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.setData(this.myData.with(passParentEnvs));
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(13);
        }
        this.myListeners.add(changeListener);
    }

    public void addEnvFilePathsChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(14);
        }
        this.myEnvFilePathsChangeListeners.add(changeListener);
    }

    public void removeEnvFilePathsChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(15);
        }
        this.myEnvFilePathsChangeListeners.remove(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(16);
        }
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener2 : this.myListeners) {
            listener2.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private void fireEnvFilePathsChanged() {
        for (ChangeListener listener2 : this.myEnvFilePathsChangeListeners) {
            listener2.stateChanged(new ChangeEvent((Object)this));
        }
    }

    void setEnvFilePaths(@NotNull List<String> paths) {
        if (paths == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(17);
        }
        this.myEnvFilePaths = new ArrayList<String>(paths);
        this.setData(this.myData);
        this.addEnvFilesExtension();
        this.fireEnvFilePathsChanged();
    }

    @NotNull
    List<String> getEnvFilePaths() {
        List<String> list = this.myEnvFilePaths;
        if (list == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(18);
        }
        return list;
    }

    private void updateEnvFiles(List<String> files) {
        if (this.myEnvFilePaths.isEmpty() || files.isEmpty()) {
            return;
        }
        for (int i = 0; i < Math.min(this.myEnvFilePaths.size(), files.size()); ++i) {
            this.myEnvFilePaths.set(i, files.get(i));
        }
        this.fireEnvFilePathsChanged();
    }

    protected static @Unmodifiable List<EnvironmentVariable> convertToVariables(Map<String, String> map, final boolean readOnly) {
        return ContainerUtil.map(map.entrySet(), entry -> new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue(), readOnly){

            public boolean getNameIsWriteable() {
                return !readOnly;
            }
        });
    }

    @NlsContexts.Tooltip
    @NotNull
    protected String getIconTooltip() {
        String string = ExecutionBundle.message((String)"specify.environment.variables.tooltip", (Object[])new Object[0]) + " (" + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 64)) + ")";
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected boolean isModifiedSysEnv(@NotNull EnvironmentVariable v) {
        if (v == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(20);
        }
        return !v.getNameIsWriteable() && !Objects.equals(v.getValue(), this.myParentDefaults.get(v.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 7, 9, 10, 13, 14, 15, 16, 17, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evd";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyOrValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyEnvs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryEscapeKeyOrValue";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvFilePaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringifyEnvs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringifyEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryEscapeKeyOrValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addEnvFilePathsChangeListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeEnvFilePathsChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setEnvFilePaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedSysEnv";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 7, 9, 10, 13, 14, 15, 16, 17, 20 -> new IllegalArgumentException(string);
        };
    }
}

