/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.PatternHyperlinkPart;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class PatternHyperlinkFormat {
    private final Pattern myPattern;
    private final boolean myZeroBasedLineNumbering;
    private final boolean myZeroBasedColumnNumbering;
    private final PatternHyperlinkPart[] myLinkParts;
    private final List<String> myRequiredOrderedSubstrings;

    public PatternHyperlinkFormat(@NotNull Pattern pattern, boolean zeroBasedLineNumbering, boolean zeroBasedColumnNumbering, PatternHyperlinkPart ... linkParts) {
        if (pattern == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(0);
        }
        if (linkParts == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(1);
        }
        this(pattern, zeroBasedLineNumbering, zeroBasedColumnNumbering, List.of(), linkParts);
    }

    public PatternHyperlinkFormat(@NotNull Pattern pattern, boolean zeroBasedLineNumbering, boolean zeroBasedColumnNumbering, @NotNull List<String> requiredOrderedSubstrings, PatternHyperlinkPart ... linkParts) {
        if (pattern == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(2);
        }
        if (requiredOrderedSubstrings == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(3);
        }
        if (linkParts == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(4);
        }
        this.myPattern = pattern;
        this.myZeroBasedLineNumbering = zeroBasedLineNumbering;
        this.myZeroBasedColumnNumbering = zeroBasedColumnNumbering;
        this.myRequiredOrderedSubstrings = List.copyOf(requiredOrderedSubstrings);
        this.myLinkParts = linkParts;
    }

    @NotNull
    Pattern getPattern() {
        Pattern pattern = this.myPattern;
        if (pattern == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(5);
        }
        return pattern;
    }

    boolean isZeroBasedLineNumbering() {
        return this.myZeroBasedLineNumbering;
    }

    boolean isZeroBasedColumnNumbering() {
        return this.myZeroBasedColumnNumbering;
    }

    PatternHyperlinkPart @NotNull [] getLinkParts() {
        if (this.myLinkParts == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(6);
        }
        return this.myLinkParts;
    }

    boolean matchRequiredSubstrings(@NotNull String line) {
        if (line == null) {
            PatternHyperlinkFormat.$$$reportNull$$$0(7);
        }
        int ind = 0;
        for (String required : this.myRequiredOrderedSubstrings) {
            int nextInd = line.indexOf(required, ind);
            if (nextInd < 0) {
                return false;
            }
            ind = nextInd + required.length();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkParts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredOrderedSubstrings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/PatternHyperlinkFormat";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/PatternHyperlinkFormat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchRequiredSubstrings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

