/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.BackendExecutionEnvironmentProxy;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.runners.RunnerAndConfigurationSettingsProxy;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ExperimentalUI;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FakeRerunAction
extends AnAction
implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            FakeRerunAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        ExecutionEnvironmentProxy environment = this.getEnvironmentProxy(event);
        if (environment == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (environment.isShowInDashboard() && ("RunnerToolbar".equals(event.getPlace()) || "DebuggerToolbar".equals(event.getPlace()))) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setText(ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment.getRunProfileName())}));
        Icon rerunIcon = ExperimentalUI.isNewUI() ? environment.getRerunIcon() : environment.getIcon();
        RunContentDescriptor descriptor = this.getDescriptor(event);
        boolean isRestart = "TouchBarGeneral".equals(event.getPlace()) || descriptor != null && ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event));
        presentation.setIcon(isRestart && !ExperimentalUI.isNewUI() ? AllIcons.Actions.Restart : rerunIcon);
        presentation.setEnabled(this.isEnabled(event));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        ExecutionEnvironmentProxy environment;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(2);
        }
        if ((environment = this.getEnvironmentProxy(event)) != null) {
            environment.performRestart();
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return (RunContentDescriptor)event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironmentProxy getEnvironmentProxy(@NotNull AnActionEvent event) {
        RunContentManager runContentManager;
        ExecutionEnvironmentProxy proxyFromContext;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(3);
        }
        if ((proxyFromContext = (ExecutionEnvironmentProxy)event.getData(RunTab.EXECUTION_ENVIRONMENT_PROXY)) != null) {
            return proxyFromContext;
        }
        ExecutionEnvironment environmentFromContext = (ExecutionEnvironment)event.getData(ExecutionDataKeys.EXECUTION_ENVIRONMENT);
        if (environmentFromContext != null) {
            return new BackendExecutionEnvironmentProxy(environmentFromContext);
        }
        Project project = event.getProject();
        RunContentManager runContentManager2 = runContentManager = project == null ? null : RunContentManager.getInstanceIfCreated((Project)project);
        if (runContentManager == null) {
            return null;
        }
        RunContentDescriptor contentDescriptor = runContentManager.getSelectedContent();
        if (contentDescriptor == null) {
            return null;
        }
        JComponent component = contentDescriptor.getComponent();
        if (component == null) {
            return null;
        }
        DataContext componentDataContext = DataManager.getInstance().getDataContext((Component)component);
        ExecutionEnvironmentProxy proxyFromSelectedContent = (ExecutionEnvironmentProxy)RunTab.EXECUTION_ENVIRONMENT_PROXY.getData(componentDataContext);
        if (proxyFromSelectedContent != null) {
            return proxyFromSelectedContent;
        }
        ExecutionEnvironment environmentFromSelectedContent = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(componentDataContext);
        if (environmentFromSelectedContent != null) {
            return new BackendExecutionEnvironmentProxy(environmentFromSelectedContent);
        }
        return null;
    }

    protected boolean isEnabled(@NotNull AnActionEvent event) {
        RunContentDescriptor descriptor;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(4);
        }
        ProcessHandler processHandler = (descriptor = this.getDescriptor(event)) == null ? null : descriptor.getProcessHandler();
        ExecutionEnvironmentProxy environment = this.getEnvironmentProxy(event);
        Project project = FakeRerunAction.getEventProject((AnActionEvent)event);
        if (environment == null || project == null) {
            return false;
        }
        RunnerAndConfigurationSettingsProxy settings = environment.getRunnerAndConfigurationSettingsProxy();
        return !(DumbService.isDumb((Project)project) && settings != null && !settings.isDumbAware() || environment.isStarting() || processHandler != null && processHandler.isProcessTerminating());
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/FakeRerunAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/FakeRerunAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentProxy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

