/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.ui.InvalidRunConfigurationIcon;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RunOnTargetComboBox
extends ComboBox<Item> {
    public static final Logger LOGGER = Logger.getInstance(RunOnTargetComboBox.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private LanguageRuntimeType<?> myDefaultRuntimeType;
    private boolean hasSavedTargets;
    @NotNull
    private final MyRenderer myRenderer;

    public RunOnTargetComboBox(@NotNull Project project) {
        if (project == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(0);
        }
        this.hasSavedTargets = false;
        this.myRenderer = new MyRenderer(() -> this.hasSavedTargets);
        this.setModel(new MyModel());
        this.myProject = project;
        this.setRenderer((ListCellRenderer)((Object)this.myRenderer));
        this.addActionListener(e -> this.validateSelectedTarget());
    }

    public void initModel() {
        this.myRenderer.setProjectDefaultTarget(TargetEnvironmentsManager.getInstance((Project)this.myProject).getDefaultTarget());
        this.hasSavedTargets = false;
        MyModel model = (MyModel)this.getModel();
        model.removeAllElements();
        model.addElement(null);
        ArrayList types = new ArrayList();
        for (TargetEnvironmentType targetEnvironmentType : TargetEnvironmentType.getTargetTypesForRunConfigurations()) {
            if (!targetEnvironmentType.isSystemCompatible() || !targetEnvironmentType.providesNewWizard(this.myProject, this.myDefaultRuntimeType)) continue;
            types.add(new Type(targetEnvironmentType));
        }
        if (!types.isEmpty()) {
            model.addElement(new Separator(ExecutionBundle.message((String)"run.on.targets.label.new.targets", (Object[])new Object[0])));
            for (Type type : types) {
                model.addElement(type);
            }
        }
    }

    public void setDefaultLanguageRuntimeType(@Nullable LanguageRuntimeType<?> defaultLanguageRuntimeType) {
        this.myDefaultRuntimeType = defaultLanguageRuntimeType;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return this.myDefaultRuntimeType;
    }

    public void addTarget(@NotNull TargetEnvironmentConfiguration config, int index) {
        if (config == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(1);
        }
        if (!this.hasSavedTargets) {
            this.hasSavedTargets = true;
            ((MyModel)this.getModel()).insertElementAt(new Separator(ExecutionBundle.message((String)"run.on.targets.label.saved.targets", (Object[])new Object[0])), 1);
            ((MyModel)this.getModel()).insertElementAt(new LocalTarget(), 2);
        }
        ((MyModel)this.getModel()).insertElementAt(new SavedTarget(config), index);
    }

    @Nullable
    public String getSelectedTargetName() {
        return (String)ObjectUtils.doIfCast((Object)this.getSelectedItem(), Target.class, i -> i.getTargetName());
    }

    public void addTargets(List<? extends TargetEnvironmentConfiguration> configs) {
        int index = 3;
        for (TargetEnvironmentConfiguration targetEnvironmentConfiguration : configs) {
            this.addTarget(targetEnvironmentConfiguration, index);
            ++index;
        }
    }

    public void selectTarget(String configName) {
        if (configName == null) {
            this.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Item at = (Item)this.getModel().getElementAt(i);
            if (!(at instanceof Target) || !configName.equals(((Target)at).getTargetName())) continue;
            this.setSelectedItem(at);
        }
    }

    private void validateSelectedTarget() {
        Object selected = this.getSelectedItem();
        boolean hasErrors = false;
        if (selected instanceof SavedTarget) {
            SavedTarget target = (SavedTarget)selected;
            target.revalidateConfiguration();
            hasErrors = target.hasErrors();
        }
        this.putClientProperty("JComponent.outline", hasErrors ? "error" : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyRenderer
    extends ColoredListCellRenderer<Item> {
        @Nullable
        private Item myProjectDefaultTargetItem;
        @NotNull
        private final Supplier<Boolean> myHasSavedTargetsSupplier;

        private MyRenderer(@NotNull Supplier<Boolean> hasSavedTargetsSupplier) {
            if (hasSavedTargetsSupplier == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            this.myHasSavedTargetsSupplier = hasSavedTargetsSupplier;
        }

        public void setProjectDefaultTarget(@Nullable TargetEnvironmentConfiguration projectDefaultTarget) {
            this.myProjectDefaultTargetItem = projectDefaultTarget != null ? new SavedTarget(projectDefaultTarget) : null;
        }

        public Component getListCellRendererComponent(JList<? extends Item> list, Item value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof Separator) {
                SeparatorWithText separator = new SeparatorWithText();
                separator.setCaption(value.getDisplayName());
                return separator;
            }
            return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Item> list, Item value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            if (value == null && !this.myHasSavedTargetsSupplier.get().booleanValue()) {
                this.append(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]));
                this.setIcon(AllIcons.Nodes.HomeFolder);
            } else if (value == null) {
                this.append(ExecutionBundle.message((String)"targets.details.project.default", (Object[])new Object[0])).append(" ");
                if (this.myProjectDefaultTargetItem == null) {
                    this.append(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.setIcon(AllIcons.Nodes.HomeFolder);
                } else {
                    this.append(this.myProjectDefaultTargetItem.getDisplayName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.setIcon(this.myProjectDefaultTargetItem.icon);
                }
            } else {
                this.append(value.getDisplayName());
                this.setIcon(value.getIcon());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasSavedTargetsSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyModel
    extends DefaultComboBoxModel<Item> {
        private MyModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof Separator) {
                return;
            }
            if (anObject instanceof Type) {
                RunOnTargetComboBox.this.hidePopup();
                TargetEnvironmentWizard wizard = ((Type)anObject).createWizard(RunOnTargetComboBox.this.myProject, RunOnTargetComboBox.this.myDefaultRuntimeType);
                if (wizard != null && wizard.showAndGet()) {
                    TargetEnvironmentConfiguration newTarget = wizard.getSubject();
                    TargetEnvironmentsManager.getInstance((Project)RunOnTargetComboBox.this.myProject).addTarget(newTarget);
                    RunOnTargetComboBox.this.addTarget(newTarget, 2);
                    RunOnTargetComboBox.this.setSelectedIndex(2);
                }
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private static final class Type<T extends TargetEnvironmentConfiguration>
    extends Item {
        @NotNull
        private final TargetEnvironmentType<T> type;

        private Type(@NotNull TargetEnvironmentType<T> type) {
            if (type == null) {
                Type.$$$reportNull$$$0(0);
            }
            super(ExecutionBundle.message((String)"run.on.targets.label.new.target.of.type", (Object[])new Object[]{type.getDisplayName()}), type.getIcon());
            this.type = type;
        }

        @Nullable
        TargetEnvironmentWizard createWizard(@NotNull Project project, @Nullable LanguageRuntimeType<?> languageRuntime) {
            if (project == null) {
                Type.$$$reportNull$$$0(1);
            }
            return TargetEnvironmentWizard.createWizard(project, this.type, languageRuntime);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$Type";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createWizard";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Separator
    extends Item {
        private Separator(@NlsContexts.Label String displayName) {
            super(displayName, null);
        }
    }

    private static final class LocalTarget
    extends Target {
        private LocalTarget() {
            super(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]), AllIcons.Nodes.HomeFolder, "@@@LOCAL@@@");
        }
    }

    private static final class SavedTarget
    extends Target {
        private final TargetEnvironmentConfiguration myConfig;
        @Nullable
        private ValidationInfo myValidationInfo;

        private SavedTarget(TargetEnvironmentConfiguration config) {
            super(config.getDisplayName(), TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)config).getIcon());
            this.myConfig = config;
            this.revalidateConfiguration();
        }

        public void revalidateConfiguration() {
            try {
                this.myConfig.validateConfiguration();
                this.myValidationInfo = null;
            }
            catch (RuntimeConfigurationException e) {
                this.myValidationInfo = new ValidationInfo(e.getLocalizedMessage());
            }
        }

        @Nullable
        public ValidationInfo getValidationInfo() {
            return this.myValidationInfo;
        }

        public boolean hasErrors() {
            return this.getValidationInfo() != null;
        }

        @Override
        public Icon getIcon() {
            Icon rawIcon = super.getIcon();
            return rawIcon != null && this.hasErrors() ? new InvalidRunConfigurationIcon(rawIcon) : rawIcon;
        }
    }

    private static abstract class Target
    extends Item {
        @NotNull
        private final String myTargetName;

        private Target(@NlsContexts.Label @NotNull String displayName, Icon icon) {
            if (displayName == null) {
                Target.$$$reportNull$$$0(0);
            }
            super(displayName, icon);
            this.myTargetName = displayName;
        }

        protected Target(@NlsContexts.Label @NotNull String displayName, @NotNull Icon icon, @NotNull String targetName) {
            if (displayName == null) {
                Target.$$$reportNull$$$0(1);
            }
            if (icon == null) {
                Target.$$$reportNull$$$0(2);
            }
            if (targetName == null) {
                Target.$$$reportNull$$$0(3);
            }
            super(displayName, icon);
            this.myTargetName = targetName;
        }

        @NotNull
        protected String getTargetName() {
            String string = this.myTargetName;
            if (string == null) {
                Target.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/RunOnTargetComboBox$Target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$Target";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class Item {
        private final @NlsContexts.Label String displayName;
        private final Icon icon;

        public Item(@NlsContexts.Label String displayName, Icon icon) {
            this.displayName = displayName;
            this.icon = icon;
        }

        @NlsContexts.Label
        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

